package across.util.skn;

import across.data.PublicParams;

/**
 * Contains the level of interest that the meata-agent(s) has in this entity (alliance, agent or container).
 * Includes also the recomendations about publicParams to adopt to approach the entity.
 */
public abstract class SocialSubject implements Comparable
{
    
	/**Public params to have to approach the entity - entering the alliance, coalitions */
    protected PublicParams publicIdentity = null;
    /** Totalnumber of observations for the entity sent to meta-agent.*/
    protected long observedMessagesCount = 0;
    /** Cumulated opreciation of observations concerning this entity by meta-agent.*/
    protected double observationEvaluation = 0;
    /** level of interest the meta-agent has expressed for the entity*/
    protected double interest = 0;
    /** Determines if this subject is ready to negotiate with us, or plaily refuses any contact (true)*/
    protected boolean isHostile = false;

    /** Returns true if given entity is accessible, false if not. We consider the groups of agents to
     * be accessible if at least one member is accessible.
     * @return true if accessible, false if not
     */
    public abstract boolean isAccessible();



    /**
     * @param   o the Object to be compared.
     * @return  a negative integer, zero, or a positive integer as this object
     *		is less than, equal to, or greater than the specified object.
     *
     * @throws java.lang.ClassCastException if the specified object's type prevents it
     *         from being compared to this Object.
     */
    public int compareTo(Object o)
    {
        if (null != o)
        {
            SocialSubject other = (SocialSubject) o;
            if (interest < other.interest )
            {
                return -1;
            }
            else if (interest == other.interest && observationEvaluation < other.observationEvaluation)
            {
                return -2;
            }
            return 1;
        }
            // null is smallest value
            return 1;
    }

    public double getInterest()
    {
        return interest;
    }

    public void setInterest(double interest)
    {
        this.interest = interest;
    }

    public boolean isHostile()
    {
        return isHostile;
    }

    public PublicParams getPublicIdentity()
    {
        return publicIdentity;
    }

    public void setPublicIdentity(PublicParams publicIdentity)
    {
        this.publicIdentity = publicIdentity;
    }


}
