package across.util.skn;

import java.util.LinkedList;
import java.util.List;

import across.agents.transporter.TransporterAgent;
import aglobe.container.transport.Address;

/**
 * Contains the knowledge about one container, including the information about all interesting agents on it.
 * Includes also rating of the MA d
 */
public class ContainerKnowledge extends SocialSubject
{
    /** Name and address of the container */
    protected Address address;

    /** Accessibility state of the container. True if directly accessible to agent. */
    private boolean isAccessible;

    /** Contains list of all interesting agents on this container - one AgentKnowledge structure per agent.*/
    public List surveyedAgentList = new LinkedList();

    /** Contains list of all other than interesting agents known on this container - one AgentKnowledge structure per agent.*/
    public List otherAgentList = new LinkedList();

    /** Creates the new container and adds agent to the list of agents on the container.
     *
     * @param containerAddress address of the found container
     */
    public ContainerKnowledge(Address containerAddress)
    {
        address = containerAddress;
    }
    //TODO - wrong code, name will be allways void this way...

    /** Creates the new container and adds agent to the list of agents on the container.
     *
     * @param containerAddress address of the found container
     */
    public ContainerKnowledge(Address containerAddress, boolean isAccessible)
    {
        address = containerAddress;
        this.isAccessible = isAccessible;
    }


    /** Adds new agent to the list of agents on the container. If null, or already included, agent is not added. */
    public void addAgent(AgentKnowledge knownAgentOnContainer)
    {
        if ( null != knownAgentOnContainer && null != knownAgentOnContainer.publicParams && TransporterAgent.TYPE.equalsIgnoreCase(knownAgentOnContainer.publicParams.getType()))
        {
            if ( !surveyedAgentList.contains(knownAgentOnContainer) )
            {
                surveyedAgentList.add(knownAgentOnContainer);
            }
        }
        else
        {
            if ( !otherAgentList.contains(knownAgentOnContainer) )
            {
                otherAgentList.add(knownAgentOnContainer);
            }
        }
    }

    /**
     * Removes agent reference from the list of agents on the container. Used when agent dies or migrates.
     * @param removedAgent reference to the removedAgent structure.
     */
    public void removeAgent(AgentKnowledge removedAgent)
    {
        if (null != removedAgent.publicParams && TransporterAgent.TYPE.equalsIgnoreCase(removedAgent.publicParams.getType()))
        {
            surveyedAgentList.remove(removedAgent);
        }
        else
        {
            otherAgentList.remove(removedAgent);
        }
    }

    /**
     * Returns true if given entity is accessible, false if not. We consider the groups of agents to
     * be accessible if at least one member is accessible.
     *
     * @return true if accessible, false if not
     */
    public boolean isAccessible() {
        return isAccessible;
    }

    /**
     * Use this function to set the accessibility of the container.
     * @param b new accessibility - true accessible, false inaccessible
     */
    public void setAccessible(boolean b) {
        isAccessible = b;
    }
	
    public Address getAddress() {
		// TODO Auto-generated method stub
		return address;
	}
    /**
     * Returns the name of the container. 
     * @return containername part of the container address
     */
    public String getName() {
		// TODO Auto-generated method stub
		return address.getContainerName();
	}
}
