package across.util.skn;

import java.util.Iterator;

import across.data.Batch;
import across.data.CooperationResult;
import across.data.RequestList;
import across.data.TransportRequest;
import across.util.skn.util.membership.CrispMembership;
import aglobe.container.transport.Address;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.Message;
import aglobe.ontology.MessageConstants;

/**
 * Created by IntelliJ IDEA.
 * User: rehakm1
 * Date: 8.11.2004
 * Time: 16:00:50
 * To change this template use File | Settings | File Templates.
 */
public class AcrossCoalitionMemberKnowledge extends AcrossCoalitionKnowledge<TransportRequest>
{
        AgentKnowledge leader;

    /**
     * Used by CoalitionMember.
     * @param transportRequest
     * @param strategy
     * @param caller
     */
    public AcrossCoalitionMemberKnowledge(TransportRequest transportRequest, CoalitionKnowledge.Strategy strategy, CommunityKnowledge caller) {
        super(transportRequest, strategy, caller);
        // include the team leader into the coalition
        leader = caller.getAgent(transportRequest.getTeamLeader().getName());
        maxPayoff = transportRequest.getProposal().getTotalPrice();
        minPayoff = 0; // no penalties, worst case is no delivery, no money
        // we can not send team members at the beginning, they may not be able to receive request due to the inaccessibility
    }

    /**
     * Implement this to handle reception of Batch completion.
     * Will notify the leader about task partial completion.
     */
    public void transportCompleted(Batch batch)
    {
        Message m = Message.newInstance(MessageConstants.INFORM_DONE, caller.getOwnerAgentKnowledge().address, leader.address);
        m.setProtocol(MessageConstants.INFORM);
        m.setContent(batch);
        m.setReason(requestObject.getTransportCfp().getRequestid());
        try
        {
            caller.sendMessage(m);
        } catch (InvisibleContainerException e){}//TODO - handle inacc by re-sending or cumulation
    }

    /**
     * Implement this to handle reception of multiple batches completion.
     * Will notify the leader about task partial completion.
     */
    public void transportCompleted(RequestList req)
    {
        for (Iterator batchIter = req.getBatch().iterator(); batchIter.hasNext(); ) {
            Batch batch = (Batch)batchIter.next();
            this.transportCompleted(batch);
        }
    }

    /**
     * Implement this to handle reception of Batch loss due to the banditism, fraud or other illicit actions.
     * Will notify the leader about task partial failure.
     */
    public void transportFailed(Batch batch)
    {
        Message m = Message.newInstance(MessageConstants.FAILURE, caller.getOwnerAgentKnowledge().address, leader.address);
        m.setProtocol(MessageConstants.INFORM);
        m.setContent(batch);
        m.setReason(requestObject.getTransportCfp().getRequestid());
        try
        {
            caller.sendMessage(m);
        } catch (InvisibleContainerException e){}//TODO - handle inacc by re-sending or cumulation
    }

    /**
     * Implement this to handle reception of multiple batches loss due to the banditism, fraud or other illicit actions.
     * Will notify the leader about task partial failure.
     */
    public void transportFailed(RequestList req)
    {
        for (Iterator batchIter = req.getBatch().iterator(); batchIter.hasNext(); ) {
            Batch batch = (Batch)batchIter.next();
            this.transportFailed(batch);
        }
    }

    public double getTrustfulness() {
        double rat = actualPayoff/maxPayoff;
        return rat*rat;
    }

    /** Updates the payement and trust data.
     * Called when the cooperation was terminated.
     *
     */
    public void handleCoalitionTerminated(CooperationResult coor)
    {
        // determine the payoff...
        actualPayoff = coor.getPayement();
        //put the team members into the coalition set... leader is included already from the LeaderKnowledge
        for (Object o : coor.getTeamMember()) {
            AgentKnowledge m = caller.getAgent(((Address)o).getName());
            if (null != m)
            {
                new CrispMembership<AgentKnowledge>(m, this);
            }
        }
        // as we have the result and all participating members, we may update the trust now
        // update strategy is pre-specified
        updateMemberTrust();
        // remove the coalition from the social knowledge
        caller.removeCoalition(requestObject.getTransportCfp().getRequestid());
    }

    /** returns the address of coalition leader used to inform the leader about the progress */
    public Address getLeaderAddress()
    {
        return leader.address;
    };
}
