package across.util.skn;

import across.data.Batch;
import across.data.RequestList;

/**
 * Represents a coalition actions in Across.
 * This class is extended for members and leaders.
 */
public abstract class AcrossCoalitionKnowledge<CoalitionDefinition> extends CoalitionKnowledge<CoalitionDefinition>
{
    protected AcrossCoalitionKnowledge(CoalitionDefinition coalitionDefinition, CoalitionKnowledge.Strategy strategy, CommunityKnowledge caller)
    {
        super(coalitionDefinition, strategy, caller);
    }
    /** Implement this to handle reception of Batch completion */
    public abstract void transportCompleted(Batch batch);

    /** Implement this to handle reception of multiple batches completion */
    public abstract void transportCompleted(RequestList req);

    /** Implement this to handle reception of Batch loss due to the banditism, fraud or other illicit actions. */
    public abstract void transportFailed(Batch batch);

    /** Implement this to handle reception of multiple batches loss due to the banditism, fraud or other illicit actions. */
    public abstract void transportFailed(RequestList req);
}
