package across.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import across.data.Param;
import across.data.PossibleReply;
import across.data.interlingua.InterLinguaConclusion;
import across.data.interlingua.InterLinguaPrerequisite;
import across.data.interlingua.InterLinguaReply;
import across.data.interlingua.InterLinguaSentence;
import across.data.interlingua.InterLinguaSentences;

public class InterLinguaTools {
  private InterLinguaTools() {
  }

  public static List sentencesToStringList(InterLinguaSentences sentences) {
      List strings = new ArrayList(sentences.getInterLinguaSentence().size());
      for (Iterator iter = sentences.getInterLinguaSentence().iterator(); iter.hasNext(); ) {
        InterLinguaSentence sentence = (InterLinguaSentence) iter.next();
        strings.add(sentenceToString(sentence));
      }
      return strings;
  }

  public static String sentenceToString(InterLinguaSentence sentence) {
      StringBuffer bufQuery = new StringBuffer(500);

      List prerequisities = sentence.getInterLinguaPrerequisite();

      for (Iterator iter = prerequisities.iterator(); iter.hasNext(); ) {
          String item = translateLiteral( (InterLinguaPrerequisite) iter.next());
          bufQuery.append(item);
          if (iter.hasNext()) {
              bufQuery.append(" & ");
          }
      }

      if (sentence.getInterLinguaConclusion() != null) {
          bufQuery.append(" => ");
          bufQuery.append(translateLiteral(sentence.getInterLinguaConclusion()));
      }

      return bufQuery.toString();

  }

  private static String translateLiteral(InterLinguaConclusion literal) {
      return literal.getName() + "(" + getToken(literal.getArg1()) + ", " + getToken(literal.getArg2()) + ")";
  }

  private static String translateLiteral(InterLinguaPrerequisite literal) {
      return literal.getName() + "(" + getToken(literal.getArg1()) + ", " + getToken(literal.getArg2()) + ")";
  }


  public static InterLinguaConclusion createConclusion(String name, String arg1, String arg2) {
      InterLinguaConclusion preAgent = new InterLinguaConclusion();
      preAgent.setName(name);
      preAgent.setArg1(arg1);
      preAgent.setArg2(arg2);
      return preAgent;
  }

  public static InterLinguaPrerequisite createPrerequisite(String name, String arg1, String arg2) {
      InterLinguaPrerequisite preAgent = new InterLinguaPrerequisite();
      preAgent.setName(name);
      preAgent.setArg1(arg1);
      preAgent.setArg2(arg2);
      return preAgent;
  }

  protected static String getToken(String token) {
      if (token.charAt(0) != '?') {
          StringBuffer bufferPar = new StringBuffer(20);
          bufferPar.append('\"');
          bufferPar.append(token);
          bufferPar.append('\"');
          return bufferPar.toString();
      } else {
          return token;
      }
  }

  public static String getParamValue(List params, String paramName) {
      for (Iterator iter = params.iterator();
           iter.hasNext(); ) {
          Param param = (Param) iter.next();

          if (paramName.equalsIgnoreCase(param.getName())) {
              return param.getValue();
          }
      }
      return null;
  }


  public static List translateReply(InterLinguaReply reply) {
      List retList = new ArrayList(100);
      if (reply.getPossibleReply().isEmpty()) {
          retList.add("Not provable.");
      } else {
          for (Iterator iter = reply.getPossibleReply().iterator();
               iter.hasNext(); ) {
              PossibleReply possReply = (PossibleReply) iter.next();
              if (possReply.getParam().isEmpty()) {
                  retList.add("True");
              } else {
                  for (Iterator iter1 = possReply.getParam().iterator();
                       iter1.hasNext(); ) {
                      Param param = (Param) iter1.next();
                      retList.add(param.getName() + " = " +
                                  param.getValue());
                  }

              }
              if (iter.hasNext())
                  retList.add("----------------------------------------");
          }
      }
      return retList;
  }
}
