package across.simulation.objects;

import java.util.LinkedHashMap;

import across.data.simulation.EffectOnSimulationObject;
import across.data.simulation.SimulationObjectDescription;
import across.simulation.constants.AcrossControlConstants;
import across.simulation.constants.AcrossDataConstants;
import across.simulation.constants.AcrossSimulationConstants;
import across.simulation.constants.AcrossTopicConstants;
import across.visio.oldvisio.VisioConnectionAgent;
import aglobe.container.transport.Address;
import aglobe.service.gis.server.GISTopicServerListener;
import aglobe.util.AglobeXMLtools;
import aglobe.visio3D.PlanUpdate;
import aglobe.visio3D.VisioConstants;
import aglobe.visio3D.ontology.Chart;
import aglobex.simulation.entitysimulator.ControlLink;
import aglobex.simulation.entitysimulator.EntityBehaviour;
import aglobex.simulation.entitysimulator.EntityState;
import aglobex.simulation.global.EntityRecord;
import aglobex.simulation.ontology.WorldDimension;
import aglobex.simulation.ontology.entity.EntityDescriptor;
import aglobex.simulation.ontology.entity.EntityTypeDescriptor;
import aglobex.vecmath.Point3d;

public class ObjectBehaviour implements EntityBehaviour, GISTopicServerListener {

	/** Object's position in the world */
	private EntityState myState;
	
	/** x coordinate of the object */
	private double x;
	
	/** y coordinate of the object */
	private double y;
	
	/** z coordinate of the object */
	private double z;
	
	private ControlLink controlLink;
	
	/** Object' description - the state variables of the object */
	private SimulationObjectDescription sod;
	
	private EntityRecord entityRecord;
	
	/** The last time the object visio information was updated */
	private long lastVisioUpdate = 0;
	
	/** Is this object active? */
	private boolean active = true;
	
	/** How long is the object active. */
	private long activeTime = 0;
	
	private boolean terroristCreated = false;
	
	private long timeToCreateTer = 50000;
	
	/**
	 * Control does not have any influence.
	 */
	public void control(Object content, String reason) {
		// not implemented
	}

	public void dispose() {
		// TODO Auto-generated method stub
	}

	public void entityCrashed(EntityBehaviour otherObject, long fromTime) {

	}

	public PlanUpdate getPlanUpdate(boolean removeOld) {
		// TODO Auto-generated method stub
		return null;
	}

	/**
	 * Tries to find out the state (position) in the world.
	 */
	
	public void init(ControlLink controlLink, EntityRecord entityRecord, WorldDimension worldDimesion) throws Exception {
		this.controlLink = controlLink;
		this.entityRecord = entityRecord;
		sod = (SimulationObjectDescription) entityRecord.entityDescriptor.confObjects.get(AcrossDataConstants.SIMULATION_OBJECT_DESCRIPTION);
		x = sod.getX(); 
		y = sod.getY();
		z = sod.getZ();
		Point3d p = new Point3d(x,y,z);
		myState = new EntityState();
		myState.position = p;
		controlLink.getGISShell().sendTopicToLocal(VisioConnectionAgent.TOPIC_VISIO_INFO, ""+entityRecord.containerName,entityRecord.containerName);
		controlLink.getGISShell().subscribeTopic(AcrossTopicConstants.TOPIC_SIMULATION_OBJECT, this);
	}

	/**
	 * Returns the same state over and over.
	 */
	public EntityState updateEntityState(long timeStep, long currentSimulationTimestamp) {
		activeTime +=timeStep;
		if(currentSimulationTimestamp-lastVisioUpdate>=1000) {
			Chart chart = new Chart();
			chart.getContent().add(AglobeXMLtools.makeSimpleBar("Insurgency", getColorForNumber(sod.getInsurgencyLevel()), (byte) (sod.getInsurgencyLevel()*255/100)));
			chart.getContent().add(AglobeXMLtools.makeSimpleBar("Damage", getColorForNumber(sod.getConstructionDamage()), (byte) (sod.getConstructionDamage()*255/100)));
			chart.getContent().add(AglobeXMLtools.makeSimpleBar("Fire", getColorForNumber(sod.getExtentOfFire()), (byte) (sod.getExtentOfFire()*255/100)));
			chart.getContent().add(AglobeXMLtools.makeSimpleBar("Wounded", getColorForNumber(sod.getNumberOfWounded()), (byte) (sod.getNumberOfWounded()*255/100)));
			controlLink.getGISShell().sendTopicToLocal(VisioConnectionAgent.TOPIC_SET_CHART, chart, entityRecord.containerName);
			lastVisioUpdate = currentSimulationTimestamp;
		}
		if(sod.getInsurgencyLevel()>=30 && activeTime>=timeToCreateTer && !terroristCreated) {
			terroristCreated = true;
			String location = getCloserLocation();
			if(location!=null) {
				controlLink.getGISShell().sendTopicToLocal(AcrossTopicConstants.TOPIC_AGENT, newTerrorist(location), AcrossControlConstants.CREATE_AGENT);
			}
		}
		return myState;
	}
	
	/**
	 * Gets bar color for number.
	 * @param number
	 * @return
	 */
	private byte getColorForNumber(int number) {
		if(number>=66) {
			return VisioConstants.COMMUNICATION_COLOR_RED;
		} else if(number>=33) {
			return VisioConstants.COMMUNICATION_COLOR_YELLOW;
		} else {
			return VisioConstants.COMMUNICATION_COLOR_GREEN;
		}
	}

	/**
	 * Not implemented.
	 */
	public void handleLoginTopic(String topic, String remoteContainerName, Address remoteContainerAddress) {
				
	}

	/**
	 * Not implemented.
	 */
	public void handleLogoutTopic(String topic, String remoteContainerName) {
		
	}

	/**
	 * Handles incoming topics.
	 */
	public void handleTopic(String topic, Object content, String reason, String remoteContainerName, Address remoteClientAddress) {
		if(topic.equalsIgnoreCase(AcrossTopicConstants.TOPIC_SIMULATION_OBJECT)) {
			if(reason.equalsIgnoreCase(AcrossSimulationConstants.OBJECT_DESCRIPTION) && content.equals(entityRecord.containerName)) {
				if(active) {
					controlLink.getGISShell().sendTopic(remoteContainerName, AcrossTopicConstants.TOPIC_SIMULATION_OBJECT, sod, AcrossSimulationConstants.OBJECT_DESCRIPTION);
				}
			} else if(reason.equalsIgnoreCase(AcrossControlConstants.CHANGE_SIMULATION_OBJECT)) {
				EffectOnSimulationObject eff = (EffectOnSimulationObject) content;
				if(eff.objectName.equals(entityRecord.containerName)) {
					active = applyEffect(eff);
					if(!active) {
						System.out.println("+++++++++++++ OBJECT"+ entityRecord.containerName +" REMOVED ++++++++++++++++++");
						controlLink.destroyEntity();
					}
				}
			}
		}
	}

	public void addEvent(Runnable e) {
		if(!active) {
			return;
		}
		controlLink.addEvent(e);
	}

	/**
	 * Applies an effect on this object.
	 * @param effect
	 * @return true if the object is still active
	 */
	protected boolean applyEffect(EffectOnSimulationObject effect) {
		boolean damage = sod.adjustConstructionDamage(effect.constructionDamageDiff);
		boolean fire = sod.adjustFireExtent(effect.fireDiff);
		boolean insrg = sod.adjustInsurgencyLevel(effect.insurgencyDiff);
		boolean wound = sod.adjustNumberOfWounded(effect.woundedDiff);
		return !(damage && fire && insrg && wound);
	}
	
	/** Creates a new terrorist agent. */
	protected EntityRecord newTerrorist(String location) {
		EntityRecord er = new EntityRecord();
		EntityDescriptor ed = new EntityDescriptor();
		EntityTypeDescriptor etd = new EntityTypeDescriptor();
		etd.typeName = "TERRORIST_DRIVER_ENTITY_TYPE";
		ed.confParamsString = new LinkedHashMap<String, String>();
		ed.confParamsString.put("ENTITY_START_NODE", location);
	    ed.confParamsString.put("ENTITY_VISIO_NAME", ""+System.currentTimeMillis());
	    ed.confParamsString.put("ENTITY_VISIO_OBJECT", "CAR");
	    ed.confParamsString.put("ENTITY_VISIO_TEXTURE", "TEXTURE_CAR_KABINA_TEXTURE05");
	    ed.confParamsString.put("VEHICLE_VELOCITY","0.100000");
	    ed.confParamsString.put("VEHICLE_CONSUMPTION","23");
	    ed.confParamsString.put("VEHICLE_CAPACITY","1000");
	    ed.typeDescriptor = etd;
	    er.entityDescriptor = ed;
	    return er;
	}
	
	protected String getCloserLocation() {
		String loc1 = sod.getLocation().endLocation;
		String loc2 = sod.getLocation().startLocation;
		if(loc1.indexOf("Node")!=-1) {
			return loc1;
		} else if (loc2.indexOf("Node")!=-1) {
			return loc2;
		} else {
			return null;
		}
	}
	
}


