package across.simulation.constants;

/**
 * Across specific topic constants.
 * @author Eduard Semsch
 *
 */
public interface AcrossTopicConstants {
	
	/** This topic requests sending weather updates */
	public static final String TOPIC_WEATHER_UPDATE_REQUEST = "TOPIC_WEATHER_UPDATE_REQUEST";
	
	/** This topic is used by the WeatherAgent to distribute the weather information. Content across.data.Weather */
	public static final String TOPIC_WEATHER_UPDATE = "TOPIC_WEATHER_UPDATE";
	
	/** Topic about duration of disaster Content - disaster name, Reason - one of the AcrossWeatherConstants.WEATHER_DISASTER_*/
	public static final String TOPIC_DISASTER_VISIBILITY = "TOPIC_DISASTER_VISIBILITY";

	/** 
	 * Topics for handling the simulation objects and communication with them: 
	 * <li> for object description send this topic with reason 
	 * AcrossSimulationConstants.OBJECT_DESCRIPTION and content the object name.
	 * <li> for altering the object sent this topic with reason AcrossControlConstants.CHANGE_SIMULATION_OBJECT and
	 * content of class EffectOnSimulationObject 
	 * <li> for creating a new object send this topic with reason AcrossControlConstants.CREATE_SIMULATION_OBJECT and
	 * content of class SimulationObject
	 */
	public static final String TOPIC_SIMULATION_OBJECT = "TOPIC_SIMULATION_OBJECT";
	
	/**
	 * Topics for handling the simulation agents:
	 * <li> for agent creation send this topic with reason AcrossControlConstants.CREATE_AGENT and content
	 * EntityRecord. </li>
	 * <li> for agent destruction send this topic with reason AcrossControlConstants.REMOVE_AGENT and
	 * content String - container name. </li>
	 */
	public static final String TOPIC_AGENT = "TOPIC_AGENT";
}
