package across.data.simulation;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;

/**
 * This object represents the location of the object on the map.  It has two
 * parameters - the start and end location - this is because the object
 * can be located on the road between the nodes of the map.  If the start
 * and end locations are the same, the object lies precisely in the node.
 * @author Eduard Semsch
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name="SimulationObjectLocation",propOrder={})
public class SimulationObjectLocation implements Serializable {

	@XmlAttribute(name="startLocation")
	public String startLocation;
	
	@XmlAttribute(name="endLocation")
	public String endLocation;
	
	public SimulationObjectLocation() {}
	
	public String getEndLocation() {
		return endLocation;
	}

	public void setEndLocation(String endLocation) {
		this.endLocation = endLocation;
	}

	public String getStartLocation() {
		return startLocation;
	}

	public void setStartLocation(String startLocation) {
		this.startLocation = startLocation;
	}
	
}
