
package across.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

/*
  String
  List<RequestList>
*/
/**
 * Specifies a location and possibly a list of request lists, that should be delivered to this location - semsch???
 * @author Eduard Semsch
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name="Waypoint",propOrder={"RequestList"})
public class Waypoint implements Serializable {

	@XmlAttribute(name="LocationName")
    private String LocationName;
	@XmlElement(name="RequestList")
    private List<RequestList> RequestList;
	
	public Waypoint(String locationName) {
		this.LocationName = locationName;
	}
	
	public String getLocationName() {
		return LocationName;
	}
	public void setLocationName(String locationName) {
		LocationName = locationName;
	}
	public List<RequestList> getRequestList() {
		if(RequestList == null) {	
			RequestList = new ArrayList<RequestList>();
		}
		return RequestList;
	}
	public void setRequestList(List<RequestList> requestList) {
		RequestList = requestList;
	}
	
	public String toString() {
        StringBuffer sb = new StringBuffer("<<Waypoint");
        sb.append(" locationName=");
        sb.append(LocationName.toString());
        sb.append(" RequestList=");
        if(RequestList!= null && RequestList.size()>0) {
        	sb.append(RequestList.toString());
        }
        sb.append(">>");
        return sb.toString();
    }
}