
package across.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

import aglobe.container.transport.Address;

/*
  TransportCfp
  Proposal
  Address
  List<Address>
*/
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name="TransportRequest",propOrder={"TransportCfp","Proposal","TeamLeader","TeamMember"})
public class TransportRequest implements Serializable {

	@XmlElement(name="TransportCfp")
    private TransportCfp TransportCfp;
	@XmlElement(name="Proposal")
    private Proposal Proposal;
	@XmlElement(name="TeamLeader")
    private Address TeamLeader;
	@XmlElement(name="TeamMember")
    private List<Address> TeamMember;
	public Proposal getProposal() {
		return Proposal;
	}
	public void setProposal(Proposal proposal) {
		Proposal = proposal;
	}
	public Address getTeamLeader() {
		return TeamLeader;
	}
	public void setTeamLeader(Address teamLeader) {
		TeamLeader = teamLeader;
	}
	public List<Address> getTeamMember() {
		if(TeamMember ==  null) {
			TeamMember = new ArrayList<Address>();
		}
		return TeamMember;
	}
	public void setTeamMember(List<Address> teamMember) {
		TeamMember = teamMember;
	}
	public TransportCfp getTransportCfp() {
		return TransportCfp;
	}
	public void setTransportCfp(TransportCfp transportCfp) {
		TransportCfp = transportCfp;
	}
}