
package across.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

/*
  List<Waypoint>
*/
/**
 * A set of waypoints that something should go through.
 * @author Eduard Semsch
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name="TransportOrder",propOrder={"Waypoint"})
public class TransportOrder implements Serializable {

	@XmlElement(name="Waypoint")
    private List<Waypoint> Waypoint;

	public List<Waypoint> getWaypoint() {
		if(Waypoint==null) {
			Waypoint = new ArrayList<Waypoint>();
		}
		return Waypoint;
	}

	public void setWaypoint(List<Waypoint> waypoint) {
		Waypoint = waypoint;
	}
	
	public String toString() {
        StringBuffer sb = new StringBuffer("<<TransportOrder");
        if (Waypoint.size()>0) {
            sb.append(" Waypoint=");
            sb.append(Waypoint.toString());
        }
        sb.append(">>");
        return sb.toString();
    }
}