
package across.data;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;

/*
  long
  double
  String
*/
/**
 * This class expresses that something with some location is this much done (in per cents).
 *
 * @author Eduard Semsch
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name="ItemCoverage",propOrder={})
public class ItemCoverage implements Serializable {

	@XmlAttribute(name="Itemid")
    private long Itemid;

    @XmlAttribute(name="Coverage")
    private double Coverage;

    @XmlAttribute(name="Location")
    private String Location;

	public double getCoverage() {
		return Coverage;
	}

	public void setCoverage(double coverage) {
		Coverage = coverage;
	}

	public long getItemid() {
		return Itemid;
	}

	public void setItemid(long itemid) {
		Itemid = itemid;
	}

	public String getLocation() {
		return Location;
	}

	public void setLocation(String location) {
		Location = location;
	}
	
	public String toString() {
        StringBuffer sb = new StringBuffer("<<ItemCoverage");
        sb.append(" itemid=");
        sb.append(Long.toString(Itemid));
        sb.append(" coverage=");
        sb.append(Double.toString(Coverage));
        sb.append(" location=");
       	sb.append(Location);
        sb.append(">>");
        return sb.toString();
    }
    
}