
package across.agents.transporter.util.checker;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

import across.agents.transporter.TransporterAgent;
import across.data.Node;
import across.data.Page;
import across.data.Resource;
import across.data.TransportBatch;
import across.data.TransportCfp;
import across.util.InterLinguaTools;
import across.util.skn.AgentKnowledge;
import aglobe.container.transport.Address;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.AglobeParam;

/**
 * This class is for checking the restrictions on building the alliances - semsch???
 */
public class DebugRestrictionsChecker
    implements RestrictionsChecker {

  TransporterAgent owner;

  int restrictionType = 0;

  String[] alliance = {"CheetahTransporter","LlamaTransporter","EagleTransporter","WhaleTransporter","CamelTransporter","SnakeTransporter","LionTransporter","TigerTransporter"};

  public DebugRestrictionsChecker(TransporterAgent owner) {
      this.owner = owner;
  }
  public boolean acceptAllianceMember(AgentKnowledge member) {
      String myRegion = getMyRegion();
      String memberRegion = getAgentRegion(member.getName());
      String memberTribe = getAgentTribe(member.getName());

      switch (restrictionType) {
          case (0):
              boolean allOk = true; // both (or none) me and member have to be in alliance list
              for (String allMem : alliance) {
                  if (allMem.equals(owner.getName()))
                      allOk = !allOk;

                  if (allMem.equals(member.address.getName()))
                      allOk = !allOk;
              }
              return allOk;
//              return true;
          case (1):
              return myRegion.equals(memberRegion);
      }
      return true;

  }

    /**
   * acceptTeamLeader
   *
   * @param teamLeader Address
   * @return boolean
   * @todo Implement this across.transporter.RestrictionsChecker method
   */
  public boolean acceptTeamLeader(Address teamLeader) {
    return true;
  }

  public boolean acceptRequestedServices(TransportCfp requestedServices) {
       for (TransportBatch batch :
           (List<TransportBatch>) requestedServices.getTransportBatch()) {
          String startTribe = getCityTribe(batch.getStart());
          String targetTribe = getCityTribe(batch.getTarget());
          String startRegion = getCityRegion(batch.getStart());
          String targetRegion = getCityRegion(batch.getTarget());
          String myTribe = InterLinguaTools.getParamValue(owner.publicParams.
              getParam(), "tribe");
          String myRegion = InterLinguaTools.getParamValue(owner.publicParams.
              getParam(), "region");

          switch (restrictionType) {
              case (0):
                  if (myTribe.equals("Northlanders") && targetTribe.equals("Southlanders"))
                      return false;
                  if (myTribe.equals("Southlanders") && targetTribe.equals("Northlanders"))
                      return false;
                  if (!myRegion.equals("Eastern") && targetRegion.equals("Eastern"))
                      return false;
                  return true;
              case (1):
//                  if (myTribe.equals("Southlanders") && !startTribe.equals("Southlanders"))
//                      return false;
                  if ((myRegion.equals("Western")) && !targetTribe.equals("Southlanders"))
                      return false;
                  if ((!myRegion.equals("Western")) && targetTribe.equals("Southlanders"))
//                  if ((!myRegion.equals("Western")) && targetTribe.equals("Northlanders"))
                      return false;
//                  if ((!myTribe.equals(startTribe)) && (!myTribe.equals(targetTribe)))
//                      return false;
                  return true;
          }
      }
      return true;
  }

  /**
   * acceptTeamMember
   *
   * @param member Address
   * @return boolean
   * @todo Implement this across.transporter.RestrictionsChecker method
   */
  public boolean acceptTeamMember(Address member) {
      String memberTribe = getAgentTribe(member.getName());
      String memberRegion = getAgentRegion(member.getName());
      String myTribe = InterLinguaTools.getParamValue(owner.publicParams.getParam(), "tribe");
      String myRegion = InterLinguaTools.getParamValue(owner.publicParams.getParam(), "region");

      switch (restrictionType) {
          case (0):
              if ("HippoTransporter".equals(owner.getName()))
                  return false;
              if (!myTribe.equals("Southlanders") &&
                  memberTribe.equals("Southlanders"))
                  return false;

              if (myTribe.equals("Southlanders") && memberTribe.equals("Northlanders"))
                  return false;
              return true;
          case (1):
              if (myRegion.equals("Western") && memberTribe.equals("Southlanders")) {
                  return false;
              }
              if ((!myRegion.equals("Western")) && memberTribe.equals("Northlanders")) {
                  return false;
              }
//              if (myTribe.equals("Central") && memberTribe.equals("Southlanders"))
//                  return false;
//              if (!myTribe.equals(memberTribe)) {
//                  return false;
//              }
      }
      return true;
  }

  public void agentPageUpdated(Page page) {
  }

  /**
   * Loads the restrictions from the configuration file.
   */
  public void loadRestrictions(String filePath, AgentInfo agentInfo) {
      for (AglobeParam item : (List<AglobeParam>) agentInfo.getAglobeParam()) {
        if (item.getName().equals("debugRestrictionType")) {
            restrictionType = Integer.parseInt(item.getValue());
            break;
        }
      }
  }


  private String getMyRegion() {
      return getMyParam("region");
  }

  private String getMyParam(String paramName) {
      return InterLinguaTools.getParamValue(owner.publicParams.getParam(), paramName);
  }

    private String getAgentLocation(String agentName) {
      return InterLinguaTools.getParamValue(owner.getCommunity().getAgent(agentName).publicParams.getParam(), "location");
    }

    private String getAgentTribe(String agentName) {
        return getCityTribe(getAgentLocation(agentName));
    }

    private String getAgentRegion(String agentName) {
        return getCityRegion(getAgentLocation(agentName));
    }

      private String getCityTribe(String cityName) {
          return getCityParam(cityName, "tribe");
      }

      private String getCityRegion(String cityName) {
          return getCityParam(cityName, "region");
      }

      private String getCityParam(String cityName, String paramName) {
          for (Node node : (List<Node>) owner.acrossMapNodes.getNode()) {
              if (node.getName().equals(cityName)) {
                  return InterLinguaTools.getParamValue(node.getParam(), paramName);
              }
          }
          return null;
      }

      private String getMyTribe() {
          return getMyParam("tribe");
      }
      
      public Collection<String> getAvailableActions(Resource res) {
    		return new LinkedList<String>();
    	}
}
