package across.agents.transporter.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

import across.data.Resource;
import across.data.TransportBatch;
import across.data.TransportCfp;
import across.util.GoodsConstants;

public class TransporterUtils {

	/**
	   * getRequestedResources - transform cfp to requested resources. returns
	   * List of Resource objects, one per each cargo type required Name - same as
	   * in semi-private knowledge
	   *
	   * @param cfp TransportCfp
	   * @param securityCoeficient double
	   * @return Collection of all required resources, it may include members
	   *   with 0 caopacity...
	   */
	  public static Collection getRequestedResources(TransportCfp cfp, double securityCoeficient) {
	        // this list will contain capacities per cargo type.
	        Map capacities = GoodsConstants.getCargoTypesResourceMap();
	        for (Iterator iterator = cfp.getTransportBatch().iterator(); iterator.hasNext();)
	        {
	            TransportBatch batch = (TransportBatch) iterator.next();
	            Resource res = (Resource) capacities.get(GoodsConstants.resolveType(batch.getComodityName()));
	            res.setCapacity(res.getCapacity() + Math.round(batch.getCount()*securityCoeficient));
	            res.setLastLocation(batch.getStart());
	            res.setNextLocation(batch.getTarget());
	            res.setLastLocationTime(batch.getStartTime());
	            res.setAvailabilityTime(batch.getTargetTime());
	        }
	        return capacities.values();
	    }

}
