package across.agents.transporter.task;

import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

import across.agents.transporter.TransporterAgent;
import across.data.Batch;
import across.data.ItemCoverage;
import across.data.Proposal;
import across.data.RequestList;
import across.data.Resource;
import across.data.TransportBatch;
import across.data.TransportCfp;
import across.data.TransportOrder;
import across.data.TransportRequest;
import across.data.Waypoint;
import across.util.GoodsConstants;
import across.util.ListBatchTools;
import across.util.skn.AcrossCoalitionMemberKnowledge;
import across.util.skn.AgentKnowledge;
import across.util.skn.CoalitionKnowledge;
import aglobe.container.transport.Address;
import aglobe.ontology.Message;

/**
 * This task is used upon reception of Proposal acceptance from team leader.
 * It will allocate the resources to fulfill the contract by querying drivers.
 */
public class TransportAcceptedTask extends aglobex.protocol.request.RequestParticipantTask
{
    TransporterAgent myAgent;

    /** Counter for reply counting from drivers queryRef */
    long expectedReplies = 0;
    /** Counter for reply counting from drivers queryRef */
    long replied = 0;
    /**prepare map where we put results received from drivers - key driver address, content of the Message from driver*/
    SortedMap props = new TreeMap(new PropComparator());

    /**
     * starts fipa request protocol. If autoprocess is <code>false</code> processRequest method is not called.
     * @param owner owner of this task - needed for sending messages
     * @param requestMessage the recieved request message
     * @param autostart boolean
     */
    public TransportAcceptedTask(TransporterAgent owner, Message requestMessage, boolean autostart)
    {
        super(owner, requestMessage, autostart);
        myAgent = owner;
        start();
    }

    /**
     * Is called when requst comes.
     * Can call agree or refuse methods to reply to this message.
     * @param requestMessage
     */
    protected void processRequest(Message requestMessage) {

        Object content = requestMessage.getContent();

        assert content instanceof TransportRequest : content.getClass().getName();

        // agree to fulfill request
        agree();
        TransportRequest tr  = (TransportRequest)content;
        // create coalition record in the community knowledge

        AcrossCoalitionMemberKnowledge cmkn = new AcrossCoalitionMemberKnowledge(tr, CoalitionKnowledge.Strategy.FLAT, myAgent.community);
        if (myAgent.community.appendCoalition(tr.getTransportCfp().getRequestid(), cmkn)) {
          try {
                FileOutputStream out = new FileOutputStream(CNPTransportBidAnswer.coalitionPath + myAgent.getName(), true);
                PrintStream p = new PrintStream(out);
                long coalMemCount = tr.getTeamMember().size();
                p.println("member of " + tr.getTransportCfp().getRequestid() + " time: " + myAgent.getTime()+ " count: "+coalMemCount);
                p.close();
              }
              catch (Exception e) {
                //System.err.println("Error writing to file");
              }
        }


        final Proposal prop = tr.getProposal();
        if (null != prop)
        {
            TransportCfp tcfp = tr.getTransportCfp(); // this shal include only the part of the proposal previously assigned to the agent
            // prepare a list of batches to handle by this transporter's resources, integrating the coverage data
            final List tBatches = new LinkedList();
            // put here list of all resources necessary for different batches
            Map resNeed = GoodsConstants.getCargoTypesResourceMap();
            for (Iterator tcfpit = tcfp.getTransportBatch().iterator();
                 tcfpit.hasNext(); ) {
                TransportBatch tb = (TransportBatch) tcfpit.next();
                for (Iterator covit = prop.getItemCoverage().iterator(); covit.hasNext(); ) {
                    ItemCoverage tic = (ItemCoverage) covit.next();
                    if (tic.getItemid() == tb.getBatchid() && tic.getCoverage() > 0 &&
                            tb.getCount() > 0) {
                        long cap = (long) Math.floor(tic.getCoverage() * tb.getCount());
                        tBatches.add(ListBatchTools.copyTransportBatch(tb, cap));
                        Resource res = (Resource) resNeed.get(GoodsConstants.resolveType(tb.
                                getComodityName()));
                        res.setCapacity(res.getCapacity() + cap);
                        break;
                    }
                }
            }
            // now, we have what we must transport and resource types wee need - we may construct a query for driver agents

            // petr consider fraud
           // petr boolean fraud = Math.random()>0.5 ? true : false;

            // we assume that all batches have the same start and destination
            final String start = ( (TransportBatch) tcfp.getTransportBatch().get(0)).
                    getStart();
            final Address startAddress = ( (TransportBatch) tcfp.getTransportBatch().
                    get(0)).getStartAddress();
            String t = ( (TransportBatch) tcfp.getTransportBatch().get(0)).
                    getTarget();
            final Address targetAddress = ( (TransportBatch) tcfp.getTransportBatch().
                    get(0)).getTargetAddress();
            // consider fraud          // petr

            boolean f = false;
            if (Math.random() < myAgent.fraudProbability) { //!!!!!!!! pozor falesna adresa se nesmi shodovat se skutecnou adresou vykladky, jinak neni povazovane za defraudovane
              t = myAgent.getContainer().getContainerName();
              f = true;
            }
            final boolean fraud = f;
            final String target = t;

            // prepare blank to for query
            TransportOrder to;
//            if (fraud) {
//               to = prepareFraudSimpleTransportOrder(tBatches,
//                  start, startAddress, target, targetAddress, prop.getRequestid(),
//                  myAgent);
//            } else {
              to = prepareSimpleTransportOrder(tBatches,
                 start, startAddress, target, targetAddress, prop.getRequestid(),
                 myAgent);
//            }

            // we count number of expected replyes before queryrefinitiatortasks start,
            // because a task can be finished before all tasks are started
            for (Iterator resit = myAgent.privateParams.getResource().iterator(); resit.hasNext(); ) {
              Resource res = (Resource) resit.next();
              AgentKnowledge dr = myAgent.community.getAgent(res.getResid());
              if (null != dr) {
                if ( ( (Resource) resNeed.get(res.getType())).getCapacity() > 0) {
                  expectedReplies++;
                }
              }
            }

            // iterate thorugh drivers with good type and ask them for quotation
            for (Iterator resit = myAgent.privateParams.getResource().iterator(); resit.hasNext(); ) {
                Resource res = (Resource) resit.next();
                //myAgent.getLogger().warning(res.getResid());
                AgentKnowledge dr = myAgent.community.getAgent(res.getResid());
                // checks if the driver agent has already started or not and if it is accessible
                if (null != dr )//TODO - it doesn't work now... && dr.container.isAccessible
                {
                    Address drAdd = dr.address;
                    // check if the driver is usefull - good type
                    if ( ( (Resource) resNeed.get(res.getType())).getCapacity() > 0) {
                        // query the driver
                        (new aglobex.protocol.queryref.QueryRefInitiatorTask(myAgent, drAdd, to, false) {
                            protected void informResult(Object result) {
                                props.put(result, participant);
                                replied();
                            }
                            protected void queryRefused() {
                                replied();
                            }
                            protected void timeout() {
                                replied();
                            }
                            protected void replied() {
                                replied++;
                                cancelTask();
                                if (replied == expectedReplies) {
                                    evaluateDriverReplies(tBatches, start, startAddress, target, targetAddress, prop.getRequestid(), fraud);
                                }
                            }
                        }).start();
                    }
                }
            }
            // solves problems with no available drivers
            if (0 == expectedReplies)
            {
                failure("No resource Available.");
                myAgent.getLogger().info(myAgent.getName() + ": No driver available when some expected.");
            }
        }
    }


    /** Evaluates the replies from drivers as stored in instance variable.
     * Prepares and sends the requests to picked drivers*/
    private void evaluateDriverReplies(List tBatches, String start, Address startAddress, String target, Address targetAddress, String locationReqId, boolean fraud) {
       List data = new LinkedList();
       data.add(locationReqId);

        // iterate through the proposals as received from drivers, ordered from fastest
        for (Iterator pit = props.entrySet().iterator(); pit.hasNext();)
        {
            Map.Entry entry = (Map.Entry) pit.next();
            Address addr = (Address) entry.getValue();


            String resId = addr.getName();

            data.add(resId);


            long capacity = 0;
            Resource driverRes = null;
            // identify the resource record to determine type and capacity
            for (Iterator carit = myAgent.privateParams.getResource().iterator(); carit.hasNext();)
            {
                Resource car = (Resource) carit.next();
                if (resId.equalsIgnoreCase(car.getResid()))
                {
                    capacity = car.getCapacity();
                    driverRes = car;
                    break;
                }
            }

            if (capacity == 0) continue;       // this driver is fully loaded
            // prepare new transport order
            TransportOrder to;
            if (!fraud) {
              to = prepareSimpleTransportOrder(null, start, startAddress,
                                                              target, targetAddress,
                                                              locationReqId, myAgent);
            } else {
              to = prepareFraudSimpleTransportOrder(null, start, startAddress,
                                                              target, targetAddress,
                                                              locationReqId, myAgent);
            }
            boolean isBatchSet = false;

            for(int i = 0; i<tBatches.size(); i++){
                if (capacity == 0) break; // driver was fully loaded
                TransportBatch tb = (TransportBatch)tBatches.get(i);
                String batchType = GoodsConstants.resolveType(tb.getComodityName());
                if (!batchType.equals(driverRes.getType())) continue;  // this driver is not able to transport this type of cargo
                // take this batch from the start to the target location
                Batch batchStart = new Batch();
                batchStart.setBatchid(tb.getBatchid());
                batchStart.setComodityName(tb.getComodityName());
                batchStart.setDeliveryTime(tb.getStartTime());
                Batch batchTarget = new Batch();
                batchTarget.setBatchid(tb.getBatchid());
                batchTarget.setComodityName(tb.getComodityName());
                batchTarget.setDeliveryTime(tb.getTargetTime());
                if (capacity >= tb.getCount()) {               // driver is able to load whole batch
                    batchStart.setCount(tb.getCount());
                    batchTarget.setCount(-tb.getCount());
                    capacity-=tb.getCount();  // decrease the available capacity
                    tBatches.remove(tb);      // remove the batch from the list of batches
                    i--;
                }
                else {                                              // only the part of the batch can be loaded
                    tb.setCount(tb.getCount()-capacity);  // decrease the remaining amount of cargo in the batch
                    batchStart.setCount(capacity);        // load as much as possible
                    batchTarget.setCount(-capacity);      // unload this part of the batch
                    capacity = 0;
                }
                isBatchSet = true;                                  // at least one batch was assigned to this driver, message would be send
                ((RequestList)((Waypoint)to.getWaypoint().get(0)).getRequestList().get(0)).getBatch().add(batchStart);                 // add batches to the batch lists
                ((RequestList)((Waypoint)to.getWaypoint().get(1)).getRequestList().get(0)).getBatch().add(batchTarget);
            }
            if (isBatchSet) {
                // send the transport order request message

                TransportRequestTask trt = new TransportRequestTask(myAgent, addr, to);
                trt.start();    // start task
                // mark the resource (car) as being currently in use
                driverRes.setAvailabilityTime(Long.MAX_VALUE);
            }
        }
        // the request has been fulfilled
        //TODO - send failure here if we didn't succeed to allocate the transport
        informDone();
        myAgent.gisShell.submitTopicToServer(across.visio.oldvisio.VisioConnectionAgent.TOPIC_VISIO_ACTION, Byte.toString(across.visio.oldvisio.VisioConnectionAgent.ACTION_TRANSPORT_START) ,myAgent.getAddress().toString());
        // update the semiPrivateInformation for other alliance members
        myAgent.setupSemiPrivateFromPrivate();
        myAgent.broadcastSemiPrivateToAlliance();
    }


    public static TransportOrder prepareFraudSimpleTransportOrder(List tBatches, String start, Address startAddress, String target, Address targetAddress, String locationReqId, TransporterAgent myAgent) {
      TransportOrder to = prepareSimpleTransportOrder(tBatches, start, startAddress, target, targetAddress, locationReqId, myAgent);
      List waypoints = to.getWaypoint();
      Waypoint targetwp = (Waypoint)waypoints.get(1);
      List targetList = (List)targetwp.getRequestList();
      for (Iterator i = targetList.iterator(); i.hasNext();) {
        RequestList rl = (RequestList)i.next();
        rl.setRequestTime(-1);
      }
      return to;
    }


    /**
     * Prepares a simple transport order with all requests between one agent in a single start location and another agent
     * in target location.
     * @param tBatches  batches to transport, may be null if the batches will be added later
     * @param start start location (map name)
     * @param startAddress address of the agent to load from
     * @param target target location (map name)
     * @param targetAddress adress of the target agent
     * @return prepared transport order
     */
    public static TransportOrder prepareSimpleTransportOrder(List<TransportBatch> tBatches, String start, Address startAddress, String target, Address targetAddress, String locationReqId, TransporterAgent myAgent)  {
        TransportOrder to = new TransportOrder();
        Waypoint wpStart = new Waypoint(start);
        Waypoint wpTarget = new Waypoint(target);
        RequestList rlStart = new RequestList();
        RequestList rlTarget = new RequestList();
        rlStart.setRequestid(locationReqId); // petr

        rlStart.setRequestTime(myAgent.getTime());
        rlStart.setDeliveryLocation(start);
        rlStart.setDeliveryAddress(startAddress);
        rlTarget.setRequestid(locationReqId); // petr

        rlTarget.setRequestTime(myAgent.getTime());
        rlTarget.setDeliveryLocation(target);
        rlTarget.setDeliveryAddress(targetAddress);
        wpStart.getRequestList().add(rlStart);
        wpTarget.getRequestList().add(rlTarget);
        to.getWaypoint().add(wpStart);
        to.getWaypoint().add(wpTarget);
        if (null != tBatches)  {
            for (TransportBatch tb : tBatches) {
                Batch batchStart = new Batch();
                batchStart.setBatchid(tb.getBatchid());
                batchStart.setComodityName(tb.getComodityName());
                batchStart.setDeliveryTime(tb.getStartTime());
                batchStart.setCount(tb.getCount());
                Batch batchTarget = new Batch();
                batchTarget.setBatchid(tb.getBatchid());
                batchTarget.setComodityName(tb.getComodityName());
                batchTarget.setDeliveryTime(tb.getTargetTime());
                batchTarget.setCount(-tb.getCount());
                rlStart.getBatch().add(batchStart);
                rlTarget.getBatch().add(batchTarget);
            }
        }
        return to;
    }

}
/** Used to compare two proposals received from drivers. Compares by time and price */
class PropComparator implements Comparator {
    /**
     * Compares its two arguments for order.  Returns a negative integer,
     * zero, or a positive integer as the first argument is less than, equal
     * to, or greater than the second.<p>
     *
     */
    public int compare(Object o1, Object o2)
    {
        Proposal p1 = (Proposal) o1;
        Proposal p2 = (Proposal) o2;
        if (p1.getProposalTime() < p2.getProposalTime() ||( p1.getProposalTime() == p2.getProposalTime() && p1.getTotalPrice() <= p2.getTotalPrice()))
        {
            return -1;
        } else
            return 1;
    }
}
