package across.agents.transporter.task;

import java.util.Collection;

import across.agents.transporter.TransporterAgent;
import across.data.Page;
import across.data.Pages;
import aglobe.container.transport.Address;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.Message;
import aglobe.ontology.MessageConstants;
import aglobex.protocol.request.RequestInitiatorTask;

/**
* This task querries the members of our aliance whether they are ready to fusion with another alliance.
  Note that the content of the iterative request is only alliance name.
 */
public class RequestMergeAllianceTask extends aglobex.protocol.request.RequestParticipantTask
{
    String otherAllianceName = null;
    TransporterAgent owner;
    long replied = 0;
    long expectedReplies = 0;
    boolean refused = false;

    public RequestMergeAllianceTask(TransporterAgent owner, Message reqMessage)
    {
        super(owner,  reqMessage, false);
        this.owner = owner;
        processRequest(reqMessage);
    }

    /**
     * Is called when requst comes. Can call agree or refuse methods to reply to
     * this message.
     *
     * @param requestMessage Message
     */
    protected void processRequest(Message requestMessage)
    {
        Pages pgs = (Pages) requestMessage.getContent();
        if (pgs.getPage().size() > 0)
        {
            String aname = TransporterAgent.getAlliance((Page)(pgs.getPage().get(0)));
            // check owner own preference...
            if (!owner.allianceAcceptable(owner.community.getAlliance(aname)))
            {
                refuse();
                cancelTask();
                return;
            }
            // ask all members simultaneously...
            Collection<Address> amis = owner.community.getOwnerAgentKnowledge().alliance.getAllAgentsAddress(owner.getAddress());
            //query all members of own allaince for their opinion
            for (Address address : amis)
            {
                RequestInitiatorTask tsk = new RequestInitiatorTask(owner, address, aname, false)
                {
                    protected void informDone()
                    {
                        replied ++;
                    }

                    protected void informResult(Object result)
                    {
                        replied++;
                        memberRefused(participant);
                    }

                    protected void requestRefused()
                    {
                        replied++;
                        memberRefused(participant);
                    }
                };
                tsk.start();
            }
        }
        else
        {
            // no pages in the set...
            Message m = requestMessage.getReply();
            m.setPerformative(MessageConstants.REFUSE);
            try
            {
                sendMessage(m);
            } catch (InvisibleContainerException e){}
        }
    }

    protected void replied()
    {
        replied++;
        if (replied == expectedReplies)
        {
            allAnswered();
        }
    }

    protected void memberRefused(Address participant)
    {
        if (!refused)
        {
            refused = true;
            refuse();
            cancelTask();
        }
    }

    /**
     * allRefused
     */
    protected void allAnswered()
    {
        if (refused) {refuse();}
        else {informDone();}
        cancelTask();
    }
}
