
package across.agents.transporter.task;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

import across.agents.transporter.TransporterAgent;
import across.agents.transporter.util.TransporterUtils;
import across.data.CoalitionDescription;
import across.data.ItemCoverage;
import across.data.Proposal;
import across.data.Resource;
import across.data.TeamProposal;
import across.data.TransportBatch;
import across.data.TransportCfp;
import across.data.TransportRequest;
import across.util.GoodsConstants;
import across.util.ListBatchTools;
import across.util.skn.AcrossCoalitionLeaderKnowledge;
import across.util.skn.AgentKnowledge;
import across.util.skn.AllianceKnowledge;
import across.util.skn.CoalitionKnowledge;
import across.util.skn.ServiceKnowledge;
import across.visio.VisualAgent;
import aglobe.container.transport.Address;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.Message;
import aglobe.ontology.MessageConstants;
import aglobe.service.gis.client.GISClientService;
import aglobex.simulation.protocol.cnp.CNPParticipantTask;



/**
* This task is inviked when the request for goods transport is requested from client location.
 * Upon the reception, the agent tries to make a coalition from alliance members and answer the cfp with proposal, using
 * the info from other coalition members.
 */
public class CNPTransportBidAnswer extends CNPParticipantTask
{
  protected TransporterAgent owner;


  //static Object lock = new Object();

  public static String coalitionPath = "logs"+File.separator;

  public static final int TIMEOUT = 50000;

  public static final int TEAM_QUERY_TIMEOUT = 6000;

  /* minimal sufficient coverage of my own alliance coalition - if coverage less, subcontract over other alliances is to be done */
  public static final double SUFFICIENT_COVERAGE = 1;//0.7;

  protected GISClientService.Shell gisShell;

  /**
   * reference to subcontract task necessary when forwarding proposalAccepted from location
   */
  protected CNPTransportSubcontractTask subcontractTask;

  /**
   * key - Address
   * value - Proposal - describes what the agent agree to participate with.
   */
  Map createdTeam;
  /**
   * key - Address
   * value - TransportCFP - describes what the agent SHOULD participate with.
   */
  Map proposedTeam;

  double coverage = 0;

    /** This field is used when the task is initiated without received message. */
    private TransportCfp transportCfpField;


    public CNPTransportBidAnswer(TransporterAgent owner, int msec, Message cfpMessage)
  {
        super(owner, msec, cfpMessage, false);
        this.owner = owner;
        this.subcontractTask = null;

        if (isCfpFromLocation()) {  //we need to check whether it is from Location

            //String logMsg = "$$--$$ "+owner.getName()+" received CFP from Location:\n";
            //logMsg = logMsg.concat("$$--$$ "+cfpMessage.toString()+"\n$$--$$ preparing proposal.\n$$--$$ .");
            //owner.getLogger().info(logMsg);

            prepareProposal();      //then process normally
        }
        else {                      //or from other TransporterAgent
            if ((owner.subcontractAllowed) && (owner.restrictionsChecker.acceptTeamLeader(cfpMessage.getSender()))) { //then is necessary to check whether subcontract allowed and the leader is acceptable
                //String logMsg = "$$--$$ received CFP from Transporter:\n";
                //logMsg = logMsg.concat("$$--$$ "+cfpMessage.toString()+"\n$$--$$ preparing subcontract proposal.\n$$--$$ .");
                //owner.getLogger().info(logMsg);

                prepareProposal();            //then prepare subcontract
            }
            else {
                ///String logMsg = "$$--$$ received CFP from Transporter:\n";
                ///logMsg = logMsg.concat("$$--$$ "+cfpMessage.toString()+"\n$$--$$ sending subcontract refuse.\n$$--$$ .");
                ///owner.getLogger().info(logMsg);

                sendRefuse();               //otherwise send refuse
            }
        }
        gisShell = owner.gisShell;
  }

  public CNPTransportBidAnswer(TransporterAgent owner, int msec, TransportCfp tcfp)
  {
      super(owner,msec);
      this.owner = owner;
      transportCfpField = tcfp;
      start();
      gisShell = owner.gisShell;
  }

    /**
     * Prepares a proposal to answer cfp from Location agent.
     */

    int totalReplies;
    int replied = 0;
    TeamProposal myTeamProposal;

    protected void prepareProposal() {
        try {
            final TransportCfp cfp;
            //owner.getLogger().severe(" *** CFProposal recieved by Transporter." + cfpMessage);
            if (null != cfpMessage)
            {
                cfp = (TransportCfp) cfpMessage.getContent();
            }
            else // this is used by humanitarian agent only
            {
                cfp = transportCfpField;
            }
            // Starting coalition formation

            proposedTeam = getPossibleTeam(cfp);
            totalReplies = proposedTeam.size();

            // check if we can satisfy the request, nonzero team...
            if (0 != totalReplies) {
                // we ask other agents whether they accept to participate in team
                // agents that accepts are added to created team
                createdTeam = new HashMap();

                /** @todo contact agents other in other alliances
                 *  which one? - QUERY-REF question can be posed to MetaAgent (he will response random agent in first stage)
                 */
                //List otherAgents = askMetaAgent();

                for (Iterator iter = proposedTeam.keySet().iterator(); iter.hasNext(); ) {
                    Address address = (Address) iter.next();

                    TeamProposal teamProposal = new TeamProposal();
                    teamProposal.setTeamLeader(owner.getAddress());
                    teamProposal.getTeamMember().addAll(proposedTeam.keySet());
                    teamProposal.setTransportCfp(cfp);
                    teamProposal.setRequestedServices((TransportCfp)proposedTeam.get(address));
                    myTeamProposal = teamProposal;

                    // owner.gisShell.submitTopic(VisualAgent.TOPIC_PROPOSAL_TO_LOCATION, teamProposal);

                    if (!address.equals(owner.getAddress())) {

                      boolean willRefuse = false;
                      
                      }
                      else {
                        // myself - answer itself immediatelly
                        Proposal p = owner.createTeamMemberProposal(teamProposal);
                        if (p != null) {
                          createdTeam.put(owner.getAddress(), p);
                        }
                        else
                        {
//                            owner.getLogger().warning( owner.getName() + ": Null coalition leader proposal. request: " + teamProposal);
                        }
                        // we do this regardless of the fact whether we accept the team or not
                        replied++;
                        if (replied == totalReplies) {
                            evaluateTeamProposal(cfp, createdTeam);
                        }
                      }
                    }
            } else {
                sendRefuse();
            }
        } catch (ClassCastException e) {
            owner.getLogger().severe( "CNPTransportBidAnswer: Unexpected cfp message content.");
            sendNotUnderstood(cfpMessage, "CNPTransportBidAnswer: Unexpected cfp message content.");
            e.printStackTrace();
        }
    }


    /**
     * Evaluates team proposal. If the team proposal is not good enough, it will try to recruit agents from other alliances.
     * @param cfp
     * @param createdTeam
     */
    protected void evaluateTeamProposal(TransportCfp cfp, Map createdTeam)
    { //System.out.println(cfp.getRequestid()+" "+createdTeam.size());  // petr
    //  System.out.println("leader: " + owner.getName() + " " + createdTeam.toString());  // petr
      Proposal myProposal = (Proposal)createdTeam.get(owner.getAddress());

      Proposal proposal = new Proposal();
      proposal.setRequestid(cfp.getRequestid());
      proposal.setProposalTime(owner.getTime());
      proposal.setTotalPrice(10);//TODO @todo
      // convert proposed team to proposal -> coverage ...
      for (Iterator iter = createdTeam.keySet().iterator(); iter.hasNext(); ) {
         Address member = (Address)iter.next();
      //   System.out.println(cfp.getRequestid()+ member.getName()); // petr
         Proposal memberProposal = (Proposal)createdTeam.get(member);

         if (memberProposal != null) { // petr
           // count proposalTime as maximum and totalPrice as a sum
           proposal.setProposalTime(Math.max(proposal.getProposalTime(),
                                             memberProposal.getProposalTime()));
           proposal.setTotalPrice(proposal.getTotalPrice() +
                                  memberProposal.getTotalPrice());
         }
      }
      // fill-in coverage for each item and determine average one...
      double sumCovered = 0;
      double sumToCover = 0;
      //double totallyCovered = 0;
      for (Iterator iter = cfp.getTransportBatch().iterator(); iter.hasNext(); ) {
          TransportBatch item = (TransportBatch)iter.next();

          ItemCoverage itemCoverage = new ItemCoverage();
          itemCoverage.setItemid(item.getBatchid());
          double covered = 0; // in fraction of batch size...

          for (Iterator iterM = createdTeam.keySet().iterator(); iterM.hasNext(); ) {
              Address member = (Address) iterM.next();
              Proposal prop = (Proposal) createdTeam.get(member);
              TransportCfp memberCfp = (TransportCfp) proposedTeam.get(member);
              if (prop != null) {
                for (Iterator it = prop.getItemCoverage().iterator(); it.hasNext(); ) {
                  ItemCoverage mic = (ItemCoverage) it.next();
                  if (mic.getItemid() == item.getBatchid()) {
                    for (Iterator iter2 = memberCfp.getTransportBatch().iterator(); iter2.hasNext(); ) {
                      TransportBatch memberBatch = (TransportBatch) iter2.next();
                      if (memberBatch.getBatchid() == item.getBatchid()) {
                        //
                        covered += mic.getCoverage()*memberBatch.getCount() / item.getCount();
                        break;
                      }
                    }
                    break;
                  }
                }
              }
          }
          covered = Math.min(covered, 1);// in theory not necesary, but may be helpfull..
          sumToCover += item.getCount();
          sumCovered += covered * item.getCount();
          if (0 != item.getCount())
          {
              itemCoverage.setCoverage(covered);
          }
          else
          {
              itemCoverage.setCoverage(1.0);
          }
          proposal.getItemCoverage().add(itemCoverage);
      }
      // check if the proposal coverage is good enough - get members outside alliance to help if necessary
      // TODO - if the coverage is too low, try to get cooperators from other alliances...


      double totalCoverage = calculateTotalCoverage(cfp, proposal);
//      owner.getLogger().info("### TOTAL COVERAGE = "+ NumberFormat.getPercentInstance().format(totalCoverage) +"###");

      // if coverage is too low try to subcontract agents from other alliances

//      owner.getLogger().info("@@@ subcontract: "+owner.subcontractAllowed+", cfpFromLocation: "+isCfpFromLocation()+", total coverage:" + totalCoverage);

      if ((owner.subcontractAllowed) && (isCfpFromLocation()) && (totalCoverage < CNPTransportBidAnswer.SUFFICIENT_COVERAGE)) {
          // choose participants according to my coalition aligability knowledge
          Collection subcontractParticipants = getPossibleOtherAlliancesParticipants();
          // take only one from each alliance
          subcontractParticipants = owner.community.removeAgentsFromSameCoalition(subcontractParticipants);

          if (!subcontractParticipants.isEmpty()) {  // although a subcontract might by meaningful, there are no transporters out of my alliance that I would be able to cooperate with
//              owner.getLogger().info("number of subcontract participants: "+subcontractParticipants.size());

            // subcontract CFP created in constructor - batches are decreased by the covered amounts within my alliance and pass the control on CNPTransportWithSubcontractTask
            //TransportCfp subcontractCfp = CNPTransportSubcontractTask.prepareSubcontractTransportCfp(cfp, proposal, owner.getName());


            this.subcontractTask = new CNPTransportSubcontractTask(owner, this, subcontractParticipants, proposal, cfp, CNPTransportSubcontractTask.TIMEOUT, myTeamProposal, myProposal);
  //          owner.getLogger().info("@@@ coverage in my alliance too low - subcontracting transporters from other alliances");
            return;   // the rest of the task as subcontracting over other alliances, sending proposal to location etc.
                      // is to be done in CNPTransportWithSubcontractTask and by calling methods from CNPTransportBidAnswer
          }
          else {
  //            owner.getLogger().info("@@@ no subcontract participants available");

          }
      }


      // check if there is at least some offer
      if (sumCovered > 0 || sumToCover == 0)
      {
        List data = new LinkedList();
                        data.add(proposal);
                        data.add(cfp);
                        data.add(this.owner.getName());
                        data.add(myProposal);
                        data.add(myTeamProposal);
                        owner.gisShell.submitTopic(VisualAgent.TOPIC_TEAM_LEADER_PROPOSAL, data);

        sendProposal(proposal);
      }
      else
      {
          sendRefuse();
      }
    }

    /**
     * Muj proposal byl prijaty - poslat svym driverum request s transport orderem a ostatnim
     * transporterum v koalici oznamit uspech proposalu - oni budou informovat sve drivery
     * @param acceptMessage Message
     */
    protected void proposalAccepted(Message acceptMessage) {

      if (owner.subcontractAllowed && (this.subcontractTask != null)) {
        this.subcontractTask.proposalAcceptedByLocation();
      }

      TransportCfp cfp;
      if (transportCfpField == null) {
        cfp = (TransportCfp) cfpMessage.getContent();
      }
      else {
        cfp = transportCfpField;
      }

      List members = new LinkedList();
      for (Iterator j = createdTeam.keySet().iterator(); j.hasNext(); ) {
        members.add( ( (Address) j.next()).getName());
      }
      CoalitionDescription cd = new CoalitionDescription();
      cd.setCoalitionLeader(owner.getName());
      cd.getCoalitionMember().addAll(members);

      cd.setTaskDegree("DEGREE ***");
      cd.setTaskDisaster("DISASTER ***");
      cd.setTaskLocation("LOCATION ***");
      cd.setTaskName(cfp.getRequestid() + "'s coalition");

      List l = new LinkedList();
      l.add(cfp.getRequestid());
      l.add(cd);

      gisShell.submitTopic(VisualAgent.TOPIC_NEW_COALITION, l);

      List data = new LinkedList();
      data.add(cfp);
      data.add(owner.getName());
      gisShell.submitTopic(VisualAgent.TOPIC_BEST_LEADER, data);
      // create the coalition knowledge...

      AcrossCoalitionLeaderKnowledge ckn = new AcrossCoalitionLeaderKnowledge(cfp,
          (Proposal) submitedProposal, CoalitionKnowledge.Strategy.FLAT,
          owner.community);
      Iterator i = createdTeam.keySet().iterator();
      // prepare the list with addresses of team members
      List teamMembers = new LinkedList();
      teamMembers.addAll(createdTeam.keySet());
      if (!teamMembers.contains(owner.getAddress())) {
        teamMembers.add(owner.getAddress());
      }
      boolean leaderExec = false; // leader not included in coalition members list
      while (i.hasNext()) {
        Address address = (Address) i.next();
        TransportRequest tr = new TransportRequest();
        tr.setProposal( (Proposal) createdTeam.get(address));
        TransportCfp transportCfp = (TransportCfp) proposedTeam.get(address);

        tr.setTransportCfp(transportCfp);
        tr.setTeamLeader(owner.getAddress());
        tr.getTeamMember().addAll(teamMembers);
        Message requestMsg = Message.newInstance(MessageConstants.REQUEST,
                                         owner.getAddress(), address);
        requestMsg.setProtocol(MessageConstants.REQUEST);
        requestMsg.setContent(tr);

        try {
          owner.sendMessage(requestMsg); // we want replies to the idle task
          // include the agent into the coalition...
          ckn.appendMember(owner.community.getAgent(address.getName()), tr);
          if (address == owner.getAddress()) {
            leaderExec = true;
          }
        }
        catch (InvisibleContainerException ex) {
          //TODO - request was lost, we will deliver less goods - repeat, re-plan or send cancel to the client
        }
      }
      if (ckn.getAllMembersCount() > 0 || leaderExec) {
        owner.community.appendCoalition(cfp.getRequestid(), ckn);
        // adding the object here is OK as long as there is only a single thread in this agent and we don't expect ANY immediate response
        try {
          FileOutputStream out = new FileOutputStream(coalitionPath +
                                                      owner.getName(), true);
          PrintStream p = new PrintStream(out);
          long allMembersCount = ckn.getAllMembersCount();
          p.println("leader of " + l.get(0) + " time: " + owner.getTime() +
                    " count: " + teamMembers.size());
          p.close();
        }
        catch (Exception e) {
          // System.err.println("Error writing to file");
        }
        // we now notify the bandit about the coalition in the case that leader is traitor and not member - leader only
        if (owner.isRenegade && !leaderExec) {
          List bdata = new LinkedList();
          bdata.add(cfp.getRequestid());
        }
      }
      try {
        sendDone(null);
      }
      catch (InvisibleContainerException ex1) {
        /**
         * @todo handle invisible
         */
      }
      cancelTask();

    }
  protected void proposalRefused(Message refuseMessage) {

        if (owner.subcontractAllowed && (this.subcontractTask != null)) {
            this.subcontractTask.proposalRefusedByLocation();
        }

    // TODO - maintain social knowledge
  }


  protected List getTeamMembersFromAlliance(AllianceKnowledge alliance) {
    List availableMembers;
    if (null != alliance)
    {
        availableMembers = new ArrayList(alliance.getAllAgentsAddress(owner.getAddress())); //TODO - accessible members only...
    }
    else
    {
        availableMembers = new LinkedList();
    }

    // add itself into the list of possible coalition partners - was not included before (excluded by getMembersAddresses)
    availableMembers.add(owner.getAddress());

    return availableMembers;
  }

    /**
     * getPossibleTeam returns one best possible team (list of agents) from current alliance
     *
     * quality is measured by coverage in this version.
     * coverage is given by semi-private knowledge - can be unprecise
     *
     * @param cfp TransportCfp
     * @return Map of agents in proposed team and requested services of every agent.
     *    key - Address
     *    value - TransportCFP - describes what the agent should participate with.
     */

    protected Map getPossibleTeam(TransportCfp cfp) {
        // determine necessary resources to judge mamber utility
        Collection requestedResources = TransporterUtils.getRequestedResources(cfp, 1);// we ask for 120 % of the original requirement, just to be sure

        // list of agents that can be used for given task - they have resources and I agree to cooperate with them
        // the list is sorted by quality of agents = coverage of all resources  -
        SortedSet usableAlliMembers = new TreeSet();
        List availableMembers;

        AllianceKnowledge alliance = owner.community.getAlliance(owner.myAlliance);


        availableMembers = getTeamMembersFromAlliance(alliance);



        // pass through the alliance and evaluate the member utility...
        for (Iterator iter = availableMembers.iterator(); iter.hasNext(); )
        {
            Address alliMember = (Address)iter.next();
            if (owner.restrictionsChecker.acceptTeamMember(alliMember))
            {
                //determine quality of this alliMember
                double alliMemberQuality = owner.getCoalitionMemberQuality(cfp, requestedResources,alliMember);
                if ( 0 < alliMemberQuality)
                {   AgentQuality aq = new AgentQuality(alliMember, alliMemberQuality);
                    usableAlliMembers.add(aq);
                }
            }
        }

        // now we select such subset from the usableAlliMembers that can cover the task
        // because subset is sorted - we are looking for such n first agents
        Map foundTeam = new HashMap();
        // this contains parts of batches that are still unsatisfied
        List unsatisfiedCfpBatches = new LinkedList();
        for (Iterator ci = cfp.getTransportBatch().iterator(); ci.hasNext();)
        {
            TransportBatch tb= (TransportBatch) ci.next();
            unsatisfiedCfpBatches.add(ListBatchTools.copyTransportBatch(tb));
        }
        // pass through the usable members and distribute batches or their parts
        for (Iterator iter = usableAlliMembers.iterator(); iter.hasNext(); ) {
            AgentQuality aQ = (AgentQuality)iter.next();
            Address agent = aQ.address;

            // list of TransportBatch - parts of batches from the original cfp, with the same id, but sometimes smaller count in case of division or partial fulfillment
            List reqBatches = decreaseRequestedResources(cfp, requestedResources, unsatisfiedCfpBatches ,agent);

            if (reqBatches.size() > 0)
            {
                TransportCfp requested = new TransportCfp();
                requested.setRequestTime(cfp.getRequestTime());
                requested.setRequestid(cfp.getRequestid());
                requested.getTransportBatch().addAll(reqBatches);
                foundTeam.put(agent, requested);
            }
            if (unsatisfiedCfpBatches.isEmpty())
            {
                break; // we do not need more agents
            }
            if (unsatisfiedCfpBatches.isEmpty()) break; // we do not need more agents
        }

        //TODO - temp debug code
//        StringBuffer alli = new StringBuffer("Alliance: ");
//        StringBuffer members = new StringBuffer("Members: ");
//        StringBuffer props = new StringBuffer("Props: ");
//        for (Iterator it = availableMembers.iterator(); it.hasNext();) {
//            Address ad = (Address) it.next();
//            alli.append(ad.getName() + " Q: ");
//            alli.append(owner.getCoalitionMemberQuality(cfp, requestedResources, ad));
//            alli.append(" Res: ");
//            alli.append(owner.community.getAgent(ad.getName()).semiPrivateParams);
//            alli.append("\n");
//        }
//
//        for (Iterator it2 = usableAlliMembers.iterator(); it2.hasNext();) {
//            AgentQuality agentQuality = (AgentQuality) it2.next();
//            members.append(agentQuality.address.getName());
//            members.append(":");
//            members.append(agentQuality.quality);
//            members.append(" ");
//            if (foundTeam.containsKey(agentQuality.address))
//            {
//                props.append(agentQuality.address.getName());
//                props.append(" ");
//                props.append(foundTeam.get(agentQuality.address).toString());
//                props.append("\n");
//            }
//        }
//        owner.getLogger().warning("### " + owner.getName() + " " + cfp + "**\n" + alli + "MyRes: " + owner.semiPrivateParams +"\n"+ members.toString() + "\n" + props.toString());

        return foundTeam;
    }

    public void log(String text) {
      if ("anttransporter".equalsIgnoreCase(owner.getName())) {
        owner.getLogger().warning(text);
      }
    }

  /**
   * getQuantity returns total quantity of resources in specified list
   *
   * @param resourceList List of Resource
   * @return long, 0 is returned also if the resource list is not initialized
   */
  private long getCapacity(Collection resourceList) {
    long capacity = 0;
      if (null != resourceList)
      {
          for (Iterator iter = resourceList.iterator(); iter.hasNext(); ) {
            Resource resource = (Resource)iter.next();
            capacity += resource.getCapacity();
          }
      }
      return capacity;
  }

    /**
     * decreaseRequestedResources
     *
     * @param requestedResources List of Resource
     * @param agent Address
     *
     * @return List of TransportBatch - contains used resources - what has been removed from <code>requestedResources</code>
     */
    protected List decreaseRequestedResources(TransportCfp cfp, Collection requestedResources, List unsatisfiedCfpBatches, Address agent)
    {
       List usedResources = new ArrayList(cfp.getTransportBatch().size());


        // determine the resources the agent has available for different types of cargo
        Map agentResources = GoodsConstants.getCargoTypesResourceMap();// contains Resource objects
        for (Iterator iter = requestedResources.iterator(); iter.hasNext(); )
        {
            Resource resource = (Resource)iter.next();
            if (0 < resource.getCapacity())
            {
                long capacity = owner.getAgentResource(agent, resource.getType());
                if (0 < capacity)
                {
                    Resource res = (Resource) agentResources.get(resource.getType());
                    res.setCapacity(capacity);
                }
            }
        }

        // pass through the cfp and try to allocate the resources for batches...
        for (Iterator it = unsatisfiedCfpBatches.iterator(); it.hasNext();)
        {
            TransportBatch tb = (TransportBatch) it.next();
            long rescapacity = ((Resource)agentResources.get(GoodsConstants.resolveType(tb.getComodityName()))).getCapacity();
            if(0 < rescapacity)
            {
                // don't use the full capacity to avoid rounding/finite size resource problems
                long usableCapacity = Math.min(rescapacity, tb.getCount());
                // check that the resource is big enough - don't split the quantities too much
                if (usableCapacity > tb.getCount()/20)
                {
                    // allocate this task for the agent
                    usedResources.add(ListBatchTools.copyTransportBatch(tb, usableCapacity));
                    // subtract the allocated part from batches to satisfy
                    tb.setCount(tb.getCount() - usableCapacity);

                    if (0 == tb.getCount())
                    {
                        it.remove();
                    }
                    // subtract it from general requested resources too
                    // TODO - just a performance optim...later
                    // subtract it from agent resources also
                    ((Resource)agentResources.get(GoodsConstants.resolveType(tb.getComodityName()))).setCapacity(rescapacity - usableCapacity);
                }
            }
        }
        return usedResources;
    }

    /**
     * calculateTotalCoverage calculates a real coverage of a coalition
     *
     * @param cfp transport CFP
     * @param proposal proposal
     *
     * @return number between 0 and 1 agreeing to the coverage (*100 agrees to percents)
     */

    private double calculateTotalCoverage(TransportCfp cfp, Proposal proposal) {
      long total = 0;
      double totalCoverage = 0;
      for (ListIterator i = cfp.getTransportBatch().listIterator(); i.hasNext(); )
      {
          TransportBatch tb = (TransportBatch) i.next();
          total += tb.getCount();
          // find corresponding coverage in proposal
          for (Iterator it = proposal.getItemCoverage().iterator(); it.hasNext();)
          {
              ItemCoverage ic = (ItemCoverage) it.next();
              if ( ic.getItemid() == tb.getBatchid())
              {
                  totalCoverage += tb.getCount() * ic.getCoverage();
                  break;
              }
          }
      }
      if (0 != total) {
        totalCoverage = totalCoverage / ((double)total);
      }
      else {
        totalCoverage = 1.0; // nothing is allways covered
      }
      return totalCoverage;
    }

    /**
     * prepares a list of agents from other alliances that I am willing to be in a coaliton with
     * and that are to be tried for subcontracting when a coverage of my alliance coalition is too low
     * @return list of possible participants from other alliances
     */

    private List getPossibleOtherAlliancesParticipants() {

        ServiceKnowledge servKnow = owner.community.getService(TransporterAgent.TYPE);
        if (null == servKnow) {
            return new LinkedList(); //returning empty list - no transporters available
        }

        List possibleParticipants = new LinkedList();

        for (Iterator i=servKnow.getAllAccessibleAgents(owner.getAddress()).iterator(); i.hasNext(); ) {

            AgentKnowledge aki = (AgentKnowledge)i.next();
            if (aki.address == null) continue;
            if (owner.restrictionsChecker.acceptTeamMember(aki.address)) {
                AllianceKnowledge alliance = owner.community.getAlliance(owner.myAlliance);
                boolean isMemberOfMyAlli = false;
                for (Iterator ii = alliance.getAllMembers().iterator(); ii.hasNext(); ) {
                    AgentKnowledge akii = (AgentKnowledge)ii.next();
                    if (akii.address.equals(aki.address)) {
                        isMemberOfMyAlli = true;
                        break;
                    }
                }
                if (!isMemberOfMyAlli) {
                  possibleParticipants.add(aki.address);
                }
            }

        }

        return possibleParticipants;
    }


    /** method called from CNPTransportSubcontractTask.evaluateReplies() to send a proposal to location that
     *  has been merged from proposal within alliance and proposal from other alliance got as a subcontract
     *  @param mergedProposal proposal covered from more alliances
     */
    void sendMergedProposal(Proposal mergedProposal) {

        //mergedProposal.getClass();

        sendProposal(mergedProposal);

        //topics to logic visio sent in CNPTransportWithSubcontractTask.handleMessages()
/*
        List data = new LinkedList();
                        data.add(proposal);
                        data.add(cfp);
                        data.add(this.owner.getName());
                        owner.gisShell.submitTopic(VisualAgent.TOPIC_TEAM_LEADER_PROPOSAL, data);

  */
    }

    /** returns true if the cfp comes from location and there are some other transporter to be subcontracted */

    /*
    private boolean isSubcontractMeaningful() {

        ServiceKnowledge servKnow = owner.community.getService(owner.TYPE);
        if (servKnow == null) {
            owner.getLogger().info("@@@ no transporter i my knowledge - getService('transporter') returns null");
            return false;   //there is no transporter in my knowledge,
        }                   //there is no one to subcontract and and no sense of subcontracting
 oby
        for (Iterator i=servKnow.serviceProviderList.iterator(); i.hasNext(); ) {
          Address transporterAgent = (Address)i.next();
          if (this.cfpMessage.getSender().equals(transporterAgent)) {
            owner.getLogger().info("@@@ sender of CFP recognized as TransporterAgent - further subcontract not meaningful");
            return false;
          }
        }
        return true;
    }

     */
    private boolean isCfpFromLocation() {

        String requestId = ((TransportCfp) cfpMessage.getContent()).getRequestid();
        if (requestId.split("-").length <= 2) {
            //owner.getLogger().info("@@@ requestId="+requestId+", subcontract IS from Location");
            return true;
        }
        //owner.getLogger().info("@@@ requestId="+requestId+", subcontract IS NOT from Location");
        return false;

     /*

        ServiceKnowledge servKnow = owner.community.getService(owner.TYPE);
        if (servKnow == null) return true;  //there is no transporter in my knowledge (no one visible),
                                            //so the contract must be from Location

        for (Iterator i=servKnow.serviceProviderList.iterator(); i.hasNext(); ) {
          Address transporterAgent = (Address)i.next();
          if (this.cfpMessage.getSender().equals(transporterAgent)) {
            return false;
          }
        }
        return true;

      */
    }



  protected class AgentQuality implements Comparable {
      Address address;
      double quality;
      public AgentQuality(Address address, double quality) {
        this.address = address;
        this.quality = quality;
      }

      public int compareTo(Object o) {
        double qDif = quality - ((AgentQuality) o).quality;
        if (qDif == 0) return address.toString().compareTo(((AgentQuality) o).address.toString());
        return (int)(qDif*10000);
      }

      public boolean equals(Object o) {
        double qDif = quality - ((AgentQuality) o).quality;
        if (qDif == 0) return address.toString().equals(((AgentQuality) o).address.toString());
        return false;
      }

      public int hashCode() {
        return (int)(quality*10000) + address.hashCode();
      }
    }


}
