package across.agents.terrorists.driver.util;

import java.util.Random;

/**
 * This class controls the time when the obstacles are added - on asking it
 * returns whether or not to add an obstacle.
 * @author Eduard Semsch
 *
 */
public class ObstacleAdder {

	private long simulationCycle;
	
	private long obstacleFrequency;
	
	private long simTime;
	
	private long timeCounter = 0;
	
	private Random rand = new Random(System.currentTimeMillis());
	
	private int probability;

	/**
	 * Constructs the object
	 * @param simulationCycle
	 * @param obstacleFrequency
	 * @param probability - 0-100 the random factor 
	 */
	public ObstacleAdder(long simulationCycle, long obstacleFrequency, int probability) {
		super();
		this.simulationCycle = simulationCycle;
		this.obstacleFrequency = obstacleFrequency;
		this.probability = probability;
	}

	public void simulationTick() {
		simTime+=simulationCycle;
	}
	
	public boolean isReadyToAddObstacle() {
		if(simTime-timeCounter>obstacleFrequency) {
			timeCounter = simTime;
			if(rand.nextInt(100)<probability) {
				return true;
			}
		}
		return false;
	}
	
	public void obstacleAdded() {

		
	}
	
}
