package across.agents.pathfinding.tester;

import java.util.LinkedList;
import java.util.List;

import across.agents.driver.data.RoadInfo;
import across.agents.driver.data.Route;
import across.agents.driver.data.RouteInfo;
import across.data.AcrossMapArcs;
import across.data.AcrossMapDistances;
import across.data.AcrossMapNodes;
import across.data.Arc;
import across.data.Node;
import across.data.Waypoint;
import across.simulation.constants.AcrossDataConstants;
import across.util.pathfinding.AStarModPathfinding;
import across.util.pathfinding.DijkstraPathfinding;
import across.util.pathfinding.Pathfinding;
import across.util.pathfinding.RoadEvaluator;
import aglobex.simulation.ontology.entity.EntityDescriptor;

public class PathfindingTesterMovement {
	/** Owner of this class - the agent. */
	protected PathfindingTesterAgent owner;
	
	/** Algorithm for pathfinding */
	protected Pathfinding pathfinding;
	
	/** Arcs of the map */
	protected AcrossMapArcs arcsOfMap;
	
	/** Nodes of the map (map). */
	protected LinkedList<String> locNames = new LinkedList<String>(); 
	  
	/** The distances between the nodes. */
	protected RoadInfo roads[][];
	
	/** Location where the driver currently is. */
	protected String actualLoc;
	
	/** The set of waypoints this agent is going to go through. */
	protected LinkedList<Waypoint> waypoints = new LinkedList<Waypoint>(); 
	
	/** Current position on the map */
	protected double[] position;
	
	/** Arc thourgh which the vehicle is going now */
	protected Arc currentArc;
	
	public PathfindingTesterMovement(PathfindingTesterAgent owner) {
		this.owner = owner;
	}
	
		
		
	public void handleConfiguration(EntityDescriptor ed, final double velocity, final double consumption) {
		  this.actualLoc = ed.confParamsString.get(AcrossDataConstants.ENTITY_START_NODE);
		  
		  AcrossMapNodes amn = (AcrossMapNodes) ed.typeDescriptor.userObjects.get(AcrossDataConstants.MAP_NODES);
		  arcsOfMap = (AcrossMapArcs) ed.typeDescriptor.userObjects.get(AcrossDataConstants.MAP_ARCS);
		  AcrossMapDistances amd = (AcrossMapDistances) ed.typeDescriptor.userObjects.get(AcrossDataConstants.MAP_DISTANCES);
		  
		  
	  	  // Get list of node names
	      locNames.clear();
	      for (Node node : (List<Node>) amn.getNode()) {
	    	  locNames.add(node.getName());
	      }
	   	  
	     //making universal matrix of distances to xml
	      
	     /* 
	      try{
	    	List<Node> nodList = null;
	    	nodList = amn.getNode();
	      AcrossMapDistances n = new AcrossMapDistances();
	   	  double[][] g = new double[nodList.size()][nodList.size()];
	      for (Node nod : nodList) {
	      for (Node nodik : nodList) {
				double dist = Point3d.distance(nod.getX(), nod.getY(), 0, nodik.getX(), nodik.getY(), 0);
				g[nodList.indexOf(nod)][nodList.indexOf(nodik)] = dist;
				g[nodList.indexOf(nod)][nodList.indexOf(nodik)] = dist;
			}
	      }
	   	  n.setDistance(g);
    	  JAXBContext c = JAXBContext.newInstance("across.data");
    	  Marshaller m = c.createMarshaller();
	      m.marshal(n, new FileOutputStream(new File("xml/distances.xml")));
	      
	      }catch (Exception e) {
			e.printStackTrace();
		}
	      //end of making xml
	      */
	      
	      // time measure
	      long tick = System.nanoTime();
	      long militick = System.currentTimeMillis();
	      
	      // Get list of all arcs, construct the graph
		  roads = new RoadInfo[locNames.size()][locNames.size()];
		  for (Arc arc : (List<Arc>) arcsOfMap.getArc()) {
	        int fromIndex = locNames.indexOf(arc.getFrom());
	        int toIndex = locNames.indexOf(arc.getTo());
	        double time = 10*arc.getLength()/velocity;
	        double price = (1/arc.getQuality()) * arc.getLength() * consumption/100;
	        RoadInfo roadInfo = new RoadInfo(time, price);
	        roads[fromIndex][toIndex] = roadInfo;
	        roads[toIndex][fromIndex] = roadInfo;
	      }
		  
		  pathfinding = new DijkstraPathfinding(locNames, roads);
		  
		  System.out.print("InitTime = " + (System.currentTimeMillis()-militick) + " milis " + (System.nanoTime()-tick) + "nanos \n");
		  tick = System.nanoTime();
		  militick = System.currentTimeMillis();
		  
		  long[][] averageTime = new long[locNames.size()][2];
		  //loopnumber
		  int rep = 5;
		  //repeated loop for averages
		  for (int i = 1; i <= rep; i++) {
			
		
		  int j = 0;
		  for (String locName : locNames) {
			  Route route = pathfinding.planRoute("Jakarta", locName, 1, 0);
			  //System.out.print("Timecount " + actualLoc + " to " + locName + " -> " +(System.nanoTime()-tick) + " milis " + (System.currentTimeMillis()-militick) + "\n" + tick + "\n");
			  averageTime[j][0] += (System.nanoTime()-tick);
			  j++;
			  try{
			  //System.out.print(route.toString() + "\n");
			  }catch (NullPointerException e) {
				// TODO: handle exception
			}
			  
			  tick = System.nanoTime();
			  militick = System.currentTimeMillis();
		  }
		  }//end of averages loop
		  
		  RoadEvaluator re = new RoadEvaluator() {

			public double getPrice(Arc arc) {
				return (1/arc.getQuality()) * arc.getLength() * consumption/100;
			}

			public double getTime(Arc arc) {
				return 10*arc.getLength()/velocity;
			}
			  
		  };
		  
		  tick = System.nanoTime();
		  militick = System.currentTimeMillis();
		  pathfinding = new AStarModPathfinding(amn.getNode(),arcsOfMap.getArc(),amd.getDistance(),re, new LinkedList<Arc>());
		  
		  System.out.print("InitTime = " + (System.currentTimeMillis()-militick) + " milis " + (System.nanoTime()-tick) + "nanos \n");
		  tick = System.nanoTime();
		  militick = System.currentTimeMillis();
		  
//		repeated loop for averages
		  for (int i = 1; i <= rep; i++) {
		  
		  int j = 0;
		  for (String locName : locNames) {
			  Route route = pathfinding.planRoute("Jakarta", locName, 1, 0);
			  //System.out.print("Timecount " + actualLoc + " to " + locName + " -> " +(System.nanoTime()-tick) + " milis " + (System.currentTimeMillis()-militick) + "\n" + tick + "\n");
			  averageTime[j][1] += (System.nanoTime()-tick);
			  j++;
			  try{
				 // System.out.print(route.toString() + "\n");
				  }catch (NullPointerException e) {
					// TODO: handle exception
				}
			  tick = System.nanoTime();
			  militick = System.currentTimeMillis();
		  }
		  }//end for averages
		  long profitPerNode = 0;
		  long diff = 0;
		  for (int i = 0; i < locNames.size(); i++) {
			diff = ((averageTime[i][0])/rep - (averageTime[i][1])/rep); 
			System.out.print(locNames.get(i) + " Dijkstra: " + (averageTime[i][0])/rep + " AStar: " + (averageTime[i][1])/rep + " difference: "+ diff +"\n");
			profitPerNode += diff;
		}
		  System.out.print(profitPerNode/locNames.size());
	}
	
	protected Route planRoute(List<Waypoint> wpList, boolean byPrice){
	      String startPoint;
	      Route route = new Route();
	      
	      if (waypoints.size() == 0) {
	      	startPoint = new String(actualLoc);
	      } else {
	      	startPoint = new String(((Waypoint)waypoints.getLast()).getLocationName());
	      }

	      double taskTime = 0;
	      double taskPrice = 0;

	      for (Waypoint wp : wpList) {
	        Route oneRoute;
	        if (byPrice) {
	      	  oneRoute = pathfinding.planRoute(startPoint, wp.getLocationName(), 0, 1);
	        } else {
	      	  oneRoute = pathfinding.planRoute(startPoint, wp.getLocationName(), 1, 0);
	        }
	        if (oneRoute == null) {
	        	continue;
	        }
	        taskTime += oneRoute.getRouteInfo().routeTime;
	        taskPrice += oneRoute.getRouteInfo().routePrice;
	        startPoint = wp.getLocationName();
	        // add all intermediate waypoints (with empty request lists)
	        route.addWaypoints(oneRoute.getWaypoints());
	        route.addWaypoint(wp);  // add the actual waypoint
	      }
	      route.setRouteInfo(new RouteInfo(taskTime, taskPrice));
	      return route;
	    }
}
