package across.agents.location.task;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ListIterator;

import across.agents.location.LocationAgent;
import across.agents.location.accounts.NegativeStockException;
import across.agents.location.accounts.StockOfferDemand;
import across.agents.transporter.TransporterAgent;
import across.data.Batch;
import across.data.ItemCoverage;
import across.data.Proposal;
import across.data.RequestList;
import across.data.TransportCfp;
import across.util.skn.ServiceKnowledge;
import across.visio.VisualAgent;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.Message;
import aglobe.ontology.MessageConstants;
import aglobe.util.Logger;
import aglobex.simulation.protocol.cnp.CNPParticipantTask;
import aglobex.simulation.protocol.cnp.CNPTaskOwner;

/**
 * Created by IntelliJ IDEA.
 * User: agent
 * Date: May 16, 2004
 * Time: 10:13:01 PM
 * To change this template use Options | File Templates.
 */
public class LocProposeGoodsTask extends CNPParticipantTask {
    /** Request list of this task */
    protected RequestList rl = null;

    // TODO - conf
    public static final int TIMEOUT = 25000;
    
    /** Minimal size of lot to aquire */
    private int minLotSize;

    public LocProposeGoodsTask(CNPTaskOwner owner, int msec, Message cfpMessage) {
        super(owner, msec, cfpMessage);
    }
    
    /**
     * Sets the minLotSize parameter
     * @param minLotSize
     */
    public void setMinLotSize(int minLotSize) {
    	this.minLotSize = minLotSize;
    }

    /**
     * Implement this method to answer the call for proposals received in message cfpMessage.
     * Use sendProposal or sendRefuse methods to send your proposal so that the Task is in a consistent state.
     */
    protected void prepareProposal() {
        // get the message content
        try {
            long proposalprice = 100; // 100 represents minimum transaction cost - it diminishes the value of split proposals
            // check if it is the first demand for this task
            if (null == rl) {
                // extract the content
                rl = (RequestList)cfpMessage.getContent();
                // prepare the proposal structure
                if (owner instanceof LocationAgent) {
                  long time = ( ( (LocationAgent) owner).getCurrentTime());
                  Proposal prop = prepareProposalFromRequestListAndStock(rl, time, proposalprice, ((LocationAgent)owner).books, getAddress().getContainerName(),minLotSize);
                  proposalprice = prop.getTotalPrice();
                  if (proposalprice > 0) {
                      try {
                          ((LocationAgent)owner).books.registerProposedGoods(rl, prop);
                      } catch (NegativeStockException e) {
                          Logger.logSevere(getAddress().getName() + "Goods are not available for proposal" );
                          e.printStackTrace();
                      }
                  	prop.setTotalPrice(proposalprice);
                    sendProposal(prop);
                    return;
                  }
                }
                // we have failed to find enough stock to satisfy the demand - cancels the task also
                sendRefuse();
                //send a copy of refuse to topic
               ((LocationAgent)owner).gisShell.submitTopic(VisualAgent.TOPIC_LOCATION_REFUSED, cfpMessage);
            } else {
                // second demand in the same task
                sendNotUnderstood(cfpMessage, "Second request as a reply in existing conversation.");
            }
        } catch (ClassCastException e) {
            Logger.logSevere("Bad CFP format;content type.: " + cfpMessage);
            e.printStackTrace();
        }
    }
    
    public static Proposal prepareProposalFromRequestListAndStock(RequestList rl, long time, long startPrice, StockOfferDemand books, String containerName, int minLotSize)    {
        Proposal prop = new Proposal();
        prop.setRequestid(rl.getRequestid());
        prop.setProposalTime(time);
        ListIterator batchit = rl.getBatch().listIterator();
        long propPrice = 0;
        while (batchit.hasNext()) {
        	Batch batch = (Batch) batchit.next();
        	long sr = books.getAvailableStock(batch.getComodityName());
        	if (sr > minLotSize) {
        		long requestcount = batch.getCount();
        		// do we have enough to give an acceptable ammount ?
        		// determine the quantity to provide
        		long avcount = Math.min(requestcount, sr);
        		// we may satisfy the demand - determine the price
        		propPrice = avcount * across.util.GoodsConstants.getCommodityPrice(batch.getComodityName());
        		ItemCoverage ic = new ItemCoverage();
        		ic.setItemid(batch.getBatchid());
        		ic.setLocation(containerName);
        		ic.setCoverage( (double)avcount / requestcount);
        		prop.getItemCoverage().add(ic);
        	}
        }
        if (propPrice > 0) {
        	prop.setTotalPrice(startPrice + propPrice);
        } else {
        	prop.setTotalPrice(0);
        }
        return prop;
    }

    /**
     * In the body of this method, start the action to fulfill the proposal.
     * @param acceptMessage message with accept - DONE or FAILURE must be reply to this message
     */
    protected void proposalAccepted(Message acceptMessage) {
            if (null != cfpMessage && null != submitedProposal) {
                RequestList req = (RequestList) cfpMessage.getContent();
                LocationAgent lowner = (LocationAgent) owner;

                // prepare the message for reply
                Message m = acceptMessage.getReply();
                m.setPerformative(MessageConstants.INFORM_DONE);
                try {
                    sendMessage(m);
                } catch (InvisibleContainerException e){}
                
                if (req.getDeliveryLocation().equalsIgnoreCase((lowner).getContainer().getContainerName())) {
                    //local handling only...
                    CNPTransportManagerTask.requestLocalBatchLoading(lowner, req, (Proposal)submitedProposal, cfpMessage.getSender());
                    // null content of done means no transport
                } else {
                    prepareTransport(req, lowner);
                }
            } else {
                Logger.logSevere(" *** "+getAddress().getName() + " Acceptance occured in the task before the list was initialized ?." + rl +" \n " + acceptMessage + "\n" + cfpMessage + "\nProposal: " + submitedProposal);
            }
            cancelTask();
    }

    /**
     * This method spawns a task to ensure transportation of goods.
     * @param req
     * @param lowner
     */
    protected void prepareTransport(RequestList req, LocationAgent lowner) {
        // we keep the goods only reserved and schedule them for transport only after transport was arranged
        // transport is necessary, organize it
        //send a copy of proposal to topic - acceptation received
        ((LocationAgent)owner).gisShell.submitTopicToServer(VisualAgent.TOPIC_ACCEPTATION_RECEIVED, this.cfpMessage);
        TransportCfp tcfp = CNPTransportManagerTask.prepareOutboundTransportCfp( this.cfpMessage,  (Proposal)submitedProposal, ((LocationAgent)owner).getCurrentTime(), req.getDeliveryLocation(), lowner);
        // check if we have to transport
        if ( null!= tcfp) {  
            // DONE or FAILURE will be sent by the transport task...
            ServiceKnowledge providers = (ServiceKnowledge)lowner.community.getServices().get(TransporterAgent.TYPE);
            Collection accessibleProviders;
            if (null != providers) {
                accessibleProviders = providers.getAccessibleProviders(null);
            } else {
                accessibleProviders = new ArrayList(0);
            }

            new CNPTransportManagerTask(lowner, accessibleProviders, tcfp, req, (Proposal)submitedProposal, CNPTransportManagerTask.TIMEOUT, this);
            if (0 < accessibleProviders.size()) {
                ((LocationAgent)owner).gisShell.submitTopicToServer(across.visio.oldvisio.VisioConnectionAgent.TOPIC_VISIO_ACTION, Byte.toString(across.visio.oldvisio.VisioConnectionAgent.ACTION_CFP_TRANSPORT) ,getAddress().toString());
            }
        }
    }


    /**
     * This method is called when the propopsal is refused by the proposing party.
     * It is also called, with null param, when timeout or communication problem occurs.
     * In the body, owner shall free the resources allocated for proposal.
     * @param refuseMessage message with refusal
     */
    protected void proposalRefused(Message refuseMessage) {
        try {
            if (null != cfpMessage && null != submitedProposal) {
                ((LocationAgent)owner).books.reservedGoodsRefused((RequestList)cfpMessage.getContent(), (Proposal)submitedProposal);
            } else {
                Logger.logSevere(" *** "+getAddress().getName() + " Refusal occured in the task before the list was initialized ?." + rl + " \n " + refuseMessage + "\nProposal: " + submitedProposal);
            }
        } catch (NegativeStockException e) {
            Logger.logSevere("Reserved goods not available for cancel when proposal was refused." + rl + " \n " +refuseMessage);
        }
    }

  /**
   *
   * @param content Object
   * @throws InvisibleContainerException
   * @todo Implement this aglobex.simulation.protocol.cnp.CNPParticipantTask method
   */
  void taskDone(Object content) throws InvisibleContainerException {
	  if(!isCancelled()) {
		  sendDone(content);
	  }
  }

  /**
   *
   * @param content Object
   * @throws InvisibleContainerException
   * @todo Implement this aglobex.simulation.protocol.cnp.CNPParticipantTask method
   */
  void taskFailure(Object content) throws InvisibleContainerException {
	  if(!isCancelled()) {
		  sendFailure(content);
	  }
  }
}
