package across.agents.location.gui;


import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.table.DefaultTableModel;

import across.agents.location.LocationAgent;
import across.agents.location.accounts.StockOfferDemand;
import across.agents.location.accounts.StoreRec;
import across.util.GoodsConstants;
import aglobe.container.Store;

/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: </p>
 * @author not attributable
 * @version 1.0
 */

public class LocationAgentGUI extends JFrame {

  private final Store store;
  private static final String STORE_WINDOW_X = "gui/win_x";
  private static final String STORE_WINDOW_Y = "gui/win_y";
  private static final String STORE_WINDOW_WIDTH = "gui/win_width";
  private static final String STORE_WINDOW_HEIGHT = "gui/win_height";

  private LocationAgent owner = null;

  GoodsTableModel goodsTableModel = new GoodsTableModel();
  StatsTableModel statsTableModel = new StatsTableModel();
  DefaultTableModel locationsTableModel = new DefaultTableModel();
  DefaultTableModel transportersTableModel = new DefaultTableModel();

  private HashMap map = new HashMap();
  
  // TODO - conf
  String[] goods = {GoodsConstants.BREAD, GoodsConstants.FISH,
	      GoodsConstants.FLOUR, GoodsConstants.GRAIN, GoodsConstants.SHEEP,
	      GoodsConstants.WATER};

  JTabbedPane jTabbedPane1 = new JTabbedPane();
  JScrollPane jScrollPane1 = new JScrollPane();
  JScrollPane jScrollPane2 = new JScrollPane();

  JTable goodsTable = new JTable();
  JTree knownServiceProviders = new JTree();
  JScrollPane jScrollPane3 = new JScrollPane();
  JTable statsTable = new JTable();
  JTextField jTextField1 = new JTextField();
  GridBagLayout gridBagLayout1 = new GridBagLayout();
  JButton newRequestButton = new JButton();

  public LocationAgentGUI(LocationAgent _owner) throws HeadlessException {
    owner = _owner;
    store = owner.getContainer().getAgentStore(owner.getName());
    try {
      jbInit();
      for (int i = 0; i<goods.length;i++){
             map.put(goods[i], new Integer(i));
           }
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    jTextField1.setEditable(false);
    jTextField1.setSelectionStart(11);
    jTextField1.setText("mood:");
    this.getContentPane().setLayout(gridBagLayout1);
    newRequestButton.setText("New Request ...");
    newRequestButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        newRequestButton_actionPerformed(e);
      }
    });
    jTabbedPane1.add(jScrollPane1,  "Goods");
    jScrollPane1.getViewport().add(goodsTable, null);
    jTabbedPane1.add(jScrollPane2,  "Known service providers");
    jTabbedPane1.add(jScrollPane3,  "stats");
    jScrollPane3.getViewport().add(statsTable, null);
    jScrollPane2.getViewport().add(knownServiceProviders, null);
    this.getContentPane().add(jTextField1,
                              new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0
        , GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL,
        new Insets(0, 0, 0, 0), 0, 0));
    this.getContentPane().add(newRequestButton,
                              new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
        , GridBagConstraints.CENTER, GridBagConstraints.NONE,
        new Insets(0, 0, 0, 0), 0, 0));
    this.getContentPane().add(jTabbedPane1,
                              new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0
        , GridBagConstraints.CENTER, GridBagConstraints.BOTH,
        new Insets(0, 0, 0, 0), 0, 0));

    knownServiceProviders.setModel(owner.community.getServiceProvidersTreeModel());
    knownServiceProviders.expandRow(0);

    goodsTable.setModel(goodsTableModel);
    statsTable.setModel(statsTableModel);
  }

   public void setAll(final StockOfferDemand books) {

     synchronized (books) {
       goodsTableModel.putColumn(0, goods);
       goodsTableModel.putColumn(1, createColumn(books.getGoodsAvailable()));
       goodsTableModel.putColumn(2, createColumn(books.getGoodsPrivate()));
       goodsTableModel.putColumn(3, createColumn(books.getGoodsDemand()));
       goodsTableModel.putColumn(4, createColumn(books.getGoodsReserved()));
       goodsTableModel.putColumn(5, createColumn(books.getGoodsWaitingForPickUp()));
       goodsTableModel.putColumn(6, createColumn(books.getGoodsExpected()));

       statsTableModel.putColumn(0, goods);
       statsTableModel.putColumn(1, createColumn(books.getAgregateDemand()));
       statsTableModel.putColumn(2, createColumn(books.getAgregateReceived()));
       statsTableModel.putColumn(3, createColumn(books.getAgregateProduced()));
       statsTableModel.putColumn(4, createColumn(books.getAgregateSold()));

     }
   goodsTableModel.fireTableDataChanged();
   statsTableModel.fireTableDataChanged();
   }

  private String[] createColumn(Collection goodsColl) {
      String[] comodities = new String[goods.length];
      for (Iterator i = goodsColl.iterator(); i.hasNext(); ) {
        StoreRec sr = (StoreRec) i.next();
        int index = ( (Integer) map.get(sr.getCommodity())).intValue();
        comodities[index] = Long.toString(sr.getCount());
    }
   return comodities;
  }
  
  public void setMood(double happy) {
    jTextField1.setText("happy: "+happy);
  }

  public void setVisible(boolean parm1) {
    if (!parm1) {
      Point p = getLocation();
      store.putInt(STORE_WINDOW_X, p.x);
      store.putInt(STORE_WINDOW_Y, p.y);

      Dimension d = getSize();
      store.putInt(STORE_WINDOW_WIDTH, d.width);
      store.putInt(STORE_WINDOW_HEIGHT, d.height);
    }
    else {
      if (store.exist(STORE_WINDOW_X)) {
        java.awt.Point loc = getLocation();
        int x = store.getInt(STORE_WINDOW_X, loc.x);
        int y = store.getInt(STORE_WINDOW_Y, loc.y);
        setLocation(x, y);

        Dimension d = getPreferredSize();
        int w = store.getInt(STORE_WINDOW_WIDTH, d.width);
        int h = store.getInt(STORE_WINDOW_HEIGHT, d.height);
        setSize(w, h);
      }
    }

    super.setVisible(parm1);
  }

  public void newRequestButton_actionPerformed(ActionEvent e) {
      /**
       * Create your GUI, modal !!!
       */

      String requestId = Long.toString(System.currentTimeMillis()%(owner.getAddress().hashCode())+owner.hashCode());

      new NewTransportRequestGUI(this, true, requestId, owner).setVisible(true);

      }



}
