package across.agents.location.generator;

import across.agents.location.SimulationObjectsEffects;
import across.agents.location.accounts.StockOfferDemand;
import across.data.Param;
import across.data.Weather;

/**
 * Created by IntelliJ IDEA.
 * User: rehakm1
 * Date: 27.5.2004
 * Time: 17:36:45
 * To change this template use Options | File Templates.
 */
/**
 * Implements pure resources source. This entity has no consumption, only produces some commodity.
 */
public class MineGenerator extends Generator
{
    public static final String NAME = "mine";

    /** Commodity to produce in the mine */
    String commodity;
    /** Basic quantity to produce per step. Actual producation may vary because of weather. */
    long perStepQuantity = 1000;

    /**
     * Creates the mine. Specify the commodity and nominal production.
     * @param commodity Commodity to produce.
     * @param perStepQuantity nominal resource capacity per one step (weather received)
     */
    public MineGenerator(String commodity, long perStepQuantity)
    {
        this.commodity = commodity;
        this.perStepQuantity = perStepQuantity;
    }

    /**
     * This method is called by location to demand resource generation or consumption.
     * Current stock/offer/demand/... available on the location is passes in the books variable.
     * Current weather is passed in as weather parameter.
     * @param weather Current weather
     * @param books Object with current goods/requests/supply/demand status
     */
    public long generationStep(Object weather, StockOfferDemand books, SimulationObjectsEffects effects)
    {
    	long realQuant = perStepQuantity;
    	if (null != weather && weather instanceof Weather) {
			Weather wea = (Weather) weather;
			//TODO get the commodity name from the w
			for (Object wob : wea.getParam()) {
				Param wp = (Param) wob;
				if (commodity.equalsIgnoreCase(wp.getName())) {
					double coeff = Double.parseDouble(wp.getValue());
					realQuant *= coeff;
				}
			}
		}
		books.goodsCreated(commodity, realQuant);
        return realQuant;
    }
}
