package across.agents.location.generator;

import across.agents.location.SimulationObjectsEffects;
import across.agents.location.accounts.StockOfferDemand;
import across.util.GoodsConstants;

/**
 * Created by IntelliJ IDEA.
 * User: rehakm1
 * Date: 27.5.2004
 * Time: 17:40:38
 * To change this template use Options | File Templates.
 */

/**
 * Transformer generator, transforming corn and water into bread.
 * Example of factory generator. In the future, it shall be derived from generic factory class.
 */
public class BakeryGenerator extends Generator
{
    public static final String NAME = "bakery";

    /* How many units do we typically produce per turn.*/
    long nominalProductionCapacity = 1000;
    /** How many units do we produce now */
    long currentCapacity = nominalProductionCapacity;

    /** is False if the generator must make a new command to receive goods - first time or after capacity change*/
    private boolean goodsCommandMade = false;

    /** Creates a new Bakery with given nominal capacity.*/
    public BakeryGenerator(long nominalProductionCapacity) {
        this.nominalProductionCapacity = nominalProductionCapacity;
        currentCapacity = nominalProductionCapacity;
    }

    /**
     * This method is called by location to demand resource generation or consumption.
     * Current stock/offer/demand/... available on the location is passes in the books variable.
     * Current weather is passed in as weather parameter.
     * @param weather Current weather
     * @param books Object with current goods/requests/supply/demand status
     */
    public long generationStep(Object weather, StockOfferDemand books, SimulationObjectsEffects effects) {
        //TODO - addapt the capacity and commands using the current need...
        if (!goodsCommandMade) {
             books.command(GoodsConstants.WATER, currentCapacity);
             books.command(GoodsConstants.GRAIN, currentCapacity);
             goodsCommandMade = true;
        }
        // check if we must produce
        if (books.getPrivateAndAvailableStock(GoodsConstants.BREAD) < currentCapacity*10) {
            // check the available stock and producable quantity
            long water = books.getPrivateAndAvailableStock(GoodsConstants.WATER);
            long grain = books.getPrivateAndAvailableStock(GoodsConstants.GRAIN);
            // determine how much do we produce
            long quantity = Math.min(Math.min(water, grain), currentCapacity);

            // obtain the quantities and store the finished bread
            if (0 < quantity) {
                books.goodsConsumed(GoodsConstants.WATER, quantity);
                books.goodsConsumed(GoodsConstants.GRAIN, quantity);
                // create the bread - approx 70% of water evaporates... estimated...
                books.goodsCreated(GoodsConstants.BREAD, (long)(quantity*1.3));
            }
        }
        return currentCapacity;
    }
}
