package across.agents.location.accounts;

import across.data.Batch;

/**
 * Created by IntelliJ IDEA.
 * User: agent
 * Date: May 17, 2004
 * Time: 10:20:35 PM
 * To change this template use Options | File Templates.
 */
public class StoreRec {
    /** Name of the commodity*/
    private String commodity;
    /** Number of pieces */
    private long count;

    /** Used only by extending classes */
    protected StoreRec() {}

    public StoreRec(String commodity, long count)  {
        this.commodity = commodity;
        this.count = count;
    }

    /** Returns number of pieces */
    public long getCount() {
        return count;
    }
    /** Returns the standard name of the commodity */
    public String getCommodity() {
        return commodity;
    }

    /** Receives the new stock. */
    public void increase(long bcount) {
        count += bcount;
    }

    /** Receives the new batch into the stock */
    public void increase(Batch b) {
        count += b.getCount();
    }

    /** Removes the batch from the stored commodity. If the negative value would be reached, zero is used. */
    public boolean decrease(Batch b) {
        count -= Math.min(Math.max(0,b.getCount()),count);
        return true;
    }
    
    /**
     * Overriden by DetailedStoreRec
     * @param b
     * @param requestedFill
     * @param reallyUnload
     * @return
     */
    public double decrease(Batch b, double requestedFill, boolean reallyUnload) {
      return 0;
    }

    /** Removes the given quantity from the store. Store may become negative. */
    public void decrease(long decr) {
        count -= decr;
    }

    /** Removes the batch from the stored commodity. Refuses negative stock.  */
    public void decreaseNonNegative(Batch b) throws NegativeStockException {
        if (this.count >= b.getCount()) {
            this.count -= b.getCount();
        } else {
            throw new NegativeStockException("Received more goods than ordered.");
        }
    }

    /** Removes the batch from the stored commodity. Refuses negative stock.  */
    public void decreaseNonNegative(Batch b, String error) throws NegativeStockException {
        if (this.count >= b.getCount()) {
            this.count -= b.getCount();
        } else {
            throw new NegativeStockException(error);
        }
    }

    /** Removes the batch from the stored commodity. Refuses negative stock.  */
    public void decreaseNonNegative(long count) throws NegativeStockException {
        if (this.count >= count) {
            this.count -= count;
        } else {
            throw new NegativeStockException("Received more goods than ordered.");
        }
    }

    /**
     * Returns a readable string representation of the object.
     * @return  a string representation of the object.
     */
    public String toString() {
        StringBuffer sb = new StringBuffer(commodity);
        sb.append("\t");
        sb.append(count);
        return sb.toString();
    }
}
