package across.agents.location.accounts;

import java.util.HashMap;

import across.data.Batch;

/**
 * Created by IntelliJ IDEA.
 * User: rehakm1
 * Date: 21.5.2004
 * Time: 11:00:19
 * To change this template use Options | File Templates.
 */
/**
 * Extension of StoreRec class, allowing to store not only the total value but all batches with details.
 * Used for stores where it has some meaning...
 */
public class DetailedStoreRec extends StoreRec {
    /** Stores the batches, uses batchid as a key */
    HashMap<Long,Batch> batches = new HashMap<Long,Batch>();

    /** Creates the store and includes the first batch */
    public DetailedStoreRec(Batch b) {
        super(b.getComodityName(),0);
        increase(b);
    }

    /** Receives the new stock. */
    public void increase(long bcount) {
        throw new UnsupportedOperationException("Use batch operation only");
    }

    /** Receives the new batch into the stock - if the same batchid exists, it is incremented... */
    public void increase(Batch b)  {
        Batch inserted = batches.get(new Long(b.getBatchid()));
        if (null == inserted) {
            batches.put(new Long(b.getBatchid()), b);
        } else {
            inserted.setCount(inserted.getCount() + b.getCount());
        }
        // increase the total ammount...
        super.increase(b);
    }

    /** Removes the batch from the stored commodity. If the batch is not present, sotck is not modified. 
     *  @return true if decreased, false if the batch was not found
     * */
    public boolean decrease(Batch b) {
        // get the batch
        Batch victim = (Batch)batches.get(new Long(b.getBatchid()));
        // decrease the total ammount...
        if (null != victim) {
        	if (victim.getCount()<b.getCount()) {
        		super.decrease(victim);        		
        	} else {
                super.decrease(b);
        	}
            victim.setCount(Math.max(victim.getCount() - b.getCount(),0));
            // remove the batch if nothing is left
            if (victim.getCount() == 0) {
                batches.remove(new Long(b.getBatchid()));
            }
            return true;
        }
        return false;
    }

    public double decrease(Batch b, double requestedFill, boolean reallyUnload) {

      if (b.getCount() == 0) {
       // empty batch is 100% filled
        return 1;
      }

      // get the batch
      Batch victim = (Batch) batches.get(new Long(b.getBatchid()));

      double successRatio;

      if (null != victim) {
        successRatio = ( (double) victim.getCount()) / ( (double) b.getCount());
        if (successRatio >= requestedFill) {
          // there is enaugh goods is in the location

          if (reallyUnload) {
            // decrease amount in the store now
            decrease(b);
          }
        }
      } else {
        // there is no such goods
        successRatio = 0;
      }

      return successRatio;
    }

    /** Removes the batch from the stored commodity. Refuses negative stock.  */
    public void decreaseNonNegative(Batch b) throws NegativeStockException {
         decrease(b);
    }

    /** Removes the batch from the stored commodity. Refuses negative stock.  */
    public void decreaseNonNegative(long count) throws NegativeStockException {
        throw new UnsupportedOperationException("Use batch operation only");
    }

    /** Removes the given quantity from the store. Store may become negative. */
    public void decrease(long decr)  {
    	super.decrease(decr);
    }
    
    /**
     * Gets a batch by its ID.
     * @param batchid
     * @return
     */
    public Batch get(Long batchid) {
    	return batches.get(batchid);
    }
}
