package across.agents.location;

import java.util.List;

import across.data.AcrossMapNodes;
import across.data.Node;
import across.simulation.constants.AcrossDataConstants;
import aglobe.visio3D.PlanUpdate;
import aglobex.simulation.entitysimulator.ControlLink;
import aglobex.simulation.entitysimulator.EntityBehaviour;
import aglobex.simulation.entitysimulator.EntityState;
import aglobex.simulation.global.EntityRecord;
import aglobex.simulation.ontology.WorldDimension;
import aglobex.vecmath.Point3d;

/**
 * Behaviour of things that do not move yet have their position in the world.
 * @author Eduard Semsch
 *
 */
public class LocationBehaviour implements EntityBehaviour {

	private EntityState myState;
	
	/**
	 * Control does not have any influence.
	 */
	public void control(Object content, String reason) {
		// not implemented
	}

	public void dispose() {
		// TODO Auto-generated method stub
	}

	public void entityCrashed(EntityBehaviour otherObject, long fromTime) {
		// TODO Auto-generated method stub
	}

	public PlanUpdate getPlanUpdate(boolean removeOld) {
		// TODO Auto-generated method stub
		return null;
	}

	/**
	 * Tries to find out the state (position) in the world.
	 */
	public void init(ControlLink controlLink, EntityRecord entityRecord, WorldDimension worldDimesion) throws Exception {
		AcrossMapNodes amn = (AcrossMapNodes) entityRecord.entityDescriptor.typeDescriptor.userObjects.get(AcrossDataConstants.MAP_NODES);
		String myNode = entityRecord.entityDescriptor.confParamsString.get(AcrossDataConstants.ENTITY_START_NODE);
		Point3d p = null;
		for (Node node : (List<Node>) amn.getNode()) {
			if(node.getName().equals(myNode)) {
				p = new Point3d(node.getX(),node.getY(),0);
			}
		}
		if(p==null) {
			throw new RuntimeException("Entity does not have a position on the map");
		} else {
			myState = new EntityState();
			myState.position = p;
		}
	}

	/**
	 * Returns the same state over and over.
	 */
	public EntityState updateEntityState(long timeStep, long currentSimulationTimestamp) {
		return myState;
	}

}
