package across.agents.emergency.repair;

import across.agents.emergency.centre.AcrossActivity;

/**
 * This is a collection of constants specifing the language that describes possible 
 * activities the RepairVehicleAgent can possibly carry out.  These constants are
 * the activity types for the {@link AcrossActivity} class.
 * @author Eduard Semsch
 *
 */
public interface RepairVehicleActivities {

	/** 
	 * Tells the driver to go to some place.  The place can either be
	 * a node, or it can be a road.  There can also be specified an
	 * object to which the driver should drive to and stop.
	 * <p>
	 * Params:
	 * <li> Key=TO, Value=Node where to go (required)
	 * <li> Key=FROM, Value=Node where to start the route (optional)
	 * <li> Key=OBJECT, Value=ObjectID to which it should go to
	 */
	public static final String ACTIVITY_GOTO = "ACTIVITY_GOTO";
	
	/**
	 * Tells the driver to pickup something somewhere.
	 * <p>
	 * Params:
	 * <li> Key=WHERE, Value=Node/object where to pick the thing up (required)
	 * <li> Key=BATCH, Value=Batch to pickup (either this or the param below)
	 * <li> Key=MATERIAL_ID, Value=String - the material id
	 * <li> Key=AMOUNT, Value=integer - amount of material (required if MATERIAL_ID is used)
	 */
	public static final String ACTIVITY_PICKUP = "ACTIVITY_PICKUP";
	
	/**
	 * Tells the driver to drop down something.
	 * <p>
	 * Params same as ACTIVITY_PICKUP
	 */
	public static final String ACTIVITY_DROP = "ACTIVITY_DROP";
	
	/**
	 * Use the driver effect on object.
	 * <p>
	 * Params:
	 * <li>Key=WHERE,Value=Node/object where to use the effect.
	 */
	public static final String ACTIVITY_EFFECT = "ACTIVITY_EFFECT";
	
}
