package across.agents.driver.gui;

import java.util.Iterator;
import java.util.List;

import javax.swing.table.AbstractTableModel;

import across.agents.driver.data.RoadInfo;
import across.data.Batch;
import across.data.RequestList;
import across.data.Waypoint;

public class RouteTabModel extends AbstractTableModel{

  DriverGUIInterface core;

  final String[] names = {"From",
                          "To",
                          "Time",
                          "Price",
                          "Goal"};

  public RouteTabModel(DriverGUIInterface core) {
    this.core = core;
  }

  /** Returns number of columns */
  public int getColumnCount() {
    return names.length;
  }

  /** Returns number of rows */
  public int getRowCount() {
    return core.getWaypoints().size();
  }

  /** This method returns names of columns in table header */
  public String getColumnName(int col) {
    return names[col];
  }

  /**
   * Returns value at cell [row,col]
   *
   * @param rowIndex int
   * @param columnIndex int
   * @return Object
   */
  public Object getValueAt(int row, int col) {
    String from, to;
    Waypoint toWP;
    if (row==0) {
      from = core.getActualNode();
      toWP = (Waypoint)core.getWaypoints().getFirst();
    }
    else {
      from = ((Waypoint)core.getWaypoints().get(row-1)).getLocationName();
      toWP = (Waypoint)core.getWaypoints().get(row);
    }
    to = toWP.getLocationName();
    int fromIndex = core.getNodeNames().indexOf(from);
    int toIndex = core.getNodeNames().indexOf(to);
    RoadInfo arcValue = core.getArcs()[fromIndex][toIndex];
    switch (col) {
      case 0:
        return from;
      case 1:
        return to;
      case 2:
        if (arcValue == null) return new Integer(0);
        else return new Double((double)((int)(100*arcValue.time))/100);
      case 3:
        if (arcValue == null) return new Integer(0);
        else return new Double((double)((int)(100*arcValue.price))/100);
      case 4:
        List rl = toWP.getRequestList();
        if (rl.size()==0) return "Pass";
        else // petr return "Load/Unload";
        { String s = "";
          for (Iterator i=rl.iterator(); i.hasNext(); ) {
            RequestList r = (RequestList)i.next();
            for (Iterator j = r.getBatch().iterator(); j.hasNext();) {
              Batch b = (Batch)j.next();
              s = s + "("+b.getComodityName()+"/"+b.getCount()+") ";
            }
          }
          return s;
        }
    }
    return "";
  }

}
