package across.agents.driver.gui;

import java.util.Iterator;
import java.util.List;

import javax.swing.table.AbstractTableModel;

import across.data.Batch;
import across.data.RequestList;

public class RequestTabModel extends AbstractTableModel{

  List requests;

  final String[] names = {"Delivery Agent",
                          "Commodity",
                          "Count",
                          "Time",
                          "BatchID"};

  public RequestTabModel(List requests) {
    this.requests = requests;
  }

  /** Returns number of columns */
  public int getColumnCount() {
    return names.length;
  }

  /** Returns number of rows */
  public int getRowCount() {
    int i = 0;
    for (Iterator iter = requests.iterator(); iter.hasNext(); ) {
      RequestList rl = (RequestList)iter.next();
      i+= rl.getBatch().size();
    }
    return i;
  }

  /** This method returns names of columns in table header */
  public String getColumnName(int col) {
    return names[col];
  }

  /**
   * Returns value at cell [row,col]
   *
   * @param rowIndex int
   * @param columnIndex int
   * @return Object
   */
  public Object getValueAt(int row, int col) {
    int i = 0;
    Batch selectedBatch = null;
    String agentName = "";
    for (Iterator iter = requests.iterator(); iter.hasNext(); ) {
      RequestList rl = (RequestList)iter.next();
      for (Iterator iter2 = rl.getBatch().iterator(); iter2.hasNext(); ) {
        Batch batch = (Batch) iter2.next();
        if (i==row) {
          selectedBatch = batch;
          break;
        }
        i++;
      }
      if (selectedBatch!=null) {
        agentName = rl.getDeliveryAddress().getName();
        break;
      }
    }
    switch (col) {
      case 0:
        return agentName;
      case 1:
        return selectedBatch.getComodityName();
      case 2:
        return new Long(selectedBatch.getCount());
      case 3:
        return new Long(selectedBatch.getDeliveryTime());
      case 4:
        return new Long(selectedBatch.getBatchid());
    }
    return "";
  }

}
