package across.agents.driver.gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

import across.data.Waypoint;
import aglobe.container.Store;

public class DriverAgentGUI extends JFrame{

  private final DriverGUIInterface owner;
  private final Store store;
  private static final String GUI_X= "gui/x";
  private static final String GUI_Y= "gui/y";
  private static final String GUI_W= "gui/w";
  private static final String GUI_H= "gui/h";
  public int routeTabSelectedRow = 0;
  TitledBorder bordInfo = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Info");
  TitledBorder bordRoute = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Route");
  TitledBorder bordRequest = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Requests");
  TitledBorder bordManual = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Manual Command");
  JTextArea jTextAreaTopic = new JTextArea();
  JPanel jPanel1 = new JPanel();
  JComboBox jComboBoxWP = new JComboBox();
  JButton jButtonGo = new JButton();
  JScrollPane jScrollPane1 = new JScrollPane();
  public RouteTabModel routeTabModel;
  public JTable routeTable;
  public RequestTabModel requestTabModel;
  public JTable requestTable;
  public JScrollPane jScrollPaneRoute = new JScrollPane();
  public JScrollPane jScrollPaneRequest = new JScrollPane();
  public JPanel jPanelManual = new JPanel();
  public JPanel jPanelInfo = new JPanel();
  public GridBagLayout gridBagLayout1 = new GridBagLayout();
  public JLabel jLabelPosition = new JLabel();
  public JLabel jLabelCapacity = new JLabel();
  public JTextField jTextFieldPosition = new JTextField();
  public JProgressBar jProgressBarCapacity = new JProgressBar();
  public JLabel jLabelTransporter = new JLabel();
  public JLabel jLabelConsumption = new JLabel();
  public JLabel jLabelSpeed = new JLabel();
  public JLabel jLabelTaskTime = new JLabel();
  public JTextField jTextFieldTransporter = new JTextField();
  public JTextField jTextFieldTaskTime = new JTextField();
  public JTextField jTextFieldConsumption = new JTextField();
  public JTextField jTextFieldSpeed = new JTextField();
  public GridBagLayout gridBagLayout2 = new GridBagLayout();
  public BorderLayout borderLayout1 = new BorderLayout();


  public DriverAgentGUI(DriverGUIInterface owner) {
    this.owner = owner;
    store = owner.getContainer().getAgentStore(owner.getName());
    try {
      jbInit();
      pack();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  public void addToCombo(String text){
    jComboBoxWP.addItem(text);
  }

  public void addToTextArea(String text){
	  if(jTextAreaTopic.getText().length()>1000) {
		  jTextAreaTopic.setText("");
	  }
	  jTextAreaTopic.append(text + "\n");
  }

  private void jbInit() throws Exception {
    this.setTitle("DriverAgent " + owner.getName());
    this.setSize(new Dimension(580, 600));
    this.getContentPane().setLayout(gridBagLayout1);

    routeTabModel = new RouteTabModel(owner);
    routeTable = new JTable(routeTabModel);
    routeTable.setRowSelectionAllowed(true);

    requestTabModel = new RequestTabModel(new java.util.ArrayList(0));
    requestTable = new JTable(requestTabModel);

    jButtonGo.setMaximumSize(new Dimension(75, 25));
    jButtonGo.setMinimumSize(new Dimension(75, 25));
    jButtonGo.setPreferredSize(new Dimension(75, 25));
    jButtonGo.setMnemonic('M');
    jButtonGo.setText("Move");
    jButtonGo.addActionListener(new DriverAgentGUI_jButtonGo_actionAdapter(this));
    jTextAreaTopic.setLineWrap(true);
    jScrollPaneRoute.setBorder(bordRoute);
    jScrollPaneRequest.setBorder(bordRequest);
    jPanelManual.setBorder(bordManual);
    jPanelManual.setMaximumSize(new Dimension(60, 40));
    jPanelManual.setMinimumSize(new Dimension(60, 40));
    jPanelManual.setPreferredSize(new Dimension(60, 40));
    jPanelManual.setLayout(borderLayout1);
    jPanelInfo.setBorder(bordInfo);
    jPanelInfo.setLayout(gridBagLayout2);
    jLabelPosition.setText("Position:");
    jLabelCapacity.setText("Capacity:");
    jTextFieldPosition.setEditable(false);
    jTextFieldPosition.setText("");
    jLabelTransporter.setText("Transporter:");
    jLabelConsumption.setText("Consumption:");
    jLabelSpeed.setText("Speed:");
    jLabelTaskTime.setText("Task Time:");
    jTextFieldTransporter.setEditable(false);
    jTextFieldTransporter.setText("");
    jTextFieldTaskTime.setEditable(false);
    jTextFieldTaskTime.setText("0");
    jTextFieldConsumption.setEditable(false);
    jTextFieldConsumption.setText("");
    jTextFieldSpeed.setEditable(false);
    jTextFieldSpeed.setText("");
    routeTable.addMouseListener(new DriverAgentGUI_routeTable_mouseAdapter(this));
    jProgressBarCapacity.setStringPainted(true);
    this.getContentPane().add(jPanelInfo,                   new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 1, 0, 1), 435, 0));
    jPanelInfo.add(jLabelPosition,  new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(-8, 0, 0, 118), 12, 6));
    this.getContentPane().add(jScrollPaneRoute,           new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 1, 0, 1), 100, 80));
    jScrollPaneRoute.getViewport().add(routeTable, null);
    jPanel1.add(jComboBoxWP, null);
    jPanel1.add(jButtonGo, null);
    jPanelManual.add(jScrollPane1, BorderLayout.CENTER);
    jPanelManual.add(jPanel1, BorderLayout.NORTH);
    jScrollPane1.getViewport().add(jTextAreaTopic, null);
    this.getContentPane().add(jScrollPaneRequest,     new GridBagConstraints(0, 2, 1, 1, 1.0, 0.5
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 3, 0, 3), -12, -351));
    this.getContentPane().add(jPanelManual,     new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 3, 2, 3), 438, 110));
    jScrollPaneRequest.getViewport().add(requestTable, null);
    jPanelInfo.add(jTextFieldTaskTime,  new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(-8, 0, 0, 2), 34, 0));
    jPanelInfo.add(jLabelCapacity,    new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5, 0, 4, 118), 7, 0));
    jPanelInfo.add(jTextFieldSpeed,     new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(3, 0, 4, 2), 34, 0));
    jPanelInfo.add(jTextFieldPosition,       new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(-8, 56, 0, 0), 118, 0));
    jPanelInfo.add(jProgressBarCapacity,          new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(6, 56, 4, 0), -26, 0));
    jPanelInfo.add(jLabelConsumption,       new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5, 7, 4, 107), 9, 0));
    jPanelInfo.add(jTextFieldTransporter,        new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(-8, 90, 0, 0), 107, 0));
    jPanelInfo.add(jTextFieldConsumption,          new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(3, 89, 4, 73), 34, 0));
    jPanelInfo.add(jLabelTransporter,     new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(-8, 6, 0, 108), 13, 6));
    jPanelInfo.add(jLabelTaskTime,   new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(-8, 4, 0, 0), 1, 6));
    jPanelInfo.add(jLabelSpeed,     new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5, 5, 4, 18), 0, 0));
  }

  public void setVisible(boolean parm1) {
    if (!parm1) {
      java.awt.Point p= getLocation();
      store.putInt(GUI_X, p.x);
      store.putInt(GUI_Y, p.y);

      Dimension d= getSize();
      store.putInt(GUI_W, d.width);
      store.putInt(GUI_H, d.height);
    } else {
      if (store.exist(GUI_X)) {
        java.awt.Point loc = getLocation();
        int x = store.getInt(GUI_X, loc.x);
        int y = store.getInt(GUI_Y, loc.y);
        setLocation(x, y);

        Dimension d = getPreferredSize();
        int w = store.getInt(GUI_W, d.width);
        int h = store.getInt(GUI_H, d.height);
        setSize(w, h);
      }
    }
    super.setVisible(parm1);
  }

  void jButtonGo_actionPerformed(ActionEvent e) {
    owner.sendRequest((String)jComboBoxWP.getSelectedItem());
  }

  void routeTable_mouseClicked(MouseEvent e) {
    routeTabSelectedRow = routeTable.getSelectedRow();
    Waypoint wp = (Waypoint)owner.getWaypoints().get(routeTabSelectedRow);
    requestTabModel = new RequestTabModel(wp.getRequestList());
    requestTable.setModel(requestTabModel);
  }

  public void clearRequestTable(){
    requestTabModel = new RequestTabModel(new java.util.ArrayList(0));
    requestTable.setModel(requestTabModel);
  }

  public void decreaseRouteTableSelection(){
    routeTabSelectedRow--;
    routeTable.setRowSelectionInterval(routeTabSelectedRow,routeTabSelectedRow);
  }

}

class DriverAgentGUI_jButtonGo_actionAdapter implements java.awt.event.ActionListener {
  DriverAgentGUI adaptee;

  DriverAgentGUI_jButtonGo_actionAdapter(DriverAgentGUI adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jButtonGo_actionPerformed(e);
  }
}

class DriverAgentGUI_routeTable_mouseAdapter extends java.awt.event.MouseAdapter {
  DriverAgentGUI adaptee;

  DriverAgentGUI_routeTable_mouseAdapter(DriverAgentGUI adaptee) {
    this.adaptee = adaptee;
  }
  public void mouseClicked(MouseEvent e) {
    adaptee.routeTable_mouseClicked(e);
  }
}
