package across.agents.driver.data;

/**
 * Info about an arc (a road between two nodes) - it specifies how expensive
 * it is to involve this road in the route, tells whether the road is passable etc.
 * @author Eduard Semsch
 *
 */
public class RoadInfo {
	
	/** Time that it will take to take this road */
	public double time;
	
	/** Price it will cost to take this road */
	public double price;
	
	/** Can we go through this road or not? */
	public boolean passable; 
  
	public RoadInfo(double t, double p) {
		time = t;
		price = p;
		passable = true;
	}
}

