package across.agents.driver.data;

/**
 * Auxilliary data class for the Dijkstra algorithm in DriverAgent.
 */
public class NodeValue{
  /** value of the node */
  public double value;
  
  /** index of the previous node (from the NodeNames) */
  public int previous; 
  
  /** index of this node */
  public int nodeIndex;

  public NodeValue(int nodeIndex){
    this.nodeIndex = nodeIndex;
    previous = -1;
    value = -1;
  }

  public double getValue(){
    return value;
  }

  public void setValue(double value){
    this.value = value;
  }

  public int getPrevious(){
    return previous;
  }

  public void setPrevious(int previous){
    this.previous = previous;
  }

  public int getNodeIndex(){
    return nodeIndex;
  }

  public void setNodeIndex(int nodeIndex){
    this.nodeIndex = nodeIndex;
  }
}
