package across.agents;

import java.util.Arrays;
import java.util.LinkedList;

import across.simulation.constants.AcrossTopicConstants;
import aglobe.container.agent.CMAgent;
import aglobe.container.sysservice.directory.DirectoryException;
import aglobe.container.sysservice.directory.DirectoryService;
import aglobe.container.task.ConversationUnit;
import aglobe.container.task.Task;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.Message;
import aglobe.ontology.MessageConstants;
import aglobe.service.gis.client.GISClientService;
import aglobe.service.gis.client.GISTopicListener;
import aglobex.simulation.global.ClientServerTopicConstants;
import aglobex.simulation.ontology.entity.EntityDescriptor;
import aglobex.simulation.sensor.UniversalSensorAgent;

/**
 * This agent holds the IX planner that is able to produce rescue plans
 * for the disasters.
 * @author Eduard Semsch
 *
 */
public class AgentShell extends CMAgent implements ClientServerTopicConstants, GISTopicListener {

	/** Type of this agent by which it is known at the directory service. */
	public static final String TYPE = "IXPlanner";
	
	/** GIS shell. */
	protected GISClientService.Shell gisShell;
	
	/** Directory service shell. */
	protected DirectoryService.Shell dirShell;
	
	@Override
	public void init(AgentInfo ai, int initState) {
		gisShell = (GISClientService.Shell) this.getContainer().getServiceManager().getService(this, GISClientService.SERVICENAME);
		dirShell = (DirectoryService.Shell) this.getContainer().getServiceManager().getService(this, DirectoryService.SERVICENAME);
		if(gisShell!=null && dirShell!=null) {
			gisShell.subscribeTopic(TOPIC_ENTITY_CONNECTION, this);
			gisShell.subscribeTopic(TOPIC_ENTITY_CONTROL, this);
			gisShell.subscribeTopic(TOPIC_SIMULATION_TIME_UPDATE_1_SECOND, this);
			gisShell.subscribeTopic(UniversalSensorAgent.TOPIC_SENSORY_DATA,this);
			gisShell.subscribeTopic(AcrossTopicConstants.TOPIC_SIMULATION_OBJECT, this);
		} else {
			logSevere("Unable to locate GIS!");
			this.stop();
		}
		try {
			dirShell.register(this, new LinkedList<String>(Arrays.asList(new String[]{TYPE})));
		} catch (DirectoryException e) {
			e.printStackTrace();
		}
		this.setIdleTask(new IXPlannerIdleTask(this));
	}
	
	/**
	 * Agents idle task - handles new incoming messages that 
	 * does not have known conversation ids.
	 * @author Eduard Semsch
	 *
	 */
	protected class IXPlannerIdleTask extends Task implements MessageConstants {

		public IXPlannerIdleTask(ConversationUnit cu) {
			super(cu);
		}

		/**
		 * This method handles all the incoming messages that does not have
		 * known conversation ids. 
		 */
		@Override
		protected void handleIncomingMessage(Message m) {
			// TODO Auto-generated method stub
			
		}
		
	}
	
	/**
	 * This method handles the incoming topics from the simulation.
	 */
	public void handleTopic(String topic, Object content, String reason) {
		if(topic.equalsIgnoreCase(TOPIC_ENTITY_CONNECTION)) {
			if(content instanceof EntityDescriptor) {
				handleConfiguration((EntityDescriptor) content);
			}
		}
	}
	
	/**
	 * This method handles configuration.
	 * @param ed
	 */
	private void handleConfiguration(EntityDescriptor ed) {
		
		 // display visio information
        String visioInfo = "<b>" + this.getName();
        gisShell.submitTopicToServer(across.visio.oldvisio.VisioConnectionAgent.TOPIC_VISIO_INFO, visioInfo);
	}
}
