/**
 * Title:        Visualizer for CPlanT
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Gerstner Laboratory, FEL-�VUT, Prague
 * @author Michal Dob�ek
 * @version 1.0
 */

package across.visio.visual;

// JAVA imports
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import across.data.Batch;
import across.data.CoalitionDescription;
import across.data.ItemCoverage;
import across.data.Proposal;
import across.data.RequestList;
import across.data.TeamProposal;
import across.data.TransportBatch;
import across.data.TransportCfp;
import across.visio.VisualAgent;
import across.visio.ont.AllianceDescription;
import across.visio.ont.CPlantAgentDescription;
import across.visio.ont.DFAgentDescription;

/**
 * The <code>Visualizer</code> sits on top of all visual components. It constructs
 * <code>Screen</code> and maintains the actual model of the CPlanT system.
 * It gets new events from VisualAgent and provides interface between GUI elements
 * and the model (e.g. <code>setColorSchema</code>, <code>setDisplayTask</code>).
 */

public class Visualizer
{
  VisualAgent _owner;
  private Screen _screen;

  public List _agents;
  private List _alliances;
  private List _tasks;
  private List _coalitions;

  private AllianceTreeModel _atm;
  private TaskTreeModel     _ttm;

  private TaskTreeModel _ctm;

  private ColorFactory      _cf;


  public Visualizer(VisualAgent owner) {
    _owner= owner;
    _agents= new LinkedList();
    _alliances= new LinkedList();
    _tasks= new LinkedList();
    _coalitions = new LinkedList();

    _atm= new AllianceTreeModel(_agents, _alliances);
    _ttm= new TaskTreeModel(_tasks);
    _ctm = new TaskTreeModel(_coalitions);

    _cf= ColorFactory.getDefaultFactory();
    _screen= new Screen(Visualizer.this, _atm, _ttm, _ctm);
    _screen.setVisible(true);
  }

 public Screen getScreen() {
   return _screen;
 }

  public void quit()
  {
    _owner.quit();
  }

  public void shutdown()
  {
    _screen.dispose();
    _screen = null;
  }


  public void setVisibility(String name, boolean visible) {
    for (Iterator it = _agents.iterator(); it.hasNext();){
       VisAgent va = (VisAgent) it.next();
       if (va.getName().equals(name)) {
         // agent is already registred => this is update inform
         va.setVisibility(visible);
         _atm.fireTreeChange();
         return;
       }
    }

  }

  /**
   * MessageAnalyserListener implementing methods
   */
  public void registerAgent(final DFAgentDescription dfad, final CPlantAgentDescription cpad) {
    for (Iterator it = _agents.iterator(); it.hasNext(); ) {
      VisAgent va = (VisAgent) it.next();
      if (va.getName().equals(dfad.getName())) {
        // agent is already registred => this is update inform
        va.dfAD.setOwner(dfad.getOwner());
        va.dfAD.setType(dfad.getType());
        va.cpAD.setCity(cpad.getCity());
        va.cpAD.setCountry(cpad.getCountry());

        _atm.fireTreeChange();
        return;
      }
    }

  // agent is not registred => register it!

  final Visualizer vi = this;
//  SwingUtilities.invokeLater(new Runnable() {
  //    public void run() {

     // _owner.getLogger().warning("kokoa"+kok);
      _agents.add(new VisAgent(dfad, cpad, _agents, vi));
   //   _owner.getLogger().warning("kokob"+kok);

   //   }
  //});

//     _agents.add(new VisAgent(dfad, cpad, _agents, this));

//  _agents.add(new VisAgent(dfad, cpad, _agents, this));

 // _atm.fireTreeChange();

/*JT old:
    if(!_agents.contains(new VisAgent.Comparator(dfad.getName())))
    {
      _agents.add(new VisAgent(dfad, cpad, _agents, this));
      _atm.fireTreeChange();
    }
*/
  }

  public void deregisterAgent(DFAgentDescription dfad)
  {
    int i= _agents.indexOf(new VisAgent.Comparator(dfad.getName()));
    if(i!=-1)
    {
      VisAgent a= (VisAgent)_agents.get(i);
      _agents.remove(i);
      a.deregister();
      _atm.fireTreeChange();
      _ttm.fireTreeChange();
    }
  }

  public void newAlliance(AllianceDescription ad)
  {
    List members= ad.getMembers();
    List toadd= new LinkedList();
    VisAlliance cural= null;
    String alName = null;
    Iterator m= ad.getMembers().iterator();
    while(m.hasNext())
    {
      String name= (String)m.next();
      int i= _agents.indexOf(new VisAgent.Comparator(name));
      if(i==-1) {
        System.out.println("Unknown agent in alliance! - " + name +
                           _agents.toString());
        //       owner.logger.
        DFAgentDescription dfd = new DFAgentDescription(name, "unknown", "unknown owner");
        CPlantAgentDescription cad = new CPlantAgentDescription(name, "no city", "no country");
        registerAgent(dfd,cad);
      }
      else
      {
        VisAgent agent= (VisAgent)_agents.get(i);
        VisAlliance alliance= agent.getAlliance();
        alliance = null;
        if(alliance==null)
          toadd.add(agent);
        else if(cural==null)
          cural= alliance;
        else if(alliance!=cural)
          toadd.add(agent);
      }
    }

    if(cural==null)
      cural= new VisAlliance(this, _screen.getDesktop(), ad.getName());

    cural.addMembers(toadd);
    if(!_alliances.contains(cural))
    {
      _alliances.add(cural);
      _screen.autoArrangeAlliances();
    }

    _atm.fireTreeChange();
    _ttm.fireTreeChange();
  }


      public boolean newCoalition(CoalitionDescription cd, String locationInitiatorName, String id, String initiator)
      {
        boolean ok = false;
        int position = _tasks.indexOf(new VisTask.Comparator(locationInitiatorName+": "+ id));
        if (position > -1) {
          VisTask task = (VisTask)_tasks.get(position);
          List childs = task.getChildren();

          position =  childs.indexOf(new VisData.Comparator(initiator));
          if (position > -1) {

            VisData locationInitiator = (VisData)childs.get(position);


            boolean added = false;
            for (Iterator i = _coalitions.iterator(); i.hasNext();) {
              VisTask vt = (VisTask)i.next();

              if (vt.getName().contains(id) & (vt.getName().contains(initiator))) {

                if (!vt.getName().contains("Transporter")) {
                  // merge coalitions
                  VisCoalition vc = (VisCoalition) (vt.getCoalitions()).get(0);
                  List newAgents = cd.getCoalitionMember();
                  for (Iterator j = newAgents.iterator(); j.hasNext(); ) {
                    vc.addAgentToCoalition( (String) j.next());
                  }
                  if (!newAgents.contains(cd.getCoalitionLeader())) {
                    vc.addAgentToCoalition(cd.getCoalitionLeader());
                  }
                  setDisplayTask(vt);
                  added = true;
                  ok = true;
                } else {
                  // switch and merge coalitions
                  VisCoalition vc = (VisCoalition) (vt.getCoalitions()).get(0);
                  String[] subparticipants = vc.removeAllParticipants();
                  for (int j = 0; j<subparticipants.length; j++) {
                    cd.getCoalitionMember().add(subparticipants[j]);
                  }
                  vc.insertParticipants(cd.getCoalitionLeader(), cd.getCoalitionMember(), _agents);
                  vt.setName(cd.getTaskName());
                  setDisplayTask(vt);
                  added = true;
                  ok = true;

                }
              }
            }
            if (!added) {
              VisTask coalition = new VisTask(_agents, cd);
              locationInitiator.addChild(coalition);
              _ttm.fireNodeInserted(new Object[] {task, locationInitiator},
                                        new int[] {locationInitiator.getChildCount() - 1}); //? error?
              ok = true;

              _coalitions.add(coalition);
              setDisplayTask(coalition);
              _ctm.fireNodeInserted(null, new int[] {_coalitions.size() - 1});
            }
          }
        }
        if (!ok) {
          System.out.println("coalition wasn't added");
        }
        return ok;
      }



   public void newLocCFPRequest(RequestList requestList, Collection participants, String name) {
     VisTask t;
       t= new VisTask(_agents, requestList, participants, name);
       _tasks.add(t);
   //  _ttm.fireTreeChange();
      _ttm.fireNodeInserted(null,  new int[] {_tasks.size()-1});
     //setDisplayTask(t);

   }



   public void addTransporLeaderProposal(Proposal prop, String proposer,
                                 TransportCfp cfp,
                                 java.util.Map batchesById,
                                 java.util.Map locationNames,
                                 java.util.Map locationBatches,
                                 Proposal myProposal, TeamProposal teamProposal) {

     String locationName = (String) locationNames.get(parseId(prop.
         getRequestid(), 0));
     String locationInitiator = parseId(prop.getRequestid(), 1);

     int position = _tasks.indexOf(new VisTask.Comparator(locationName + ": " +
         parseId(prop.getRequestid(), 0)));

     if (position > -1) {
       VisTask task = (VisTask) _tasks.get(position);
       List childs = task.getChildren();

       position = childs.indexOf(new VisData.Comparator(locationInitiator));
       if (position > -1) {
         VisData location = (VisData) childs.get(position);
         childs = location.getChildren();
         position = childs.indexOf(new VisData.Comparator("Transport"));
         VisData transport;
         if (position > -1) {
           transport = (VisData) childs.get(position);
         }
         else {
           transport = new VisData("Transport", TreeMember.ntTASKTRANSPORT);
           location.addChild(transport);
           _ttm.fireNodeInserted(new Object[] {task, location}
                                 , new int[] {location.getChildCount() - 1});

         }

         childs = transport.getChildren();
         position = childs.indexOf(new VisData.Comparator(proposer + " from " +
             locationInitiator));
         VisData leader;
         if (position < 0) { // add the leader now
           leader = new VisData(proposer + " from " +
                                locationInitiator,
                                TreeMember.ntCOALITIONLEADER);
           transport.addChild(leader);
           _ttm.fireNodeInserted(new Object[] {task, location, transport}
                                 , new int[] {transport.getChildCount() - 1});

         }
         else {
           leader = (VisData) childs.get(position);
         }

         VisData proposerAgent = new VisData(proposer, TreeMember.ntAGENT);
         leader.addChild(proposerAgent);
         _ttm.fireNodeInserted(new Object[] {task, location, transport, leader},
                               new int[] {leader.getChildCount() - 1});
         double cov = 0;
         boolean ok = false;

         boolean match = false;

         if (myProposal != null) {
           for (Iterator iterator = myProposal.
                getItemCoverage().iterator(); // prinos leadera
                iterator.hasNext(); ) {
             ItemCoverage ic = (ItemCoverage) iterator.next();
             String itemName = "";
             for (Iterator j = teamProposal.getRequestedServices().getTransportBatch().
                  iterator(); j.hasNext(); ) {

               TransportBatch tb = (TransportBatch) j.next();
               if (tb.getBatchid() == ic.getItemid()) {
                 match = true;
                 itemName = tb.getComodityName();
                 List requested = (List) locationBatches.get(parseId(
                     myProposal.
                     getRequestid(), 0));
                 for (Iterator k = requested.iterator(); k.hasNext(); ) {
                   Batch b = (Batch) k.next();
                   if (b.getComodityName().equalsIgnoreCase(itemName)) {
                     cov = (double) tb.getCount() * ic.getCoverage() /
                         b.getCount();
                     ok = true;
                     break;
                   }
                 }
                 break;
               }
             }
             VisData item = new VisData(itemName + " " + (int) (cov * 100) +
                                        " %",
                                        TreeMember.ntTASKDATA);
             if (!ok) {
               //System.out.println("not set error "+match);
             } else {
               item.setProgress( (int) (cov * 100));
               proposerAgent.addChild(item);
               _ttm.fireNodeInserted(new Object[] {task, location, transport,
                                     leader, proposerAgent},
                                     new int[] {proposerAgent.getChildCount() -
                                     1});

             }
           }
         }
         ok = false;
         for (Iterator it = prop.getItemCoverage().iterator(); it.hasNext(); ) { // whole poroposal
           ItemCoverage ic = (ItemCoverage) it.next();
           String itemName = "";

           for (Iterator ite = teamProposal.getTransportCfp().
                getTransportBatch().iterator(); ite.hasNext(); ) {

             TransportBatch tb = (TransportBatch) ite.next();
             if (tb.getBatchid() == ic.getItemid()) {
               itemName = tb.getComodityName();

               List requested = (List) locationBatches.get(parseId(cfp.
                   getRequestid(),0));
                 for (Iterator k = requested.iterator(); k.hasNext(); ) {
                   Batch b = (Batch) k.next();

                   if (b.getComodityName().equalsIgnoreCase(itemName)) {

                     cov = (ic.getCoverage() * tb.getCount()) / b.getCount();
                     ok = true;
                     break;
                   }
                 }
                 break;
             }
           }

           if (ok) {
             VisData newItem = new VisData(itemName + " " +
                                           (int) (cov * 100) + "%",
                                           TreeMember.ntTASKDATA);
             newItem.setProgress( (int) (cov * 100));
             leader.addChild(newItem);

             _ttm.fireNodeInserted(new Object[] {task, location, transport,
                                   leader}
                                   , new int[] {leader.getChildCount() - 1});
           }
           if (!ok) {
             System.out.println("no set error");
           }
         }

       }
       else {
         System.out.println("no location error");
       }

     }
     else {
       System.out.println("no task error");
     }

   }


   public void addTransportLeaderSubcontractProposal(Proposal prop,
       String proposer, String transporterInitiator,
       TransportCfp cfp,
       java.util.Map batchesById,
       java.util.Map locationNames,
       java.util.Map locationBatches, Proposal myProposal,
       TeamProposal teamProposal) {

     if (myProposal != null) {

       String locationName = (String) locationNames.get(parseId(myProposal.
           getRequestid(), 0));
       int position = _tasks.indexOf(new VisTask.Comparator(locationName + ": " +
           parseId(myProposal.getRequestid(), 0)));

       if (position > -1) {
         VisTask task = (VisTask) _tasks.get(position);
         List childs = task.getChildren();

         position = childs.indexOf(new VisData.Comparator(parseId(myProposal.
             getRequestid(), 1)));

         if (position > -1) {
           VisData location = (VisData) childs.get(position);
           childs = location.getChildren();
           position = childs.indexOf(new VisData.Comparator("Transport"));
           VisData transport;
           if (position > -1) {
             transport = (VisData) childs.get(position);
           }
           else {
             transport = new VisData("Transport", TreeMember.ntTASKTRANSPORT);
             location.addChild(transport);
             _ttm.fireNodeInserted(new Object[] {task, location}
                                   , new int[] {location.getChildCount() - 1});

           }

           childs = transport.getChildren();
           position = childs.indexOf(new VisData.Comparator(transporterInitiator +
               " from " +
               parseId(myProposal.getRequestid(), 1)));
           VisData leader;
           if (position < 0) { // add the leader now
             leader = new VisData(transporterInitiator + " from " +
                                  parseId(myProposal.getRequestid(), 1),
                                  TreeMember.ntCOALITIONLEADER);
             transport.addChild(leader);
             _ttm.fireNodeInserted(new Object[] {task, location, transport}
                                   , new int[] {transport.getChildCount() - 1});

           }
           else {
             leader = (VisData) childs.get(position);
         //    leader.setType(TreeMember.ntTASKGOODS);
             _ttm.fireNodeChanged(new Object[] {task, location, transport},
                                  leader);
           }

           childs = leader.getChildren();
           position = childs.indexOf(new VisData.Comparator("subcontract"));
           VisData subContract;
           if (position < 0) {
             subContract = new VisData("subcontract", TreeMember.ntTASKDATA);
             leader.addChild(subContract);
             _ttm.fireNodeInserted(new Object[] {task, location, transport,
                                   leader}
                                   , new int[] {leader.getChildCount() - 1});
           }
           else {
             subContract = (VisData) childs.get(position);
           }

           VisData subLeader;
           childs = subContract.getChildren();
           position = childs.indexOf(new VisData.Comparator(proposer));
           if (position < 0) {
             subLeader = new VisData(proposer, TreeMember.ntCOALITIONLEADER);
             subContract.addChild(subLeader);
             _ttm.fireNodeInserted(new Object[] {task, location, transport,
                                   leader, subContract},
                                   new int[] {subContract.getChildCount() - 1});
           }
           else {
             subLeader = (VisData) childs.get(position);
           }

           VisData subLeaderProposal = new VisData(proposer, TreeMember.ntAGENT);
           subLeader.addChild(subLeaderProposal);
           _ttm.fireNodeInserted(new Object[] {task, location, transport, leader,
                                 subContract, subLeader}
                                 , new int[] {subLeader.getChildCount() - 1});

    //       addSubLeaderToCoalition(proposer, parseId(myProposal.getRequestid(), 0));

           double cov = 0;
           boolean ok = false;

           for (Iterator iterator = myProposal.getItemCoverage().iterator();
                iterator.hasNext(); ) {
             ItemCoverage ic = (ItemCoverage) iterator.next();
             String itemName = "";
             for (Iterator j = teamProposal.getRequestedServices().
                  getTransportBatch().
                  iterator(); j.hasNext(); ) {
               TransportBatch tb = (TransportBatch) j.next();
               if (tb.getBatchid() == ic.getItemid()) {
                 itemName = tb.getComodityName();
                 List requested = (List) locationBatches.get(parseId(myProposal.
                     getRequestid(), 0));
                 for (Iterator k = requested.iterator(); k.hasNext(); ) {
                   Batch b = (Batch) k.next();
                   if (b.getComodityName().equalsIgnoreCase(itemName)) {
                     cov = (double) tb.getCount() * ic.getCoverage() /
                         b.getCount();
                     ok = true;
                     break;
                   }
                 }
                 break;
               }
             }
             VisData item = new VisData(itemName + " " + (int) (cov * 100) +
                                        " %",
                                        TreeMember.ntTASKDATA);
             if (!ok) {
               //System.out.println("not set error");
             } else {
               item.setProgress( (int) (cov * 100));
               subLeaderProposal.addChild(item);
               _ttm.fireNodeInserted(new Object[] {task, location, transport,
                                     leader, subContract, subLeaderProposal}, // pouze prispevek leadera
                                     new int[] {subLeaderProposal.getChildCount() -
                                     1});
             }
           }

           for (Iterator it = prop.getItemCoverage().iterator(); it.hasNext(); ) {
             ItemCoverage ic = (ItemCoverage) it.next();
             String itemName = "";

             for (Iterator ite = teamProposal.getTransportCfp().
                  getTransportBatch().iterator(); ite.hasNext(); ) {
               TransportBatch tb = (TransportBatch) ite.next();
               if (tb.getBatchid() == ic.getItemid()) {
                 itemName = tb.getComodityName();

                 List requested = (List) locationBatches.get(cfp.
                     getRequestid());
                 for (Iterator k = requested.iterator(); k.hasNext(); ) {
                   Batch b = (Batch) k.next();

                   if (b.getComodityName().equalsIgnoreCase(itemName)) {

                     cov = (ic.getCoverage() * tb.getCount()) / b.getCount();
                     ok = true;
                     break;
                   }
                 }
                 break;
               }
             }
             VisData newItem = new VisData(itemName + " " +
                                           (int) (cov * 100) + "%",
                                           TreeMember.ntTASKDATA);
             newItem.setProgress( (int) (cov * 100));
             if (!ok) {
               System.out.println("no set error");
             }
             subLeader.addChild(newItem);

             _ttm.fireNodeInserted(new Object[] {task, location, transport,
                                   leader, subContract, subLeader}
                                   , new int[] {subLeader.getChildCount() - 1});
           }

         }
         else {
           System.out.println("no location error");
         }

       }
       else {
         System.out.println("no task error");
       }
     }

   }


    public void newLocationOffer(Proposal proposal, String locationName, java.util.Map batchesById, String initiator)
     {
       int position = -1;
        position = _tasks.indexOf(new VisTask.Comparator(initiator+": "+proposal.getRequestid()));
        if (position < 0) {
          System.out.println("error");
        }
        else {
          VisTask t = (VisTask) _tasks.get(position);
          int oldChildCount = t.getChildCount();
          t.addLocationProposal(proposal, locationName, batchesById);
          int newChilds = t.getChildCount()-oldChildCount;
          int[] indicates = new int[newChilds];
          for (int i = 0;i<newChilds;i++) {
            indicates[i]=oldChildCount+i;
          }
          _ttm.fireNodeInserted(new Object[] {t}, indicates);
        }
    }

    public boolean bestLocationOffer(String locationName, Proposal bestProposal,
                                     String initiator) {
      int position = -1;

      position = _tasks.indexOf(new VisTask.Comparator(initiator + ": " +
          bestProposal.getRequestid()));

      if (position < 0) {
        return false;
      }

      VisTask t = (VisTask) _tasks.get(position);
      List childs = t.getChildren();
      position = childs.indexOf(new VisData.Comparator(locationName));
      if (position < 0) {
        return false;
      }
      VisData vd = (VisData) childs.get(position);
      vd.setType(TreeMember.ntTASKDISASTER);
      return true;
    }

  public void locationRefused(String name, String requestId, String initiator) {
    int position = -1;
    position = _tasks.indexOf(new VisTask.Comparator(initiator+": "+requestId));
    if (position > -1) {
      VisTask t = (VisTask) _tasks.get(position);
      t.addRefusedLocation(name);
      _ttm.fireNodeInserted(new Object[] {t}, new int[] {t.getChildCount()-1});
    }
  }

    public void acceptationReceived(String name, String requestId, String initiator) {
    int position = -1;
    if (position > -1) {
      position = _tasks.indexOf(new VisTask.Comparator(initiator + ": " +
          requestId));

      VisTask t = (VisTask) _tasks.get(position);
      t.addLocationReceivedAcceptation(name);
      _ttm.fireNodeInserted(new Object[] {t}, new int[] {t.getChildCount()-1});
    }
  }


  public void addTeamMemberSubcontractProposal(Proposal p, String proposer,
                              String transporterInitiator, TeamProposal tp,
                              java.util.Map locationNames,
                            java.util.Map locationBatches) {

  if (p != null) {
    int position = -1;
    position = _tasks.indexOf(new VisTask.Comparator( (String)
        locationNames.get(parseId(tp.getTransportCfp().getRequestid(), 0)) +
        ": " + parseId(tp.getTransportCfp().getRequestid(), 0)));
    if (position > -1) {
      VisTask t = (VisTask) _tasks.get(position);

      List childs = t.getChildren();
      position = childs.indexOf(new VisData.Comparator(parseId(p.getRequestid(),
          1)));

      if (position > -1) {

        VisData location = (VisData) childs.get(position);
        childs = location.getChildren();
        position = childs.indexOf(new VisData.Comparator("Transport"));
        VisData transport;
        if (position > -1) {
          transport = (VisData) childs.get(position);
          childs = transport.getChildren();
        }
        else {
          transport = new VisData("Transport", TreeMember.ntTASKTRANSPORT);
          location.addChild(transport);
          _ttm.fireNodeInserted(new Object[] {t, location},
                                new int[] {location.getChildCount() - 1});
        }

        List transportChilds = transport.getChildren();
        position = transportChilds.indexOf(new VisData.Comparator(transporterInitiator +
            " from " + parseId(p.getRequestid(), 1)));

        VisData leader;
        if (position < 0) {
          leader = new VisData(transporterInitiator +
            " from " + parseId(p.getRequestid(), 1),
                               TreeMember.ntCOALITIONLEADER);
          transport.addChild(leader);
          _ttm.fireNodeInserted(new Object[] {t, location, transport},
                                new int[] {transport.getChildCount() - 1});
        }
        else {
          leader = (VisData) transportChilds.get(position);
        }

        // leader vede nesubkontraktovou koalici

        childs = leader.getChildren();
        position = childs.indexOf(new VisData.Comparator("subcontract"));
        VisData subContract;
        if (position < 0) {
          subContract = new VisData("subcontract", TreeMember.ntTASKDATA);
          leader.addChild(subContract);
          _ttm.fireNodeInserted(new Object[] {t, location, transport, leader}
                                , new int[] {leader.getChildCount() - 1});
        } else {
          subContract = (VisData)childs.get(position);
        }

        childs = subContract.getChildren();
        position = childs.indexOf(new VisData.Comparator(tp.getTeamLeader().getName()));

        VisData subLeader;
        if (position < 0) {
          subLeader = new VisData(tp.getTeamLeader().getName(),
                                            TreeMember.ntCOALITIONLEADER);

                       subContract.addChild(subLeader);
                       _ttm.fireNodeInserted(new Object[] {t, location, transport, subContract},
                                new int[] {subContract.getChildCount() - 1});

        } else {
          subLeader = (VisData)childs.get(position);
        }


        childs = subLeader.getChildren();

        position = childs.indexOf(new VisData.Comparator(proposer));
        VisData proposerAgent;
        if (position < 0) {
          proposerAgent = new VisData(proposer, TreeMember.ntAGENT);
          subLeader.addChild(proposerAgent);
          _ttm.fireNodeInserted(new Object[] {t, location, transport,
                                subContract, subLeader},
                                new int[] {subLeader.getChildCount() - 1});
        } else {
          proposerAgent = (VisData)childs.get(position);
        }



        String itemName;
        double cov = 0;
        boolean ok = false;
        for (Iterator i = p.getItemCoverage().iterator(); i.hasNext(); ) {
          ItemCoverage ic = (ItemCoverage) i.next();
          itemName = "";
          for (Iterator j = tp.getRequestedServices().getTransportBatch().
               iterator(); j.hasNext(); ) {
            TransportBatch tb = (TransportBatch) j.next();
            if (tb.getBatchid() == ic.getItemid()) {
              itemName = tb.getComodityName();
              List requested = (List) locationBatches.get(parseId(tp.
                  getTransportCfp().getRequestid(), 0));
              for (Iterator k = requested.iterator(); k.hasNext(); ) {
                Batch b = (Batch) k.next();
                if (b.getComodityName().equalsIgnoreCase(itemName)) {
                  cov = (double) tb.getCount() * ic.getCoverage() /
                      b.getCount();
                  ok = true;
                  break;
                }

              }
              break;
            }
          }
          VisData item = new VisData(itemName + " " + (int) (cov * 100) +
                                     " %",
                                     TreeMember.ntTASKDATA);
          if (!ok) {
            //System.out.println("not set error");
          }
          item.setProgress( (int) (cov * 100));
          proposerAgent.addChild(item);
          _ttm.fireNodeInserted(new Object[] {t, location, transport,
                                leader, subContract, proposerAgent},
                                new int[] {proposerAgent.getChildCount() -
                                1});
        }

      }
      else {

        System.out.println("no location error " + p.getRequestid());
      }

    }
    else {
      System.out.println("no contract error");
    }
  }


}



  public void addTeamMemberProposal(Proposal p, String proposer,
                            String locationInitiator, TeamProposal tp,
                            java.util.Map locationNames,
                            java.util.Map locationBatches) {
    if (p != null) {
      int position = -1;
      position = _tasks.indexOf(new VisTask.Comparator( (String)
          locationNames.get(parseId(tp.getTransportCfp().getRequestid(), 0)) +
          ": " + parseId(tp.getTransportCfp().getRequestid(), 0)));
      if (position > -1) {
        VisTask t = (VisTask) _tasks.get(position);

        List childs = t.getChildren();
        position = childs.indexOf(new VisData.Comparator(parseId(p.getRequestid(),
            1)));

        if (position > -1) {

          VisData location = (VisData) childs.get(position);
          childs = location.getChildren();
          position = childs.indexOf(new VisData.Comparator("Transport"));
          VisData transport;
          if (position > -1) {
            transport = (VisData) childs.get(position);
            childs = transport.getChildren();
          }
          else {
            transport = new VisData("Transport", TreeMember.ntTASKTRANSPORT);
            location.addChild(transport);
            _ttm.fireNodeInserted(new Object[] {t, location},
                                  new int[] {location.getChildCount() - 1});
          }

          List transportChilds = transport.getChildren();
          position = transportChilds.indexOf(new VisData.Comparator(tp.
              getTeamLeader().
              getName() + " from " + locationInitiator));
          VisData leader;
          if (position < 0) {
            leader = new VisData(tp.getTeamLeader().getName() + " from " +
                                 locationInitiator,
                                 TreeMember.ntCOALITIONLEADER);
            transport.addChild(leader);
            _ttm.fireNodeInserted(new Object[] {t, location, transport},
                                  new int[] {transport.getChildCount() - 1});
          }
          else {
            leader = (VisData) transportChilds.get(position);
          }

          VisData proposerAgent = new VisData(proposer, TreeMember.ntAGENT);
          leader.addChild(proposerAgent);
          _ttm.fireNodeInserted(new Object[] {t, location, transport, leader},
                                new int[] {leader.getChildCount() - 1});

          String itemName;
          double cov = 0;
          boolean ok = false;
          for (Iterator i = p.getItemCoverage().iterator(); i.hasNext(); ) {
            ItemCoverage ic = (ItemCoverage) i.next();
            itemName = "";
            for (Iterator j = tp.getRequestedServices().getTransportBatch().
                 iterator(); j.hasNext(); ) {
              TransportBatch tb = (TransportBatch) j.next();
              if (tb.getBatchid() == ic.getItemid()) {
                itemName = tb.getComodityName();
                List requested = (List) locationBatches.get(parseId(tp.
                    getTransportCfp().getRequestid(), 0));
                for (Iterator k = requested.iterator(); k.hasNext(); ) {
                  Batch b = (Batch) k.next();
                  if (b.getComodityName().equalsIgnoreCase(itemName)) {
                    cov = (double) tb.getCount() * ic.getCoverage() /
                        b.getCount();
                    ok = true;
                    break;
                  }

                }
                break;
              }
            }
            VisData item = new VisData(itemName + " " + (int) (cov * 100) +
                                       " %",
                                       TreeMember.ntTASKDATA);
            if (!ok) {
              //System.out.println("not set error");
            }
            item.setProgress( (int) (cov * 100));
            proposerAgent.addChild(item);
            _ttm.fireNodeInserted(new Object[] {t, location, transport,
                                  leader, proposerAgent},
                                  new int[] {proposerAgent.getChildCount() -
                                  1});
          }

        }
        else {

          System.out.println("no location error " + p.getRequestid());
        }

      }
      else {
        System.out.println("no contract error");
      }
    }
  }


  public void setBestLeader(TransportCfp cfp, String name, String locationInitiator,
                            java.util.Map locationNames) {

    boolean ok = false;
    int position = _tasks.indexOf(new VisTask.Comparator( (String)
        locationNames.get(parseId(cfp.getRequestid(), 0)) + ": " +
        parseId(cfp.getRequestid(), 0)));
    List childs;
    if (position > -1) {
      VisTask task = ( (VisTask) _tasks.get(position));
      childs = task.getChildren();
      position = childs.indexOf(new VisData.Comparator(locationInitiator));
      if (position > -1) {
        VisData location = (VisData) childs.get(position);
        childs = location.getChildren();

        position = childs.indexOf(new VisData.Comparator("Transport"));
        if (position > -1) {
          VisData transport = (VisData) childs.get(position);
          childs = transport.getChildren();

          position = childs.indexOf(new VisData.Comparator(name + " from " +
              locationInitiator));
          VisData leader;
          if (position < 0) {
            leader = new VisData(name + " from " + locationInitiator, TreeMember.ntTASKBESTLEADER);
            transport.addChild(leader);
            _ttm.fireNodeInserted(new Object[] {task, location, transport},
                                    new int[] {transport.getChildCount() - 1});
          } else {
            leader = (VisData)childs.get(position);
          }
          leader.setType(TreeMember.ntTASKBESTLEADER);
          _ttm.fireNodeChanged(new Object[] {task, location, transport}, leader);

          ok = true;
        }
      }
    }
    if (!ok) {
     System.out.println("The best leader wasn't set!");
    }

  }



  public void setBestSubcontractLeader(TransportCfp cfp, String name, String transporterInitiator,
                            java.util.Map locationNames) {
    int position = _tasks.indexOf(new VisTask.Comparator( (String)
        locationNames.get(parseId(cfp.getRequestid(), 0)) + ": " +
        parseId(cfp.getRequestid(), 0)));
    List childs;
    if (position > -1) {
      VisTask task = ( (VisTask) _tasks.get(position));
      childs = task.getChildren();
      position = childs.indexOf(new VisData.Comparator(parseId(cfp.getRequestid(), 1)));
      if (position > -1) {
        VisData location = (VisData) childs.get(position);
        childs = location.getChildren();

        position = childs.indexOf(new VisData.Comparator("Transport"));
        if (position > -1) {
          VisData transport = (VisData) childs.get(position);
          childs = transport.getChildren();

          position = childs.indexOf(new VisData.Comparator(transporterInitiator + " from " +
              parseId(cfp.getRequestid(), 1)));
          VisData leader;
          if (position < 0) {
            leader = new VisData(transporterInitiator+" from "+parseId(cfp.getRequestid(), 1), TreeMember.ntCOALITIONLEADER);
            transport.addChild(leader);

            _ttm.fireNodeInserted(new Object[] {task, location, transport},
                                  new int[] {transport.getChildCount() - 1});
          } else {
            leader = (VisData)childs.get(position);
          }
          VisData subContract;
          childs = leader.getChildren();
          position = childs.indexOf(new VisData.Comparator("subcontract"));
          if (position < 0) {
            subContract = new VisData("sobcontract", TreeMember.ntTASKDATA);
            leader.addChild(subContract);
            _ttm.fireNodeInserted(new Object[] {task, location, transport, leader},
                                  new int[] {leader.getChildCount() - 1});
          } else {
            subContract = (VisData)childs.get(position);
          }
          childs = subContract.getChildren();
          position = childs.indexOf(new VisData.Comparator(name));
          VisData subLeader;
          if (position < 0) {
            subLeader = new VisData(name, TreeMember.ntTASKBESTLEADER);
            subContract.addChild(subLeader);
            _ttm.fireNodeInserted(new Object[] {task, location, transport, leader, subContract},
                                  new int[] {subContract.getChildCount() - 1});

          } else {
            subLeader = (VisData)childs.get(position);
            subLeader.setType(TreeMember.ntTASKBESTLEADER);
            _ttm.fireNodeChanged(new Object[] {task, location,transport, leader, subContract}, subLeader);
          }


        }
      } else {
        System.out.println("no location error");
      }
    }
  }


  public void finishCoalition(String id, java.util.Map locationNames){ //TransportCfp cfp, String name, String locationInitiator,
//                            java.util.Map locationNames) {

    int i= _coalitions.indexOf(new VisTask.Comparator(id+"'s coalition"));
    if (i < 0) {
      System.out.println("nothing to finish: "+id);
    } else {
     VisTask coalition = (VisTask)_coalitions.get(i);
     coalition.setNodeType(TreeMember.ntTASK);

//     _ttm.fireTreeChange();

     String locationName = (String)locationNames.get(parseId(id, 0));
     String locationInitiator = parseId(id, 1);

     int position = _tasks.indexOf(new VisTask.Comparator(locationName+": "+parseId(id, 0)));
     if (position > -1) {
       VisTask task = (VisTask)_tasks.get(position);
       List childs = task.getChildren();

       position = childs.indexOf(new VisData.Comparator(locationInitiator));
       if (position > -1) {
         VisData location = (VisData)childs.get(position);
         childs = location.getChildren();

         position = childs.indexOf(new VisData.Comparator("Transport"));
         if (position > -1) {
           VisData transport = (VisData)childs.get(position);
             _ttm.fireNodeChanged(new Object[] {task, location, transport}, coalition);
           } else {
             System.out.println("Coalition wasn't finished");
           }
         }
     }
   //  _ttm.fireNodeChanged(new Object[] {locatoinNames});
    }
  }


/* private void addSubLeaderToCoalition(String leader, String id) {
   CoalitionDescription cd = (CoalitionDescription)coalitionMap.get(id);
   if (cd != null) {
     cd.getCoalitionMember().add(leader);
   }
 } */


  /**
   * Other methods
   */
 protected void deleteAlliance(VisAlliance a)
 {
   _alliances.remove(a);
   if (_screen._tiling) {
     _screen.autoArrangeAlliances(); // petr
   }
 }

 protected void setColorSchema(ColorFactory.PropertyGetter g)
 {
   _cf.setColorSchema(g);
   Iterator i= _agents.iterator();
   while(i.hasNext())
     ((VisAgent)i.next()).refreshColor();
 }

 protected void setDisplayTask(VisTask t)
 {
   Iterator i= _alliances.iterator();
   while(i.hasNext())
     ((VisAlliance)i.next()).setDisplayTask(t);
 }

 public List getAlliances()
 {
   return _alliances;
 }


 public static String parseId(String s, int index) {
    String[] ids = s.split("-");
    if (index > ids.length-1) {
      return null;
    }
    return ids[index];
 }
}
