/**
 * Title:        Visualizer for CPlanT
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Gerstner Laboratory, FEL-�VUT, Prague
 * @author Michal Dob�ek
 * @version 1.0
 */

package across.visio.visual;

// JAVA imports
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import across.data.Batch;
import across.data.CoalitionDescription;
import across.data.ItemCoverage;
import across.data.Proposal;
import across.data.RequestList;
import aglobe.container.transport.Address;

/**
 * <code>VisTask</code> represents a task in the structure trees and
 * also keeps the actual task information.
 */

public class VisTask implements TreeMember
{
  private List   _agentbase;

  private List _treechildren;
 // petr private List _treechildrenwithoutcoverage;

  private String _taskname;
  private String _tasklocation;
  private String _taskdegree;
  private String _taskdisaster;

  private List   _coalitions;


  private int nodeType = ntTASKLOCATIONCFP;

  public VisTask(String s)
  {
/*    _agentbase= agentbase;
    _taskname= cd.getTaskName();
    _tasklocation= cd.getTaskLocation();
    _taskdegree= cd.getTaskDegree();
    _taskdisaster= cd.getTaskDisaster();

    _coalitions= new LinkedList();
    addCoalition(cd); */
    _taskname= s;
    _treechildren= new LinkedList();
    _treechildren.add(new VisString(_tasklocation, ntTASKLOCATION));
    _treechildren.add(new VisString(_taskdisaster, ntTASKDISASTER));
    _treechildren.add(new VisString(_taskdegree, ntTASKDEGREE));
  }


  public VisTask(List agentbase, CoalitionDescription cd)
  {
    _agentbase= agentbase;
    _taskname= cd.getTaskName();
    _tasklocation= cd.getTaskLocation();
    _taskdegree= cd.getTaskDegree();
    _taskdisaster= cd.getTaskDisaster();

    _coalitions= new LinkedList();
    addCoalition(cd);

    _treechildren= new LinkedList();
    //_treechildren.add(new VisString(_tasklocation, ntTASKLOCATION));
    //_treechildren.add(new VisString(_taskdisaster, ntTASKDISASTER));
   // _treechildren.add(new VisString(_taskdegree, ntTASKDEGREE));
  }

/*  public VisTask(List agentbase, TransportCfp cfp)
  {
    _agentbase= agentbase;
    _taskname= Long.toString(cfp.getRequestid()); // cd.getTaskName();

//    cfp.getTransportBatch()
//    _tasklocation= cfp.getcd.getTaskLocation();
  //  _taskdegree= cd.getTaskDegree();
   // _taskdisaster= cd.getTaskDisaster();

    _coalitions= new LinkedList();
   // addCoalition(cd);

    _treechildren= new LinkedList();

    for (Iterator i = cfp.getTransportBatch().iterator();i.hasNext();) {
      TransportBatch tb = (TransportBatch)i.next();
     _treechildren.add(new VisString((tb.getComodityName()+" = "+Long.toString(tb.getCount())) ,ntTASKDATA));//VisString(_tasklocation, ntTASKDEGREE));//ntTASKLOCATION));
   //  System.out.println("koko: "+tb.getCount());
    }

   // _treechildrenwithoutcoverage = new LinkedList(_treechildren);

  //    _treechildren.add(new VisString("Tradada", ntTASKDATA));//VisString(_tasklocation, ntTASKDEGREE));//ntTASKLOCATION));
  //  _treechildren.add(new VisString(_taskdisaster, ntTASKDISASTER));
  //  _treechildren.add(new VisString(_taskdegree, ntTASKDEGREE));
  } */

/*  public VisTask(List agentbase, java.util.Map proposedTeam, java.util.Map batchesById)
   {
     _agentbase= agentbase;
     _taskname= Integer.toString(proposedTeam.hashCode()) + "'s proposal"; // cd.getTaskName();


     _coalitions= new LinkedList();
     _treechildren= new LinkedList();

     for (Iterator i = proposedTeam.keySet().iterator();i.hasNext();) {
       Address agent = (Address)i.next();
       Proposal proposal = (Proposal)proposedTeam.get(agent);

       for (Iterator j = proposal.getItemCoverage().iterator();j.hasNext();) {
        ItemCoverage ic = (ItemCoverage)j.next();
        _treechildren.add(new VisString(((TransportBatch)(batchesById.get(Long.toString(ic.getItemid())))).getComodityName()+" = "+ic.getCoverage() ,ntTASKDATA));
       }
     }
   } */


/* public void addLocCFPRequest(RequestList requestList, Collection participants, String name) {
   for (Iterator i = requestList.getBatch().iterator();i.hasNext();) {
       Batch b = (Batch)i.next();
      _treechildren.add(new VisString((b.getComodityName()+" = "+Long.toString(b.getCount())) ,ntTASKDATA));//VisString(_tasklocation, ntTASKDEGREE));//ntTASKLOCATION));
      _treechildren.add(new VisString("koko", this.ntAGENT));
     }
 } */

  public VisTask(List agentbase, RequestList requestList, Collection participants, String name) {
   _agentbase= agentbase;
   _taskname=name+": "+(requestList.getRequestid()); // cd.getTaskName();
   _coalitions= new LinkedList();
 // addCoalition(cd);

  _treechildren= new LinkedList();

//  _treechildren.add(new VisData("Transport", ntTASKTRANSPORTFAILURE));

  for (Iterator i = requestList.getBatch().iterator();i.hasNext();) {
    Batch b = (Batch)i.next();
   _treechildren.add(new VisString((b.getComodityName()+" = "+Long.toString(b.getCount())) ,ntTASKGOODS));//VisString(_tasklocation, ntTASKDEGREE));//ntTASKLOCATION));
  }
  VisData vd = new VisData("Potential partners", ntTASKDATA);
   for (Iterator i = participants.iterator();i.hasNext();) {
    Address a = (Address)i.next();
    vd.addChild(new VisData(a.getName(), ntTASKDATA));
   }
  _treechildren.add(vd);

}
 public void addChild(Object node) {
   _treechildren.add(node);
 }



 /* public void teamAccepted(java.util.Map proposedTeam, java.util.Map batchesById) {
    //_coalitions= new LinkedList();
  // _treechildren= new LinkedList();
  // _treechildren = new LinkedList(_treechildrenwithoutcoverage);


    for (Iterator i = proposedTeam.keySet().iterator(); i.hasNext();) {
      Address agent = (Address)i.next();
      Proposal proposal = (Proposal)proposedTeam.get(agent);

      for (Iterator j = proposal.getItemCoverage().iterator();j.hasNext();) {
        ItemCoverage ic = (ItemCoverage) j.next();
        TransportBatch tb = (TransportBatch)batchesById.get(Long.toString(ic.getItemid()));
        while(tb == null) {
         tb = (TransportBatch)batchesById.get(Long.toString(ic.getItemid()));
        };

          _treechildren.add(new VisString("participant: " + agent.getName() +
                                          " "+ic.getCoverage()*100+"% "+tb.getComodityName(),
                                          ntTASKDATA));
      }
    }
  } */


  public void addLocationProposal(Proposal proposal, String locationName, java.util.Map batchesById) {
   VisData vd = new VisData(locationName,ntAGENT);
   for (Iterator j = proposal.getItemCoverage().iterator();j.hasNext();) {
        ItemCoverage ic = (ItemCoverage) j.next();
        Batch tb = (Batch)batchesById.get(Long.toString(ic.getItemid()));
        int num = 0;
        while(tb == null) {
         System.out.println(num);
         num++;
         tb = (Batch)batchesById.get(Long.toString(ic.getItemid()));
        };

        VisData newData = new VisData(tb.getComodityName()+" "+(int)(ic.getCoverage()*100)+"%", this.ntTASK);
        newData.setProgress((int)(ic.getCoverage()*100));

        vd.addChild(newData);
//          _treechildren.add(new VisString("LocParticipant: " + locationName +
 //                                         " "+ic.getCoverage()*100+"% "+tb.getComodityName(),
  //                                        ntTASKDATA));
      }
      _treechildren.add(vd);


//    _treechildren.add(new VisString(locationName, ntTASKDATA)); */
  }
 // public void addBestProposal(String locationName) {
  //  _treechildren.add(new VisString("best proposal: "+locationName, ntTASKDISASTER));
 // }
  public void addRefusedLocation(String locationName) {
    _treechildren.add(new VisString("Location "+locationName+" refused proposal", ntTASKLOCATION));
  }
  public void   addLocationReceivedAcceptation(String locationName) {
   _treechildren.add(new VisString("Location "+locationName+" received acceptation", ntTASKDATA));
  }

 /* public void addBestTransportProposal(String transporterName, Proposal prop, java.util.Map batchesById) {
    VisString best = new VisString("Best tr.proposal: "+transporterName, ntTASKDISASTER);
   _treechildren.add(best);

   for (Iterator i = prop.getItemCoverage().iterator(); i.hasNext();) {
      ItemCoverage ic = (ItemCoverage)i.next();
      TransportBatch tb = (TransportBatch)batchesById.get(Long.toString(ic.getItemid()));
      _treechildren.add(new VisString("tr: "+transporterName+" "+tb.getComodityName()+ Double.toString(100*ic.getCoverage())+"%", ntTASKDATA));
    }

  } */


  public void addCoalition(CoalitionDescription cd)
  {
    _coalitions.add(new VisCoalition(this, cd, _agentbase));
  }

  public void removeCoalition(VisCoalition c)
  {
    _coalitions.remove(c);
  }


  public void setName(String newTaskName) {
    _taskname = newTaskName;
  }

  public String getName()
  {
    return _taskname;
  }

  public List getCoalitions()
  {
    return _coalitions;
  }

  public String toString()
  {
    return _taskname;
  }


  /**
   * For searching tasks by name
   */
  public static class Comparator
  {
    String _name;

    public Comparator(String name)
    {
      _name= name;
    }

    public boolean equals(Object other)
    {
      return (other instanceof VisTask) && (((VisTask)other).getName().equalsIgnoreCase(_name));
    }
  }

  /**
   * TreeMember methods
   */
  public Object getChild(int index)
  {
    if(index<_treechildren.size())
      return _treechildren.get(index);
    else
    {
      index-= _treechildren.size();
      if(index<_coalitions.size())
        return _coalitions.get(index);
      else
        return null;
    }
  }

  public int getChildCount()
  {
    return _treechildren.size()+_coalitions.size();
  }

  public boolean isLeaf()
  {
    return false;
  }

  public int getIndexOfChild(Object child)
  {
    int i= _treechildren.indexOf(child);
    if(i==-1)
    {
      i= _coalitions.indexOf(child);
      if(i!=-1)
        return i+_treechildren.size();
      else
        return -1;
    }
    else
      return i;
  }

  public int getNodeType()
  {
    return nodeType;
  }
  public void setNodeType(int type) {
   nodeType = type;
  }


  public List getChildren() {
    return _treechildren;
  }

}
