/**
 * Title:        Visualizer for CPlanT
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Gerstner Laboratory, FEL-�VUT, Prague
 * @author Michal Dob�ek
 * @version 1.0
 */

package across.visio.visual;

// JAVA imports
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import across.data.CoalitionDescription;

/**
 * <code>VisCoalition</code> represents a coalition in the structure trees and
 * also keeps the actual coalition information.
 */


public class VisCoalition implements TreeMember
{ private static int co = 0;
  private VisTask _owner;

  private VisAgent _leader;
  private List     _members;

  private VisCoalitionLeader _vleader;

  private List _agentbase;

  public VisCoalition(VisTask owner, CoalitionDescription cd, List agentbase)
  {
    _owner= owner;
    _agentbase = agentbase;

    int ii= agentbase.indexOf(new VisAgent.Comparator(cd.getCoalitionLeader()));
    if (ii == -1) {
      System.out.println("ERROR: Leader "+cd.getCoalitionLeader() + " is not member of agents: "+agentbase);

    }
    _leader= (VisAgent)agentbase.get(ii);
    if(_leader!=null)
    {
      _leader.joinCoalition(this);
      _leader.getAlliance().addCoalition(this);
    }
    else
      System.out.println("Coalition without a leader!!");

    _vleader= new VisCoalitionLeader(_leader);


    _members= new LinkedList();
    Iterator i= cd.getCoalitionMember().iterator();
    co++;
//    System.out.println(co+" leader: "+cd.getCoalitionLeader()+" - coal");
    while(i.hasNext())
    {
      ii= agentbase.indexOf(new VisAgent.Comparator((String)i.next()));
      VisAgent m= (VisAgent)agentbase.get(ii);
   //   System.out.println(co+" "+m.getName()+" - coal");
      if( (m!=null) && (m!=_leader))
      {// System.out.println(co+" "+m.getName()+" joined to coalition");
        m.joinCoalition(this);
        _members.add(m);
      }
    }
  }

  public void addAgentToCoalition(String name) {
    int ii= _agentbase.indexOf(new VisAgent.Comparator((String)name));
    VisAgent m= (VisAgent)_agentbase.get(ii);
    if (m != null) {
      m.joinCoalition(this);
     _members.add(m);
    }
  }

  public String[] removeAllParticipants() {
    String[] participants = new String[_members.size()+1];
    participants[0] = _leader.getName();
    int index = 1;
    for (Iterator i = _members.iterator(); i.hasNext();) {
      VisAgent va = (VisAgent)i.next();
      participants[index] = va.getName();
      va.leaveCoalition(this);
      index++;
    }
    _members = new LinkedList();
    _leader.getAlliance().removeCoalition(this);
    return participants;
  }

  public void insertParticipants(String leader, List members, List agentbase) {
    _agentbase = agentbase;
    int ii = _agentbase.indexOf(new VisAgent.Comparator(leader));
    if (ii == -1) {
      System.out.println("ERROR: Leader is not member of agents: " + _agentbase);
    }
    _leader = (VisAgent) _agentbase.get(ii);
    if (_leader != null) {
      _leader.joinCoalition(this);
      _leader.getAlliance().addCoalition(this);
    }
    else
      System.out.println("Coalition without a leader!!");

    _vleader = new VisCoalitionLeader(_leader);

    _members = new LinkedList();
    Iterator i = members.iterator();
    co++;
    while (i.hasNext()) {
      ii = _agentbase.indexOf(new VisAgent.Comparator( (String) i.next()));
      VisAgent m = (VisAgent) _agentbase.get(ii);
      if ( (m != null) && (m != _leader)) {
        m.joinCoalition(this);
        _members.add(m);
      }
    }
  }

  public void removeAgent(VisAgent a)
  {
    if(a==_leader)
      dismiss();
    else
      _members.remove(a);
  }

  public void dismiss()
  {
    Iterator i= _members.iterator();
    while(i.hasNext())
      ((VisAgent)i.next()).leaveCoalition(this);

    _leader.getAlliance().removeCoalition(this);

    _owner.removeCoalition(this);
  }

  public VisTask getTask()
  {
    return _owner;
  }

  public VisAgent getLeader()
  {
    return _leader;
  }

  public List getMembers()
  {
    return _members;
  }

  public int getMemberCount()
  {
    return _members.size();
  }

  public String toString()
  {
    return _leader.toString();
  }

  /**
   * TreeMember methods
   */
  public Object getChild(int index)
  {
    if(index==0)
      return _owner;
    if(index==1)
      return _vleader;
    else
      return _members.get(index-2);
  }

  public int getChildCount()
  {
    return 2+_members.size();
  }

  public boolean isLeaf()
  {
    return false;
  }

  public int getIndexOfChild(Object child)
  {
    if(child==_owner)
      return 0;
    if(child==_vleader)
      return 1;
    else
    {
      int i= _members.indexOf(child);
      if(i!=-1)
        return i+2;
      else
        return -1;
    }
  }

  public int getNodeType()
  {
    return ntCOALITION;
  }

  /**
   * For searching by task name
   */
  public static class TaskComparator
  {
    VisTask _task;

    public TaskComparator(VisTask task)
    {
      _task= task;
    }

    public boolean equals(Object other)
    {
      return (other instanceof VisCoalition) && (((VisCoalition)other)._owner==_task);
    }
  }
}
