/**
 * Title:        Visualizer for CPlanT
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Gerstner Laboratory, FEL-�VUT, Prague
 * @author Michal Dob�ek
 * @version 1.0
 */

package across.visio.visual;

// JAVA imports
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.geom.Line2D;
import java.util.Iterator;
import java.util.LinkedList;

import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

// MY imports

/**
 * <code>VisAlliance</code> represents an alliance in the structure trees and
 * displays the alliance window on desktop.
 */


public class VisAlliance extends JInternalFrame implements TreeMember, DISPLAYCONST
{
  private static int _alliancecount= 1;
  private static final String NOTASK = "No Task";

  private Visualizer _owner;

  private String _name = "Alliance #" + (_alliancecount++);

  private VisTask _displaytask;

  private JDesktopPane _pane;
  private java.util.List _members;
  private java.util.List _coalitions;

  private PhantomFactory _pf= new PhantomFactory();

  private JPanel jPanel1 = new JPanel();
  private JScrollPane AgentScrollPane = new JScrollPane();
  private JComboBox TaskCombo = new JComboBox();
  private CanvasPanel AgentPanel = new CanvasPanel();
  private Border border1;

  public VisAlliance(Visualizer owner, JDesktopPane pane, String name)
  {
     super("",
          true, //resizable
          false, //closable
          false, //maximizable
          true);//iconifiable

    if (name != null) _name = name;

    setTitle(_name);
    this.setFrameIcon(new ImageIcon(MyTreeCellRenderer.class.getResource("images/alliance.gif")));

    _displaytask= null;
    _owner= owner;
    _pane= pane;
    _members= new LinkedList();
    _coalitions= new LinkedList();

    AgentPanel= new CanvasPanel();
    try
    {
      jbInit();
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }

    _pane.add(this);
    pack();
    setLocation(_alliancecount*23, _alliancecount*23);
    setVisible(true);
  }

  public boolean isMember(String agent)
  {
    return _members.contains(new VisAgent.Comparator(agent));
  }

  public void addMember(VisAgent a)
  {
    if(!isMember(a.getName()))
    {
      _members.add(a);
      a.joinAlliance(this);
      AgentPanel.add(a);
    }
    arrange();
  }

  public void addMembers(java.util.List newcommers)
  {
    Iterator i= newcommers.iterator();
    while(i.hasNext())
    {
      VisAgent a= (VisAgent)i.next();
      if(!isMember(a.getName()))
      {
        _members.add(a);
        a.joinAlliance(this);
        AgentPanel.add(a);
      }
    }
    arrange();
  }

  public void removeMember(VisAgent a)
  {
    if(_members.contains(a))
    {
      _members.remove(a);
      AgentPanel.remove(a);
      if(_members.size()==0)  // Empty alliance
      {
        _owner.deleteAlliance(this);
        setVisible(false);
        _pane.remove(this);
        dispose();
      }
      else
        arrange();
    }
  }

  public void addCoalition(VisCoalition c)
  {
    if(!_coalitions.contains(c))
    {
      if(!_coalitions.contains(new VisCoalition.TaskComparator(c.getTask())))
        TaskCombo.addItem(c.getTask());
       _coalitions.add(c);

      if(c.getTask()==_displaytask)
        arrange();
    }
  }

  public void removeCoalition(VisCoalition c)
  {
    _coalitions.remove(c);
    if(!_coalitions.contains(new VisCoalition.TaskComparator(c.getTask())))
        TaskCombo.removeItem(c.getTask());

    if(c.getTask()==_displaytask)
      arrange();
  }

  public void dismiss()
  {
    _pane.remove(this);
    _members.clear();
    _coalitions.clear();
  }

  public void setDisplayTask(VisTask task)
  {
    if(!_coalitions.contains(new VisCoalition.TaskComparator(task)))
      task= null;

    _displaytask= task;
    if(task!=null)
      TaskCombo.setSelectedItem(task);
    else
      TaskCombo.setSelectedItem(NOTASK);
    arrange();
  }

  /**
   * Arrange the member agents according to the current Task displayed.
   */
  public void arrange()
  {
    java.util.List memberstoshow= new LinkedList(_members);
    java.util.List coalstoshow= new LinkedList();
    int maxmembers= 1;
//  System.out.println("--- memberstoshow: "+ memberstoshow);
//  System.out.println("--- coalstoshow: "+ coalstoshow);
    AgentPanel.removeShapes();
    _pf.start();

    if(_displaytask!=null)
    {
      java.util.List tc= _displaytask.getCoalitions();
// System.out.println("--- taskCoalition: "+ tc);
      Iterator tci= tc.iterator();
      while(tci.hasNext())
      {
        VisCoalition c= (VisCoalition)tci.next();
        if(_coalitions.contains(c))
        {
          coalstoshow.add(c);
          if(c.getMemberCount()>maxmembers)
            maxmembers= c.getMemberCount();
        }
      }
    }

    int row= 0;

    Iterator ci= coalstoshow.iterator();
    while(ci.hasNext())
    {
      VisCoalition c= (VisCoalition)ci.next();
      VisAgentInterface leader= c.getLeader();

//  System.out.println("--- Leader: "+ leader);

      if(!memberstoshow.contains(leader)) // it was already shown -> use Phantom
        leader= _pf.getPhantom(leader);

      int membercount= c.getMemberCount();

      //System.out.println(membercount); // petr

      if(membercount>0)
        leader.setLocation( ((c.getMemberCount()*COLWIDTH-HGAP)>>1)-AGENTCENTER+HGAP, row*ROWHEIGHT+VGAP);
      else
        leader.setLocation( HGAP, row*ROWHEIGHT+VGAP);

      leader.setRole(ColorFactory.LEADER);

      Point linestart= leader.getLocation();
      linestart.translate(AGENTCENTER, AGENTHEIGHT);

      memberstoshow.remove(leader);
      row++;

      if(membercount>0)
      {
        int col= 0;
        Iterator mi= c.getMembers().iterator();
        while(mi.hasNext())
        {
          VisAgentInterface a= (VisAgent)mi.next();
          if(!memberstoshow.contains(a))  // a was alredy drawn, use Phantom
            a= _pf.getPhantom(a);

          Point pos= new Point(col*COLWIDTH+HGAP, row*ROWHEIGHT+VGAP);
          a.setLocation(pos);
          a.setRole(ColorFactory.MEMBER);
          pos.translate(AGENTCENTER, 0);
          AgentPanel.addShape(new Line2D.Double(linestart, pos));
          memberstoshow.remove(a);
          col++;
        }
        row++;
      }
    }

    int rowcap= (AgentScrollPane.getViewport().getWidth()-HGAP)/COLWIDTH;
    int maxnext= (maxmembers>rowcap) ? maxmembers : rowcap;

    boolean rowoverflow= false;
    Iterator resti= memberstoshow.iterator();
    int col= 0;
    boolean emptyrow= true;
    while(resti.hasNext())
    {
      emptyrow= false;
      VisAgent a= (VisAgent)resti.next();
      a.setLocation( col*COLWIDTH+HGAP, row*ROWHEIGHT+VGAP);
      a.setRole(ColorFactory.OTHER);
      col++;
      if(col>=maxnext)
      {
        emptyrow= true;
        row++;
        col= 0;
        rowoverflow= true;
      }
    }

    _pf.end();

    if(!emptyrow)
      row++;


    int w;
    if(rowoverflow)
      w= maxnext;
    else
      w= (col>maxmembers) ? col : maxmembers;

    AgentPanel.setPreferredSize(new Dimension(w*COLWIDTH+HGAP, row*ROWHEIGHT+VGAP));
    AgentPanel.revalidate();
    AgentPanel.repaint();
  }


  private class CanvasPanel extends JPanel
  {
    private java.util.List _shapes;

    public CanvasPanel()
    {
      setPreferredSize(new Dimension( MINAGENTSPERROW*COLWIDTH+HGAP, 2*ROWHEIGHT+VGAP));
      _shapes= new LinkedList();
    }

    public synchronized void removeShapes()
    {
      _shapes.clear();
    }

    public synchronized void addShape(Shape s)
    {
      _shapes.add(s);
    }

    public synchronized void paintComponent(Graphics g)
    {
      super.paintComponent(g);
      Graphics2D g2d= (Graphics2D)g;

      Color oldc= g2d.getColor();
      g2d.setColor(Color.black);
      Iterator i= _shapes.iterator();
      while(i.hasNext())
      {
        g2d.draw((Shape)i.next()); // concurent modification exception // petr
      }
      g2d.setColor(oldc);
//      Graphics2D g2= (Graphics2D)g;
//
//      Rectangle drawArea = g2.getClipBounds();
//
//      // Fill clipping area with white.
//      g2.setColor(new Color(255, 255, 255));
//      g2.fillRect(drawArea.x, drawArea.y, drawArea.width, drawArea.height);
//
//      FontMetrics metrics = g2.getFontMetrics();
//      g2.setColor(new Color(0,0,0));
//      g2.setFont(getFont().deriveFont(Font.BOLD));
//
//      Iterator i= _members.iterator();
//      int r= 1;
//      while(i.hasNext())
//        g2.drawString( ((VisAgent)i.next()).getName(), 5, 20*(r++) );
    }
  }

  public String toString()
  {
    return _name;
  }

  /**
   * TreeMember methods
   */
  public Object getChild(int index)
  {
    return _members.get(index);
  }

  public int getChildCount()
  {
    return _members.size();
  }

  public boolean isLeaf()
  {
    return false;
  }

  public int getIndexOfChild(Object child)
  {
    return _members.indexOf(child);
  }

  public int getNodeType()
  {
    return ntALLIANCE;
  }

  /**
   * JBuilder-generated methods for GUI
   */
  public VisAlliance()
  {
    try
    {
      jbInit();
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception
  {
    border1 = ShadowBorder.createStandardShadow();
    AgentPanel.setLayout(null);
    TaskCombo.addItem(NOTASK);
    TaskCombo.addActionListener(new java.awt.event.ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        TaskCombo_actionPerformed(e);
      }
    });
    this.getContentPane().add(jPanel1, BorderLayout.NORTH);
    jPanel1.add(TaskCombo, null);
    this.getContentPane().add(AgentScrollPane, BorderLayout.CENTER);
    AgentScrollPane.getViewport().add(AgentPanel, null);
  }

  void TaskCombo_actionPerformed(ActionEvent e)
  {
    JComboBox cb= (JComboBox)e.getSource();
    Object item= cb.getSelectedItem();
    if(item instanceof String)
      setDisplayTask(null);
    else
      setDisplayTask((VisTask)item);
  }

  public boolean isRequestFocusEnabled()
  {
    return true;
  }

  private class PhantomFactory
  {
    java.util.List _phantoms;
    int            _index;

    public PhantomFactory()
    {
      _index= 0;
      _phantoms= new LinkedList();
    }

    public void start()
    {
      Iterator i= _phantoms.iterator();
      while(i.hasNext())
        ((PhantomAgent)i.next()).clearOwner();
      _index= 0;
    }

    public PhantomAgent getPhantom(VisAgentInterface a)
    {
      PhantomAgent p;

      if(_index<_phantoms.size())
        p= (PhantomAgent)_phantoms.get(_index);
      else
      {
        p= new PhantomAgent((VisAgent)a);
        _phantoms.add(p);
        AgentPanel.add(p);
      }
      _index++;

      p.setOwner((VisAgent)a);
      return p;
    }

    public void end()
    {
      while(_index<_phantoms.size())
      {
        PhantomAgent p= (PhantomAgent)_phantoms.get(_index);
        AgentPanel.remove(p);
        _phantoms.remove(_index);
      }
    }
  }
}
