/**
 * Title:        Visualizer for CPlanT
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Gerstner Laboratory, FEL-�VUT, Prague
 * @author Michal Dob�ek
 * @version 1.0
 */


package across.visio.visual;

// JAVA imports
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.swing.JLabel;
import javax.swing.SwingConstants;

import across.visio.VisualAgent;
import across.visio.ont.CPlantAgentDescription;
import across.visio.ont.DFAgentDescription;

/**
 * <p><code>VisAgent</code> is representing a model of an agent. It provides
     * interace to be part of of structure tree and to be shown in a alliance window.
 * To display multiple copies of one agent the auxiliary <code>PhantomAgent</code>
 * class is used.
 *
 * @see PhantomAgent
 *
 */


public class VisAgent
    extends JLabel
    implements VisAgentInterface, TreeMember, DISPLAYCONST {
  private static VisString NoAl = new VisString("None", ntALLIANCE);

  private String _name;
  private String _type;
  private String _country;
  private String _city;

  private VisAlliance _alliance;
  private List _coalitions;

  private List _treechildren;
  private Object _role;

  private String _titlename;
  private boolean _infoon = false;

  private List _phantoms = new LinkedList();

  Visualizer owner;

  DFAgentDescription dfAD;
  CPlantAgentDescription cpAD;

  private boolean visibility = true;

  private Object waglobeObjInform = new Object();

  /**
   * recieved object agents models
   * key - String - meta agent
   * value - String [] - model
   */

  private Map modelsOG = new HashMap();
  private Map modelsOS = new HashMap();
  private Map modelsMT = new HashMap();
  private Map modelsMF = new HashMap();

  /**
   * List of VisAgent objects
   */
  private List otherAgents = new LinkedList();

 // petr public MRDialog actMRDialog;

 /* petr class StDialog  extends Thread {
    StatusDialog stDialog;
    VisAgent visOwner;

    public StDialog(VisAgent visOwner) {

      this.visOwner = visOwner;
      stDialog = new StatusDialog("Getting information ...");
    }

    public void run() {

/*
      stDialog.setProgress("Looking for Meta-Agents");

      String objectAgentName = new AgentName(_name).getName();

      LinkedList agentsModelO = new LinkedList();
      LinkedList agentsModelM = new LinkedList();

      for (Iterator itOA = otherAgents.iterator(); itOA.hasNext(); ) {
        VisAgent actVA = (VisAgent) itOA.next();
        DFAgentDescription actDF = actVA.dfAD;
        // looking for 'META-MODEL-O' / 'META-MODEL-M' services
        boolean containsModelO = false;
        boolean containsModelM = false;

        for (Iterator itServ = actDF.getServices().iterator(); itServ.hasNext(); ) {
          String actServ = (String) itServ.next();
          if (actServ.equalsIgnoreCase(CONSTANTS.META_MODEL_O)) {
            containsModelO = true;
          }

          else if (actServ.equalsIgnoreCase(CONSTANTS.META_MODEL_M)) {
            containsModelM = true;
          }
        }

        if (containsModelO) {
          agentsModelO.add(actDF.getName());
        }

        if (containsModelM) {
          agentsModelM.add(actDF.getName());
        }
      }

      if (agentsModelO.isEmpty() && agentsModelM.isEmpty()) {
        MessageBox mbox = Message.newInstanceBox(
            "Error!  No meta-agent, no reasoning...",
            "No meta-agent has been found.");
        mbox.show();
        return;
      }

      stDialog.setProgress("Contacting Meta-Agents");

      for (Iterator it = agentsModelO.iterator(); it.hasNext(); ) {
        msgQueryModel(objectAgentName, (String) (it.next()));
      }

      for (Iterator it = agentsModelM.iterator(); it.hasNext(); ) {
        msgQueryModel(objectAgentName, (String) (it.next()));
      }

      actMRDialog = new MRDialog(new AgentName(_name).getName(), otherAgents, visOwner);
      boolean doneO = false;
      boolean doneM = false;

      while (! (doneO && doneM)) {
        synchronized (waglobeObjInform) {
          try {
            waglobeObjInform.waglobe(500);
          }
          catch (InterruptedException ex) {
          }
        }

        doneO = true;
        for (Iterator it = agentsModelO.iterator(); it.hasNext(); ) {
          String actAgent = (String) it.next();

          if (!modelsOG.containsKey(actAgent) || !modelsOS.containsKey(actAgent))
            doneO = false;
        }

        doneM = true;
        for (Iterator it = agentsModelM.iterator(); it.hasNext(); ) {
          String actAgent = (String) it.next();
          if (!modelsMT.containsKey(actAgent) || !modelsMF.containsKey(actAgent))
            doneM = false;
        }

        stDialog.refreshProgress();
        // @todo Test na Cancel (Skip) *
        if (stDialog.canceled) break;
      }

      stDialog.dispose();
      for (Iterator it = agentsModelO.iterator(); it.hasNext(); ) {
        String actAgent = (String) it.next();
        String actAgentName = new AgentName(actAgent).getName();
        if (modelsOG.containsKey(actAgent) && modelsOS.containsKey(actAgent))
          actMRDialog.addModelO(actAgentName,
                             (String[]) modelsOG.get(actAgent)
                             , (String[]) modelsOS.get(actAgent));
      }

      for (Iterator it = agentsModelM.iterator(); it.hasNext(); ) {
        String actAgent = (String) it.next();
        String actAgentName = new AgentName(actAgent).getName();

        if (modelsMT.containsKey(actAgent) && modelsMF.containsKey(actAgent))
          actMRDialog.addModelM(new AgentName(actAgent).getName(),
                             (String[]) modelsMT.get(actAgent)
                             , (String[]) modelsMF.get(actAgent));
      }

      actMRDialog.show();
      actMRDialog.dispose();
      actMRDialog = null;
*/
/* petr    }

    public void dispose() {
      stDialog.dispose();
    }

    public void show() {
      stDialog.show();
    }
  } */

  public VisAgent(DFAgentDescription dfad, CPlantAgentDescription cpad,
                  List otherAgents, Visualizer owner) {
    super();
    this.owner = owner;
    this.otherAgents = otherAgents;

    dfAD = dfad;
    cpAD = cpad;
    _name = dfad.getName();
    _type = dfad.getType();
    _country = cpad.getCountry();
    _city = cpad.getCity();

    _alliance = null;
    _coalitions = new LinkedList();

    _treechildren = new LinkedList();
    _treechildren.add(new VisString(_type, ntAGENTTYPE));
    if (_country != null) {
      _treechildren.add(new VisString(_country, ntAGENTCOUNTRY));
    }

    if (_city != null) {
      _treechildren.add(new VisString(_city, ntAGENTCITY));
    }

    _role = ColorFactory.OTHER;
    refreshColor();

//    _titlename = _name.substring(0, _name.indexOf('@'));
    _titlename = _name;
    String _shortname = (String) VisualAgent.getConfig().getNames().get(
        _titlename);

    if (_shortname != null) {
      _titlename = _shortname;
    }

    setSize(AGENTWIDTH, AGENTHEIGHT);
    setPreferredSize(new Dimension(AGENTWIDTH, AGENTHEIGHT));
    setBorder(ShadowBorder.createStandardShadow());
//    setBackground(AGENTCOLOR);
    setForeground(AGENTTXTCOLOR);
    setOpaque(true);
    setHorizontalAlignment(SwingConstants.CENTER);
//    setHorizontalTextPosition(SwingConstants.CENTER);
//    setVerticalAlignment(SwingConstants.CENTER);
//    setVerticalTextPosition(SwingConstants.CENTER);



    if (_titlename.endsWith("Transporter")) {
      String name = _titlename.substring(0,_titlename.length()-11);
      setText(NAMEPREFIX + name +"<BR>"+ "Transporter" + NAMESUFFIX);
    } else  {
      setText(NAMEPREFIX + _titlename + NAMESUFFIX);
    }





   this.addMouseListener(new java.awt.event.MouseAdapter() {
      public void mousePressed(MouseEvent e) {
        this_mousePressed(e);
      }


      public void mouseReleased(MouseEvent e) {
        this_mouseReleased(e);
      }

      public void mouseExited(MouseEvent e) {
        this_mouseExited(e);
      }
    });
  }


  public void deregister() {
    Iterator i = _coalitions.iterator();
    while (i.hasNext()) {
      ( (VisCoalition) i.next()).removeAgent(this);
    }

    if (_alliance != null) {
      _alliance.removeMember(this);
    }
  }

  public void joinAlliance(VisAlliance a) {
    if (_alliance != null) {
      _alliance.removeMember(this);
    }
    _alliance = a;
    _alliance.addMember(this);
  }

  public void joinCoalition(VisCoalition c) {
    _coalitions.add(c);
  }


  public void leaveCoalition(VisCoalition c) {
    _coalitions.remove(c);
  }


  public void refreshColor() {
    Color backGC = ColorFactory.getDefaultFactory().getColor(this);
    if (!getVisibility()) {
      backGC = backGC.darker();
    }
    setBackground(backGC);
    Iterator i = _phantoms.iterator();
    while (i.hasNext()) {
      ( (PhantomAgent) i.next()).refreshColor();
    }
  }

  public String getType() {
    return _type;
  }


  public String getName() {
    return _name;
  }

  public String getCountry() {
    return _country;
  }

  public String getCity() {
    return _city;
  }


  public VisAlliance getAlliance() {
    return _alliance;
  }

  public Object getRole() {
    return _role;
  }

  public void setRole(Object role) {
    _role = role;
    refreshColor();
  }

  public List getCoalitions() {
    return _coalitions;
  }

  public String toString() {
    return _titlename;
  }

  public void addPhantom(PhantomAgent a) {
    _phantoms.add(a);
  }

  public void removePhantom(PhantomAgent a) {
    _phantoms.remove(a);
  }

  /**
   * For searching agents by name
   */

  public static class Comparator {
    String _name;

    public Comparator(String name) {
      _name = name;
    }

    public boolean equals(Object other) {
      return (other instanceof VisAgent) &&
          ( ( (VisAgent) other).getName().equalsIgnoreCase(_name));
    }
  }

  /**
   * TreeMember methods
   */

  public Object getChild(int index) {
    if (index < _treechildren.size()) {
      return _treechildren.get(index);
    }
    else {
      index -= _treechildren.size();
      if (index == 0) {
        return _alliance == null ? (Object) NoAl : (Object) _alliance;
          }
          else {
        return _coalitions.get(index - 1);
      }
    }
  }

  public int getChildCount() {
    return 1 + _treechildren.size() + _coalitions.size();
  }

  public boolean isLeaf() {
    return false;
  }

  public int getIndexOfChild(Object child) {
    int i = _treechildren.indexOf(child);
    if (i == -1) {
      if (child == _alliance) {
        return _treechildren.size();
      }
      else {
        i = _coalitions.indexOf(child);
        if (i != -1) {
          return i + _treechildren.size() + 1;
        }
        else {
          return -1;
        }
      }
    }
    else {
      return i;
    }
  }

  public int getNodeType() {
    return ntAGENT;
  }

  void this_mousePressed(MouseEvent e) {
    if (e.getButton() == e.BUTTON1) {
      _infoon = true;
      AgentInfoPanel.DefaultAgentInfo.activate(e);
    }
    else if (e.getButton() == e.BUTTON2) {
    }
  }

  void this_mouseReleased(MouseEvent e) {
    if (e.getButton() == e.BUTTON1) {
      if (_infoon) {
        _infoon = false;
        AgentInfoPanel.DefaultAgentInfo.deactivate(e);
      }
    }
    else if (e.getButton() == e.BUTTON3) {
    //petr  StDialog stDialog = new StDialog(this);
      // stDialog.start(); petr
     //petr stDialog.show();
    }
  }

  /**
   *
   * @param m
   * @return List of String[]
   */
   void this_mouseExited(MouseEvent e) {
     if (_infoon) {
       _infoon = false;
       AgentInfoPanel.DefaultAgentInfo.deactivate(e);
     }
   }

  public void setVisibility(boolean visible) {
    visibility = visible;
    refreshColor();
  }

  public boolean getVisibility() {
    return visibility;
  }
}



