package across.visio.visual;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;

import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

// MY imports

/**
 * <code>ToolWindow</code> is the base class for all palette-like floafing
 * windows (<code>IconWindow</code> and <code>LegendWindow</code>). It implements
 * the simple frame, title and close button. The <code>setSnapTo</code> method
 * provides a simple way to snap the window to another component. The method must
 * be called before the window is displayed for the first time.</p>
 *
 * @see IconWindow
 * @see LegendWindow
 */

public class ToolWindow extends JComponent
{
  public static final int snapIN=  0;
  public static final int snapOUT= 1;

  private boolean _hasposition= false;
  private JComponent _snapto= null;
  private int _snappos;

  private boolean isDragging = false;
  private Point   dragOfs;

  private Action _showaction;

  private BorderLayout borderLayout1 = new BorderLayout();
  private JScrollPane jScrollPane1 = new JScrollPane();
  protected JPanel ContentPanel = new JPanel();
  private GridBagLayout gridBagLayout1 = new GridBagLayout();
  private JPanel jPanel2 = new JPanel();
  private BorderLayout borderLayout2 = new BorderLayout();
  private JButton HideButton = new javax.swing.plaf.basic.BasicArrowButton(5);

  private JLabel jLabel1 = new JLabel();
  private Border border1;


  public ToolWindow()
  {
    try
    {
      jbInit();
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
  }

  public void setShowAction(Action a)
  {
    _showaction= a;
  }

  public void setSnapTo(JComponent to, int pos)
  {
    _snapto= to;
    _snappos= pos;
  }

  public void setVisible(boolean vis)
  {
    if(!_hasposition && vis)
    {
      if(_snapto!=null)
      {
        Point sploc= _snapto.getLocationOnScreen();
        Point ploc= getParent().getLocationOnScreen();

        if(_snappos==snapIN)
          setLocation(sploc.x-ploc.x+_snapto.getWidth()-getWidth(), sploc.y-ploc.y);
        else
          setLocation(sploc.x-ploc.x+_snapto.getWidth(), sploc.y-ploc.y);
      }
      else
      {
        Container p= getParent();
        setLocation(p.getX()+p.getWidth()-getWidth(), p.getY());
      }
      _hasposition= true;
    }
    super.setVisible(vis);
  }

  public void setTitle(String l)
  {
    jLabel1.setText(l);
  }

  private void jbInit() throws Exception
  {
//    contentPane = this;
    border1 = BorderFactory.createEmptyBorder(0,5,0,5);
    this.setLayout(borderLayout1);
    ContentPanel.setLayout(gridBagLayout1);
//    Color1.setBackground(Color.orange);
//    Color1.setMaximumSize(new Dimension(15, 15));
//    Color1.setMinimumSize(new Dimension(15, 15));
//    Color1.setOpaque(true);
//    Color1.setPreferredSize(new Dimension(15, 15));
//    Color1.setHorizontalAlignment(SwingConstants.CENTER);
//    Color1.setHorizontalTextPosition(SwingConstants.CENTER);
//    Text1.setText("jLabel2");
//    Color2.setBackground(Color.pink);
//    Color2.setMaximumSize(new Dimension(15, 15));
//    Color2.setMinimumSize(new Dimension(15, 15));
//    Color2.setOpaque(true);
//    Color2.setPreferredSize(new Dimension(15, 15));
//    Color2.setHorizontalAlignment(SwingConstants.CENTER);
//    Color2.setHorizontalTextPosition(SwingConstants.CENTER);
//    Text2.setText("jLabel4");
//    FillLabel.setText("jLabel5");
    this.setBorder(BorderFactory.createLineBorder(Color.black));
//    this.setMaximumSize(new Dimension(200, 150));
//    this.setMinimumSize(new Dimension(80, 30));
    this.setSize(new Dimension(160,170));
    this.addMouseMotionListener(new java.awt.event.MouseMotionAdapter()
    {
      public void mouseDragged(MouseEvent e)
      {
        this_mouseDragged(e);
      }
    });
    this.addMouseListener(new java.awt.event.MouseAdapter()
    {
      public void mousePressed(MouseEvent e)
      {
        this_mousePressed(e);
      }
      public void mouseReleased(MouseEvent e)
      {
        this_mouseReleased(e);
      }
    });
    jScrollPane1.getViewport().setBackground(Color.white);
    jScrollPane1.setBorder(null);
    ContentPanel.setOpaque(false);
//    jPanel1.addMouseMotionListener(new java.awt.event.MouseMotionAdapter()
//    {
//      public void mouseDragged(MouseEvent e)
//      {
//        this_mouseDragged(e);
//      }
//    });
//    jPanel1.addMouseListener(new java.awt.event.MouseAdapter()
//    {
//      public void mousePressed(MouseEvent e)
//      {
//        this_mousePressed(e);
//      }
//      public void mouseReleased(MouseEvent e)
//      {
//        this_mouseReleased(e);
//      }
//    });
    jPanel2.setLayout(borderLayout2);
//    HideButton.setText("x");
//    HideButton.setMinimumSize(new Dimension(11, 11));
//    HideButton.setMargin(new Insets(0,0,0,0));
//    HideButton.setPreferredSize(new Dimension(HideButton.getHeight(),HideButton.getHeight()));
    HideButton.addActionListener(new java.awt.event.ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        HideButton_actionPerformed(e);
      }
    });
    jLabel1.setBorder(border1);
    this.add(jScrollPane1, BorderLayout.CENTER);
    this.add(jPanel2, BorderLayout.NORTH);
    jPanel2.add(HideButton,  BorderLayout.EAST);
    jPanel2.add(jLabel1, BorderLayout.CENTER);
    jScrollPane1.getViewport().add(ContentPanel, null);
//    jPanel1.add(Color1,     new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
//            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
//    jPanel1.add(Text1,         new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0
//            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
//    jPanel1.add(Color2,     new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
//            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
//    jPanel1.add(Text2,        new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0
//            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
//    jPanel1.add(FillLabel,   new GridBagConstraints(1, 2, 1, 1, 0.0, 0.5
//            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
  }

  void HideButton_actionPerformed(ActionEvent e)
  {
    if(_showaction!=null)
      _showaction.actionPerformed(null);
  }

  void this_mousePressed(MouseEvent e)
  {
    isDragging= true;
    dragOfs= e.getPoint();

    Object p= getParent();
    if(p instanceof JLayeredPane)
      ((JLayeredPane)p).moveToFront(this);
  }

  void this_mouseReleased(MouseEvent e)
  {
    isDragging= false;
  }

  void this_mouseDragged(MouseEvent e)
  {
    if(isDragging)
    {
      Point akt= e.getPoint();
      Point loc= getLocation();
      setLocation(loc.x+akt.x-dragOfs.x, loc.y+akt.y-dragOfs.y);
    }
  }
}
