package across.visio.visual;



import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.InputMethodEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.WindowConstants;
import javax.swing.event.AncestorEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

import across.visio.ont.DFAgentDescription;

//import aglobe.agent.visio.parser.*;



/**

 * <p>Title: </p>

 * <p>Description: </p>

 * <p>Copyright: Copyright (c) 2003</p>

 * <p>Company: </p>

 * @author not attributable

 * @version 1.0

 */



public class QueryDialog

    extends JDialog {

  JLabel jLabel4 = new JLabel();

  JComboBox leaderBox = new JComboBox();

  JLabel jLabel5 = new JLabel();

  JComboBox cityBox = new JComboBox();

  JLabel jLabel6 = new JLabel();

  BorderLayout borderLayout1 = new BorderLayout();



  private Object waglobeObjInform = new Object();



  private ArrayList repliesA = new ArrayList();

  private ArrayList repliesR = new ArrayList();

  JPanel QueryPanel = new JPanel();

  JScrollPane repliesPanel = new JScrollPane();

  GridBagLayout gridBagLayout1 = new GridBagLayout();

  JLabel sizeValue = new JLabel();

  JSlider sizeSlider = new JSlider();

  JButton evaluateButton = new JButton();





    private Collection otherAgents;

    private String agentName;

    private VisAgent owner;

  JTable replies = new JTable();



  public QueryDialog(String agentName, Collection otherAgents, VisAgent owner) {

    super( (Frame)null, "Query to " + agentName, true);

    this.owner = owner;

    this.agentName = agentName;

    this.otherAgents = otherAgents;

    try {

      jbInit();

      pack();

    }

    catch (Exception ex) {

      ex.printStackTrace();

    }

  }



  void addReply(String agentName, String reply) {



    JLabel agentL = new JLabel();

    JLabel replyL = new JLabel();



    repliesA.add(agentName);

    repliesR.add(reply);

    actualizeReplies();

  }



  final static String[] columnNames = {"Meta Agent Name", "Reply"};



  void actualizeReplies() {

    TableModel newModel = new AbstractTableModel() {

      public String getColumnName(int col) {return columnNames[col].toString();}

      public int getRowCount() {return repliesR.size();}

      public int getColumnCount() {return columnNames.length;}

      public Object getValueAt(int row, int col) {return (col==0)?repliesA.get(row):repliesR.get(row);}

      public boolean isCellEditable(int row, int col) {return false;}

    };



    replies.setModel(newModel);

  }







  private void jbInit() throws Exception {

    this.getContentPane().setLayout(borderLayout1);

    jLabel4.setText("Leader");

    jLabel4.setHorizontalAlignment(SwingConstants.TRAILING);

    jLabel4.setForeground(Color.black);

    jLabel4.setRequestFocusEnabled(true);

    jLabel5.setForeground(Color.black);

    jLabel5.setHorizontalAlignment(SwingConstants.TRAILING);

    jLabel5.setText("City");

    jLabel6.setHorizontalAlignment(SwingConstants.RIGHT);

    jLabel6.setText("Coalition size");

    leaderBox.addActionListener(new QueryDialog_leaderBox_actionAdapter(this));

    this.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);

    this.setModal(true);

    this.setResizable(true);

    this.setTitle("Query");

    QueryPanel.setLayout(gridBagLayout1);

    QueryPanel.setMaximumSize(new Dimension(2147483647, 112));

    QueryPanel.setPreferredSize(new Dimension(450, 112));

    sizeValue.setEnabled(true);

    sizeValue.setFont(new java.awt.Font("Dialog", 1, 12));

    sizeValue.setDebugGraphicsOptions(0);

    sizeValue.setMaximumSize(new Dimension(15, 16));

    sizeValue.setMinimumSize(new Dimension(15, 16));

    sizeValue.setPreferredSize(new Dimension(15, 16));

    sizeValue.setRequestFocusEnabled(true);

    sizeValue.setText("5");

    sizeSlider.setOrientation(JSlider.HORIZONTAL);

    sizeSlider.setMajorTickSpacing(5);

    sizeSlider.setMaximum(10);

    sizeSlider.setMinimum(0);

    sizeSlider.setMinorTickSpacing(1);

    sizeSlider.setPaintLabels(true);

    sizeSlider.setMaximumSize(new Dimension(32767, 39));

    sizeSlider.setMinimumSize(new Dimension(36, 39));

    sizeSlider.setOpaque(true);

    sizeSlider.setPreferredSize(new Dimension(50, 39));

    sizeSlider.setValue(5);

    sizeSlider.addChangeListener(new QueryDialog_sizeSlider_changeAdapter(this));

    evaluateButton.setText("Evaluate");

    evaluateButton.addAncestorListener(new QueryDialog_evaluateButton_ancestorAdapter(this));

    evaluateButton.addActionListener(new QueryDialog_evaluateButton_actionAdapter(this));

    repliesPanel.setMaximumSize(new Dimension(32767, 250));

    repliesPanel.setMinimumSize(new Dimension(100, 24));

    repliesPanel.setPreferredSize(new Dimension(100, 0));

    replies.setMaximumSize(new Dimension(0, 200));

    replies.setIntercellSpacing(new Dimension(1, 1));

    QueryPanel.add(leaderBox,                       new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0

            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(8, 10, 0, 10), 354, 0));

    QueryPanel.add(jLabel4,                     new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0

            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(8, 2, 0, 0), 66, 6));

    QueryPanel.add(jLabel5,                     new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0

            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(11, 2, 0, 0), 82, 6));

    QueryPanel.add(jLabel6,                     new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0

            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 2, 19, 0), 37, 6));

    QueryPanel.add(cityBox,                       new GridBagConstraints(1, 1, 3, 1, 1.0, 0.0

            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(11, 10, 0, 10), 354, 0));

    QueryPanel.add(sizeValue,        new GridBagConstraints(1, 2, 1, 2, 0.0, 0.0

            ,GridBagConstraints.NORTH, GridBagConstraints.NONE, new Insets(3, 10, 0, 0), 0, 0));

    QueryPanel.add(evaluateButton,          new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0

            ,GridBagConstraints.SOUTHEAST, GridBagConstraints.NONE, new Insets(0, 0, 0, 10), 0, 0));

    QueryPanel.add(sizeSlider,         new GridBagConstraints(2, 2, 1, 1, 100.0, 0.0

            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 20), 100, 0));

    this.getContentPane().add(repliesPanel,  BorderLayout.CENTER);

    repliesPanel.getViewport().add(replies, null);

    this.getContentPane().add(QueryPanel, BorderLayout.NORTH);



    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();

    pack();

    this.setLocation( (d.width - this.getWidth()) / 2,

                     (d.height - this.getHeight()) / 2);

  }



  void leaderBox_actionPerformed(ActionEvent e) {



  }



  void sizeSlider_caretPositionChanged(InputMethodEvent e) {

    sizeValue.setText(String.valueOf(sizeSlider.getValue()));

  }



  void sizeSlider_stateChanged(ChangeEvent e) {

    sizeValue.setText(String.valueOf(sizeSlider.getValue()));

  }



  void evaluateButton_actionPerformed(ActionEvent e) {

    repliesA.clear();

    repliesR.clear();

    repliesPanel.setPreferredSize(new Dimension(0, 200));

    pack();



    String leader = ((VisAgent) leaderBox.getSelectedItem()).getName();

    String city = (String) cityBox.getSelectedItem();

    int size = sizeSlider.getValue();



    Query query = new Query(owner, leader, city, String.valueOf(size));



    query.start();

  }



  class QueryDialog_leaderBox_actionAdapter

      implements java.awt.event.ActionListener {

    QueryDialog adaptee;



    QueryDialog_leaderBox_actionAdapter(QueryDialog adaptee) {

      this.adaptee = adaptee;

    }



    public void actionPerformed(ActionEvent e) {

      adaptee.leaderBox_actionPerformed(e);

    }

  }



  class QueryDialog_sizeSlider_changeAdapter

      implements javax.swing.event.ChangeListener {

    QueryDialog adaptee;



    QueryDialog_sizeSlider_changeAdapter(QueryDialog adaptee) {

      this.adaptee = adaptee;

    }



    public void stateChanged(ChangeEvent e) {

      adaptee.sizeSlider_stateChanged(e);

    }

  }



  class QueryDialog_evaluateButton_actionAdapter

      implements java.awt.event.ActionListener {

    QueryDialog adaptee;



    QueryDialog_evaluateButton_actionAdapter(QueryDialog adaptee) {

      this.adaptee = adaptee;

    }



    public void actionPerformed(ActionEvent e) {

      adaptee.evaluateButton_actionPerformed(e);

    }

  }



  class Query

      extends Thread {

//    StatusDialog stDialog;



    private String leader;

    private String city;

    private String size;



    public Query(VisAgent owner, String leader, String city, String size) {

      this.leader = leader;

      this.city = city;

      this.size = size;

//      stDialog = new StatusDialog("Getting information ...");

    }



    public void run() {

//      stDialog.setProgress("Looking for Meta-Agents");

//      stDialog.show();



      LinkedList metaAgents = new LinkedList();



      for (Iterator itOA = otherAgents.iterator(); itOA.hasNext(); ) {

        VisAgent actVA = (VisAgent) itOA.next();

        DFAgentDescription actDF = actVA.dfAD;

        // looking for 'META-PREDICTION'  services

        boolean containsPrediction = false;



        for (Iterator itServ = actDF.getServices().iterator(); itServ.hasNext(); ) {

          String actServ = (String) itServ.next();

//          if (actServ.equalsIgnoreCase(CONSTANTS.META_PREDICTION)) {

            containsPrediction = true;

//          }

        }

        if (containsPrediction) {

          metaAgents.add(actDF.getName());

        }

      }



      if (metaAgents.isEmpty()) {

        MessageBox mbox = new MessageBox(

            "Error!  No meta-agent, no reasoning...",

            "No meta-agent, which knows 'PREDICTION', has been found.");

        mbox.setVisible(true);

        return;

      }



      for (Iterator it = metaAgents.iterator(); it.hasNext(); ) {

        msgQueryPrediction( (String) (it.next()), agentName, city, leader, size);

      }

    }



    void msgQueryPrediction(String metaAgent, String objectAgentName,

                            String city, String leader, String size) {

/*

          Message m = Message.newInstance();



      m.setPerformative(CONSTANTS.QUERY_IF);

      m.setSender(owner.mts.getName());

      m.setReceiver(metaAgent);

      m.setContent(new aglobe.agent.visio.ont.Action(metaAgent,

                                            new ParserNode(new ParserNode[] {

          new ParserNode(PARSERCONST.pnSYMBOL, CONSTANTS.QUERY_IF),

          new ParserNode(CONSTANTS.META_PREDICTION,

                         new ParserNode(new ParserNode[] {

                                        new ParserNode(CONSTANTS.OBJECT_AGENT,

          objectAgentName, PARSERCONST.pnSTRING),

                                        new ParserNode(CONSTANTS.LOCATION, city,

          PARSERCONST.pnSTRING),

                                        new ParserNode(CONSTANTS.TEAM_LEADER,

          new AgentName(leader).getName(), PARSERCONST.pnSTRING),

                                        new ParserNode(CONSTANTS.

          NUMBER_OF_TEAM_MEMBERS, size, PARSERCONST.pnSTRING),

      }))

      }

          )));

      m.setReplyWith('\"' + objectAgentName + '\"');

      m.setLanguage(CONSTANTS.KIF);

      m.setOntology(CONSTANTS.META_REASONING);

      m.setProtocol(CONSTANTS.FIPA_QUERY_IF);

      owner.mts.forward(m);

 */

    }

  }



  /*

  public void objectAgentPrediction(String metaAgentName, ParserNode pn) {

    String prediction;

    if (CONSTANTS.ACCEPT_TASK.equalsIgnoreCase(pn.getChild(0).getContentStr())) {

      prediction = "Accept";

    } else if (CONSTANTS.POSSIBLY_ACCEPT_TASK.equalsIgnoreCase(pn.getChild(0).getContentStr())) {

      double prob = Double.parseDouble(pn.getChild(1).getListParamValStr(CONSTANTS.PROBABILITY));

      prediction = "Possibly accept   " + prob*100 + "%";

    } else if (CONSTANTS.REFUSE_TASK.equalsIgnoreCase(pn.getChild(0).getContentStr())) {

      prediction = "Refuse";

    } else {

      throw new IllegalArgumentException("Not a PREDICTION INFORM");

    }



    addReply(new AgentName(metaAgentName).getName(), prediction);

  }



  void evaluateButton_ancestorAdded(AncestorEvent e) {



  }

*/

}



class QueryDialog_evaluateButton_ancestorAdapter implements javax.swing.event.AncestorListener {

  QueryDialog adaptee;



  QueryDialog_evaluateButton_ancestorAdapter(QueryDialog adaptee) {

    this.adaptee = adaptee;

  }

  public void ancestorAdded(AncestorEvent e) {

//    adaptee.evaluateButton_ancestorAdded(e);

  }

  public void ancestorRemoved(AncestorEvent e) {

  }

  public void ancestorMoved(AncestorEvent e) {

  }

}
