/**
 * Title:        Visualizer for CPlanT
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Gerstner Laboratory, FEL-�VUT, Prague
 * @author Michal Dob�ek
 * @version 1.0
 */

package across.visio.visual;

// JAVA imports
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Stroke;

import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

// MY imports

/**
 * <p><code>PhantomBorder</code> is used by <code>PhantomAgent</code>. This class
 * was derived from <code>ShadowBorder</code> by copy-paste and by replacing
 * the word "<code>Shadow</code>" by "<code>Phantom</code>". In adition to
 * <code>ShadowBorder</code>, this draws aditional dashed-line.</p>
 *
 * @see ShadowBorder
 * @see PhantomAgent
 */

public class PhantomBorder extends AbstractBorder implements DISPLAYCONST
{
  private static Border _standardshadow;

  protected int   _thickness;
  protected Color _shadowcolor;
  protected Color _backcolor;

  final static float dash1[] = {1.0f, 2.0f};
  final static BasicStroke dashed = new BasicStroke(1.0f,
                                                    BasicStroke.CAP_BUTT,
                                                    BasicStroke.JOIN_MITER,
                                                    10.0f, dash1, 0.0f);


  public PhantomBorder(int thickness, Color shadowcolor, Color backcolor)
  {
    _thickness= thickness;
    _shadowcolor= shadowcolor;
    _backcolor= backcolor;
  }

  public PhantomBorder()
  {
    this(SHADOWTHICK, SHADOWCOLOR, SHADOWBCOLOR);
  }

  public static Border createStandardShadow()
  {
    if(_standardshadow==null)
      _standardshadow= new PhantomBorder();

    return _standardshadow;
  }

  public void paintBorder(Component c, Graphics g, int x, int y, int width, int height)
  {
    Graphics2D g2= (Graphics2D)g;
    Color oldColor = g.getColor();
    Stroke oldStroke= g2.getStroke();
    int i;

    g.setColor(_shadowcolor);
    for(i = 0; i < _thickness; i++)
    {
      g.drawLine( x+_thickness, y+height-i-1, x+width, y+height-i-1);
      g.drawLine( x+width-i-1, y+_thickness, x+width-i-1, y+width);
    }
    g.setColor(_backcolor);
    for(i = 0; i < _thickness; i++)
    {
      g.drawLine( x, y+height-i-1, x+_thickness-1, y+height-i-1);
      g.drawLine( x+width-i-1, y, x+width-i-1, y+_thickness-1);
    }

    // This it the Phantom's Special
    g2.setStroke(dashed);
    g2.setColor(_shadowcolor);
    g2.drawLine( x, y, x, y+height-_thickness-1);
    g2.drawLine( x, y, x+width-_thickness-1, y);
    g2.drawLine( x+width-_thickness-1, y+height-_thickness-1, x+width-_thickness-1, y);
    g2.drawLine( x+width-_thickness-1, y+height-_thickness-1, x, y+height-_thickness-1);

    g.setColor(oldColor);
    g2.setStroke(oldStroke);
  }

  /**
   * Returns the insets of the border.
   * @param c the component for which this border insets value applies
   */
  public Insets getBorderInsets(Component c)
  {
    return new Insets(0, 0, _thickness, _thickness);
  }

  /**
   * Returns whether or not the border is opaque.
   */
  public boolean isBorderOpaque()
  {
    return false;
  }

}