/**
 * Title:        Visualizer for CPlanT
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Gerstner Laboratory, FEL-�VUT, Prague
 * @author Michal Dob�ek
 * @version 1.0
 */

package across.visio.visual;

// JAVA imports
import java.awt.Color;

import across.visio.VisualAgent;

/**
 * <p>
 * <code>DISPLAYCONS</code> interface is implemented by <code>VisAgent</code>,
 * <code>VisAlliance</code> and <code>PhantomAgent</code>. It provides the common
 * source for the constants. Most of them are loaded from config <code>.xml</code>
 * file.</p>
 *
 * @see aglobe.agent.visio.Config
 */

public interface DISPLAYCONST
{

  public static final int AGENTWIDTH     = VisualAgent.getConfig().getWidth();
  public static final int AGENTHEIGHT    = VisualAgent.getConfig().getHeight();
  public static final Color AGENTTXTCOLOR= Color.black;

  public static final int SHADOWTHICK    = VisualAgent.getConfig().getShadow();
  public static final Color SHADOWCOLOR  = Color.darkGray;
  public static final Color SHADOWBCOLOR = Color.lightGray;

  public static final int MINAGENTSPERROW = 3;
  public static final int HGAP            = VisualAgent.getConfig().getHGap();
  public static final int VGAP            = VisualAgent.getConfig().getVGap();
  public static final int AGENTCENTER     = (AGENTWIDTH)>>1;

  public static final int ROWHEIGHT       = AGENTHEIGHT+VGAP;
  public static final int COLWIDTH        = AGENTWIDTH+HGAP;

  public static final String NAMEPREFIX = VisualAgent.getConfig().getPrefix();
  public static final String NAMESUFFIX = VisualAgent.getConfig().getSuffix();
}