/**
 * Title:        Visualizer for CPlanT
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Gerstner Laboratory, FEL-�VUT, Prague
 * @author Michal Dob�ek
 * @version 1.0
 */

package across.visio.ont;

// JAVA imports
import java.net.URL;
import java.util.Set;

// MY imports
//import aglobe.agent.visio.parser.*;

/**
 * <code>DFAgentDescription</code> is object representation of %subj%. It
 * is almost identical to FIPA DFAgentDescription.
 *
 * @see cplantvis.MessageAnalyser
 */

public class DFAgentDescription
{

  private String _name= null;
  private String _type= null;

  private Set _services= null;
  private Set  _protocols= null;
  private Set  _ontologies= null;
  private Set  _languages= null;

  private URL  _address= null;

  private String _owner= null;

  public DFAgentDescription(String name, String type, String owner) {
    setName(name);
    setType(type);
    setOwner(owner);
  }

  public String getName() { return _name; }
  public String getType() { return _type; }
  public Set    getServices() { return _services; }
  public Set    getProtocols() { return _protocols; }
  public Set    getOntologies() { return _ontologies; }
  public Set    getLanguages() { return _languages; }
  public URL    getAddress() { return _address; }
  public String getOwner() { return _owner; }

  public void setName(String Name) { _name= Name; }
  public void setType(String Type) { _type= Type; }
  public void setOwner(String Owner) { _owner= Owner; }

}