/**
 * Title:        Visualizer for CPlanT
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Gerstner Laboratory, FEL-�VUT, Prague
 * @author Michal Dob�ek
 * @version 1.0
 */

package across.visio.ont;

// JAVA imports
import java.util.LinkedList;
import java.util.List;

// MY impports
//import aglobe.agent.visio.parser.*;

/**
 * <code>AllianceDescription</code> is object representaion of alliance, present
 * in VIEW ... ALLIANCE-MEMBERS message.
 *
 * @see aglobe.agent.visio.MessageAnalyser
 * @see aglobe.agent.visio.MessageAnalyserListener
 */

public class AllianceDescription
{
  List _members;
  String name = null;

  public AllianceDescription()
  {
    _members= new LinkedList();
  }

  public boolean isMember(String name)
  {
    return _members.contains(name);
  }

  public List getMembers()
  {
    return _members;
  }

  public void setMembers(List members) {
    _members = members;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }

  /**
   * Main method just for testing.
   */
  public static void main(String[] args)
  {
    AllianceDescription allianceDescription1 = new AllianceDescription();
  }
}