/**
 * Title:        Visualizer for CPlanT
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Gerstner Laboratory, FEL-�VUT, Prague
 * @author Michal Dob�ek
 * @version 1.0
 */


package across.visio;

// JAVA imports
import java.awt.Color;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

import across.visio.visual.ColorFactory;
import across.visio.visual.VisAgent;
import across.visio.visual.VisAlliance;

// MY imports

/**
 * <p>
 * <code>Config</code> encapsulates the visual configuration file. By default
 * it uses <code>Config.xml</code> embedded in the <code>CPlanTvis.jar</code> file.
 * </p>
 * <p>
 * Structure of the file has to follow Document Type Definition <code>Config.dtd</code>.
 * BUT the <code>.xml</code> file must <strong>NOT</strong> provide the reference
 * to the <code>.dtd</code> file. Otherwise an exception occurs (I don't know why).
 * </p>
 * <p>
 * See <code>Config.dtd</code> for description of all the items.
 * </p>
 * <p>
 * The configuration is directly used by <code>VisAgent</code>, <code>VisAlliance</code>
 * and <code>ColorFactory</code>.
 * </p>
 *
 * @see VisAgent
 * @see VisAlliance
 * @see ColorFactory
 */

public class Config
{
  private static final String CONFIGURATION = "CONFIGURATION";

  private static final String AGENT = "AGENT";
  private static final String WIDTH = "WIDTH";
  private static final String HEIGHT= "HEIGHT";
  private static final String SHADOW= "SHADOW";
  private static final String HGAP= "HGAP";
  private static final String VGAP= "VGAP";
  private static final String PREFIX= "PREFIX";
  private static final String SUFFIX= "SUFFIX";

  private static final String AUTOARRANGE= "AUTOARRANGE";
  private static final String TILE = "TILE";
  private static final String CASCADE = "CASCADE";
  private static final String NONE = "NONE";

  private static final String COLORS= "COLORS";
  private static final String COLOR= "COLOR";
  private static final String RED= "RED";
  private static final String GREEN= "GREEN";
  private static final String BLUE= "BLUE";

  private static final String NAMES= "NAMES";
  private static final String NAME= "NAME";
  private static final String LONG= "LONG";
  private static final String SHORT= "SHORT";

  private int Width;
  private int Height;
  private int Shadow;
  private int HGap;
  private int VGap;
  private String Prefix;
  private String Suffix;

  private boolean AutoArrange;
  private boolean TileArrange;

  private List   Colors= new LinkedList();
  private Map    Names= new TreeMap();


  public Config() throws IOException
  {
    init(Config.class.getResource("Config.xml").openStream());
  }

  public Config(String filename) throws FileNotFoundException
  {
    init(new FileInputStream(filename));
  }

  private void init(InputStream is)
  {
    // Step 1: create a DocumentBuilderFactory and configure it
    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();

    // Optional: set various configuration options
    dbf.setValidating(false);
/** @todo REMOVED    dbf.setIgnoringComments(true); */
/** @todo REMOVED    dbf.setIgnoringElementContentWhitespace(true); */
//    dbf.setCoalescing(putCDATAIntoText);
//    // The opposite of creating entity ref nodes is expanding them inline
//    dbf.setExpandEntityReferences(true);

    // Step 2: create a DocumentBuilder that satisfies the constraints
    // specified by the DocumentBuilderFactory
    DocumentBuilder db = null;
    try {
        db = dbf.newDocumentBuilder();
    } catch (ParserConfigurationException pce) {
        System.err.println(pce);
        System.exit(1);
    }

//    // Set an ErrorHandler before parsing
//    OutputStreamWriter errorWriter =
//        new OutputStreamWriter(System.err, outputEncoding);
//    db.setErrorHandler(
//        new MyErrorHandler(new PrintWriter(errorWriter, true)));

    // Step 3: parse the input file
    Document doc = null;
    try {
        doc = db.parse(is);
    } catch (SAXException se) {
        System.err.println(se.getMessage());
        System.exit(1);
    } catch (IOException ioe) {
        System.err.println(ioe);
        System.exit(1);
    }

    Element root= doc.getDocumentElement();

    if(root.getTagName().equals(CONFIGURATION))
    {
      Element agent= getChildElement(root, AGENT);
      Element colors= getChildElement(root, COLORS);
      Element names= getChildElement(root, NAMES);

//      if(agent!=null)  Throw exception instead, should be caught by VisualAgent main method
      {
        Width= Integer.parseInt(getChildElement(agent, WIDTH).getFirstChild().getNodeValue());
        Height= Integer.parseInt(getChildElement(agent, HEIGHT).getFirstChild().getNodeValue());
        Shadow= Integer.parseInt(getChildElement(agent, SHADOW).getFirstChild().getNodeValue());
        HGap= Integer.parseInt(getChildElement(agent, HGAP).getFirstChild().getNodeValue());
        VGap= Integer.parseInt(getChildElement(agent, VGAP).getFirstChild().getNodeValue());
        Prefix= getChildElement(agent, PREFIX).getFirstChild().getNodeValue();
        Suffix= getChildElement(agent, SUFFIX).getFirstChild().getNodeValue();
        String Arrange= getChildElement(agent, AUTOARRANGE).getFirstChild().getNodeValue();
        if(Arrange.equalsIgnoreCase(TILE))
        {
          AutoArrange= true;
          TileArrange= true;
        }
        else if(Arrange.equalsIgnoreCase(CASCADE))
        {
          AutoArrange= true;
          TileArrange= false;
        }
        else if(Arrange.equalsIgnoreCase(NONE))
        {
          AutoArrange= false;
          TileArrange= true;
        }
        else
        {
          System.out.println("Wrong AUTOARRANGE value in .xml config");
          AutoArrange= false;
          TileArrange= false;
        }
      }

//      if(colors!=null)  Throw exception instead, should be caught by VisualAgent main method
      {
        Node c= colors.getFirstChild();
        while(c!=null)
        {
          if( (c instanceof Element) && (((Element)c).getTagName().equals(COLOR)))
          {
            Element col= (Element)c;
            int r= Integer.parseInt(getChildElement(col, RED).getFirstChild().getNodeValue());
            int g= Integer.parseInt(getChildElement(col, GREEN).getFirstChild().getNodeValue());
            int b= Integer.parseInt(getChildElement(col, BLUE).getFirstChild().getNodeValue());

            Colors.add(new Color(r, g, b));
          }
          c= c.getNextSibling();
        }
      }

      if(names!=null)
      {
        Node n= names.getFirstChild();
        while(n!=null)
        {
          if( (n instanceof Element) && (((Element)n).getTagName().equals(NAME)))
          {
            Element name= (Element)n;
            String longn= getChildElement(name, LONG).getFirstChild().getNodeValue();
            String shortn= getChildElement(name, SHORT).getFirstChild().getNodeValue();
            Names.put(longn, shortn);
          }
          n= n.getNextSibling();
        }
      }
    }
  }

  private Element getChildElement(Element e, String ch)
  {
    Node n= e.getFirstChild();
    while(n!=null)
    {
      if(n instanceof Element)
        if(((Element)n).getTagName().equals(ch))
          return (Element)n;

      n= n.getNextSibling();
    }
    return null;
  }

  public List getColors()
  {
    return Colors;
  }
  public int getHeight()
  {
    return Height;
  }
  public int getHGap()
  {
    return HGap;
  }
  public Map getNames()
  {
    return Names;
  }
  public String getPrefix()
  {
    return Prefix;
  }
  public int getShadow()
  {
    return Shadow;
  }
  public String getSuffix()
  {
    return Suffix;
  }
  public int getVGap()
  {
    return VGap;
  }
  public int getWidth()
  {
    return Width;
  }
  public boolean getAutoArrange()
  {
    return AutoArrange;
  }
  public boolean getTileArrange()
  {
    return TileArrange;
  }

  /**
   * main methodj ust for testing.
   */
  public static void main(String[] args) throws Exception
  {
    Config c= new Config("c:/petr/projekty/across/xml/alianvisiocfg.xml");
  }
}
