package across.util.skn.util.membership.iterative;

import across.util.skn.util.FuzzySet;
import across.util.skn.util.membership.FuzzyNumberMembership;
import across.util.skn.util.membership.Point;

/**
 * Mean and sigma defined fuzzy number membership.
 * This class uses variance estimate to compute sigma and to use it for membership definition.
 *  */
public class SigmaMembership<MemberObject> extends FuzzyNumberMembership<MemberObject>
{
    public SigmaMembership(MemberObject memberObject, FuzzySet set) {
        super(memberObject, set, (Point)null);
        // prepare the default values for points...
        points.add(new Point(0,0));
        points.add(new Point(0.5,1));
        points.add(new Point(1,0));
    }

    /** We set a triangular shape, with the avg with membership 1 and the bounds on mean-sigma/2, mean+sigma/2.
     * If the bounds are under zero or above 1, we crop.*/
    public void applyChangesToShape()
    {
        double sigma = Math.sqrt(getVariance());
        // while setting the sigmas, we must make sure not to get under zero or above 1
        // set the left bound
        if (avg - sigma >= 0 || sigma == 0)
        {
            points.get(0).setX(avg-sigma);
            points.get(0).setY(0);
        }
        else
        {
            points.get(0).setX(0);
            points.get(0).setY(1-avg/sigma);
        }
        // se the right bound
        if (avg + sigma <= 1 || sigma == 0)
        {
            points.get(2).setX(avg+sigma);
            points.get(2).setY(0);
        }
        else
        {
            points.get(2).setX(0);
            points.get(2).setY(1-(1-avg)/sigma);
        }
        // set the average... no problem...
        points.get(1).setX(avg);
        points.get(1).setY(1);
    }
}
