package across.util.skn.util.membership.iterative;

import across.util.skn.util.FuzzySet;
import across.util.skn.util.membership.FuzzyNumberMembership;
import across.util.skn.util.membership.Point;

/**
 * Represents the membership with triangular fuzzy number shape. Mean is core, min is left limit and max right.
 */
public class MinMeanMaxMembership<MemberObject> extends FuzzyNumberMembership<MemberObject> {

    public MinMeanMaxMembership(MemberObject memberObject, FuzzySet set) {
        super(memberObject, set, (Point)null);
        // prepare the default values for points...
        points.add(new Point(0,0));
        points.add(new Point(0.5,1));
        points.add(new Point(1,0));
    }

    /** We set a triangular shape, with the avg with membership 1 and the bounds on min, max.*/
    public void applyChangesToShape() {
        points.get(0).setX(min);
        points.get(2).setX(max);
        points.get(1).setX(avg);
        points.get(1).setY(1);
    }
}
