package across.util.skn.util.membership.iterative;

import across.util.skn.util.FuzzySet;
import across.util.skn.util.membership.FuzzyNumberMembership;
import across.util.skn.util.membership.Point;

/**
* This membership function is like sigma membership, except that we crop the values if we would get over max or under min.
 * More formally, it is a treiangular fuzzy number with left bound = max(avg-sigma/2,minValue) and similar right bound.
 */
public class AsymetricSigmaMembership<MemberObject> extends FuzzyNumberMembership<MemberObject>{

    public void applyChangesToShape()
    {
        double sigma = Math.sqrt(getVariance());
        points.get(0).setXY(Math.max(avg - sigma, min),0);
        points.get(2).setXY(Math.min(avg + sigma, max),0);
        points.get(1).setXY(avg,1);
    }

    public AsymetricSigmaMembership(MemberObject memberObject, FuzzySet set) {
        super(memberObject, set, (Point)null);
        points.add(new Point(0,0));
        points.add(new Point(0.5,1));
        points.add(new Point(1,0));
    }
}
