package across.util.skn.util.membership;

/**
 * Class for x,y pair on [0,1]*[0,1] interval.
 * The function representing membership is linear by segment. Point class is used to separate the different segments.
 */
public class Point extends PairDouble implements Comparable
{

    /** Creates the point and sets the values.
     * @param x x coordinate, bounded to [0,1]
     * @param y y coordinate, bounded to [0,1]
     */
    public Point(double x, double y) {
        super(Math.min(Math.max(x,0),1), Math.min(Math.max(y,0),1));
    }

    public void setX(double x) {
        this.x = Math.min(Math.max(x,0),1);
    }

    public void setY(double y) {
        this.y = Math.min(Math.max(y,0),1);
    }

    public void setXY(double x, double y) {
        this.x = Math.min(Math.max(x,0),1);
        this.y = Math.min(Math.max(y,0),1);
    }

    /**
     * Compares two points. Compares x coordinate only !!!! This allows easy replacing in tree sets if necessary...
     * @param o the Object to be compared.
     * @return a negative integer, zero, or a positive integer as this object
     *         is less than, equal to, or greater than the specified object.
     * @throws ClassCastException if the specified object's type prevents it
     *                            from being compared to this Object.
     */
    public int compareTo(Object o) {
        if (o instanceof Point)
        {
            Point p = (Point) o;
            if (x < p.x) return -1;
            if (x == p.x) return 0;
            return 1;
        }
        throw new ClassCastException("Can not compare with Point, incompatible type.");
    }
}
