package across.util.skn.util.membership;

/**
 * Created by IntelliJ IDEA.
 * User: rehakm1
 * Date: 12.11.2004
 * Time: 12:17:35
 * To change this template use File | Settings | File Templates.
 */
public interface MembershipInterface extends Comparable
{
    /** Returns true if incidence with the set is nonzero, i.e. if membership function is not zero for this member. */
    boolean isMember();

    /** Returns true if incidence with the core of the set is nonzero, i.e. if membership function is maximum, typically 1 */
    boolean isCoreMember();

    /** Returns the center of the membership function.
     * @return center of the function, shape specific. Bounded to [0,1] interval. */
    double getMembershipFunctionCenter();

    /** Returns the uncertainity of the membership function. */
    double getMembershipFunctionUncertainity();
}
